/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.promotion.server.service.impl;

import com.github.pagehelper.PageInfo;
import com.ztesoft.zsmart.nros.base.exception.ExceptionHandler;
import com.ztesoft.zsmart.nros.sbc.promotion.client.api.RuleService;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.ConditionDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.RuleDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.AssociationRuleSaveParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.RuleDeleteParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.RuleSaveParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.RuleQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.YesOrNoEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.util.NrosPreconditions;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.coupon.CouponDomain;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.promotion.PromotionDomain;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.RuleDomain;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RuleServiceImpl
implements RuleService {
    private static final Logger logger = LoggerFactory.getLogger(RuleServiceImpl.class);
    @Autowired
    private RuleDomain ruleDomain;
    @Autowired
    private PromotionDomain promotionDomain;
    @Autowired
    private CouponDomain couponDomain;

    @Transactional(rollbackFor={Exception.class})
    public Long saveRule(RuleSaveParam ruleSaveParam) {
        Long ruleId = ruleSaveParam.getId();
        if (ruleSaveParam.getId() == null) {
            ruleId = this.ruleDomain.addRule(ruleSaveParam);
        } else {
            this.ruleDomain.modifyRule(ruleSaveParam);
        }
        return ruleId;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteRule(RuleDeleteParam ruleDeleteParam) {
        if (ruleDeleteParam.getId() == null) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-RULE-0001");
        }
        this.ruleDomain.deleteRule(ruleDeleteParam);
    }

    public PageInfo<RuleDTO> pageRule(RuleQuery ruleQuery) {
        return this.ruleDomain.pageRule(ruleQuery);
    }

    public RuleDTO detailRule(RuleQuery ruleQuery) {
        return this.ruleDomain.detailRule(ruleQuery.getId());
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveCouponRule(AssociationRuleSaveParam couponRuleSaveParam) {
        RuleSaveParam ruleSaveParam = couponRuleSaveParam.getRuleSaveParam();
        NrosPreconditions.getInstance().notNull(ruleSaveParam, "NROS-SBC-PROMOTION-COUPON-0027");
        Long ruleId = this.saveRule(ruleSaveParam);
        Long couponAmt = this.couponDomain.couponAmtCompute(ruleSaveParam);
        this.couponDomain.saveCouponRuleRelationship(ruleId, couponRuleSaveParam.getRuleSaveParam().getName(), couponRuleSaveParam.getCouponCode(), couponAmt);
    }

    @Transactional(rollbackFor={Exception.class})
    public void savePromotionRule(AssociationRuleSaveParam couponRuleSaveParam) {
        RuleSaveParam ruleSaveParam = couponRuleSaveParam.getRuleSaveParam();
        NrosPreconditions.getInstance().notNull(ruleSaveParam, "NROS-SBC-PROMOTION-COUPON-0027");
        Long ruleId = this.saveRule(ruleSaveParam);
        this.promotionDomain.updatePromotionWithRule(ruleId, couponRuleSaveParam.getRuleSaveParam().getName(), couponRuleSaveParam.getPromotionId());
    }

    public List<ConditionDTO> listConditionDetailByRuleList(List<Long> ruleIds) {
        return this.ruleDomain.listConditionDetailByRuleList(ruleIds);
    }

    private void checkBeforeModify(Long ruleId) {
        if (ruleId == null) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-RULE-0001");
        }
        Integer promotionCount = this.promotionDomain.getPromotionCountByRuleId(ruleId);
        Integer singleGoodsCount = this.promotionDomain.getSingleGoodsCountByRuleId(ruleId);
        Integer couponCount = this.couponDomain.getCouponCountByRuleId(ruleId);
        promotionCount = promotionCount == null || promotionCount < 0 ? 0 : promotionCount;
        singleGoodsCount = singleGoodsCount == null || singleGoodsCount < 0 ? 0 : singleGoodsCount;
        couponCount = couponCount == null || couponCount < 0 ? 0 : couponCount;
        Integer sum = promotionCount + singleGoodsCount + couponCount;
        if (!YesOrNoEnum.NO.getValue().equals(sum.toString())) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-RULE-0004");
        }
    }
}

