/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.promotion.server.service.impl;

import com.github.pagehelper.PageInfo;
import com.ztesoft.zsmart.nros.base.exception.ExceptionHandler;
import com.ztesoft.zsmart.nros.sbc.promotion.client.api.PromotionService;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.AllGoodsDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.GoodsRangeDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.PromotionDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.RuleDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.SingleGoodsDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.SingleGoodsDetailDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.ConditionParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.DiscountParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.GoodsRangeDeleteParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.GoodsRangeParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.PromotionDeleteParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.PromotionParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.RuleSaveParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.SingleGoodsDeleteParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.SingleGoodsParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.GoodsRangeQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.PromotionQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.SingleGoodsQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.ConditionLoopEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.ConditionTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.DiscountTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.PromotionTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.YesOrNoEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.util.NrosPreconditions;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.promotion.PromotionDomain;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.promotion.model.PromotionBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.promotion.model.SingleGoodsBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.RuleDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PromotionServiceImpl
implements PromotionService {
    private static final Logger logger = LoggerFactory.getLogger(PromotionServiceImpl.class);
    @Autowired
    private PromotionDomain promotionDomain;
    @Autowired
    private RuleDomain ruleDomain;

    @Transactional(rollbackFor={Exception.class})
    public Long savePromotionInfo(PromotionParam promotionParam) {
        if (promotionParam.getId() == null) {
            if (PromotionTypeEnum.TRANSPORT_FARE.getState().equals(promotionParam.getPromotionType())) {
                RuleSaveParam ruleSaveParam = this.builderRuleSaveParam(promotionParam.getDiscountName(), promotionParam.getAmountOfMoney(), null);
                Long ruleId = this.ruleDomain.addRule(ruleSaveParam);
                promotionParam.setRuleId(ruleId);
            }
            return this.promotionDomain.savePromotionInfo(promotionParam);
        }
        if (PromotionTypeEnum.TRANSPORT_FARE.getState().equals(promotionParam.getPromotionType())) {
            RuleSaveParam ruleSaveParam = this.builderRuleSaveParam(promotionParam.getDiscountName(), promotionParam.getAmountOfMoney(), promotionParam.getRuleId());
            this.ruleDomain.modifyRule(ruleSaveParam);
        }
        return this.promotionDomain.modifyPromotionInfo(promotionParam);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deletePromotion(PromotionDeleteParam promotionDeleteParam) {
        if (promotionDeleteParam.getId() == null) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-0002");
        }
        this.promotionDomain.deletePromotion(promotionDeleteParam);
    }

    public PageInfo<PromotionDTO> pagePromotion(PromotionQuery promotionQuery) {
        return this.promotionDomain.pagePromotion(promotionQuery);
    }

    public PromotionDTO detailPromotion(PromotionQuery promotionQuery) {
        PromotionDTO promotionDTO = this.promotionDomain.detailPromotion(promotionQuery);
        if (promotionDTO.getRuleId() != null) {
            RuleDTO ruleDTO = this.ruleDomain.detailRule(promotionDTO.getRuleId());
            promotionDTO.setRuleDTO(ruleDTO);
        }
        return promotionDTO;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long saveGoodsRange(GoodsRangeParam goodsRangeParam) {
        NrosPreconditions.getInstance().notNull(goodsRangeParam.getPromotionId(), "NROS-SBC-PROMOTION-0002");
        NrosPreconditions.getInstance().hasText(goodsRangeParam.getRangeCode(), "NROS-SBC-PROMOTION-0020");
        NrosPreconditions.getInstance().hasText(goodsRangeParam.getRangeName(), "NROS-SBC-PROMOTION-0021");
        return this.promotionDomain.saveGoodsRange(goodsRangeParam);
    }

    @Transactional(rollbackFor={Exception.class})
    public void incrementSaveGoodsRanges(List<GoodsRangeParam> goodsRangeParams) {
        this.promotionDomain.incrementSaveGoodsRanges(goodsRangeParams);
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchSaveGoodsRanges(List<GoodsRangeParam> goodsRangeParams) {
        this.promotionDomain.batchSaveGoodsRanges(goodsRangeParams);
    }

    public PageInfo<SingleGoodsDTO> pageSingleGoods(SingleGoodsQuery singleGoodsQuery) {
        return this.promotionDomain.pageSingleGoods(singleGoodsQuery);
    }

    public PageInfo<GoodsRangeDTO> pageGoodsRange(GoodsRangeQuery goodsRangeQuery) {
        return this.promotionDomain.pageGoodsRange(goodsRangeQuery);
    }

    public SingleGoodsDetailDTO detailSingleGoods(SingleGoodsQuery singleGoodsQuery) {
        SingleGoodsDetailDTO singleGoodsDetailDTO = this.promotionDomain.detailSingleGoodsById(singleGoodsQuery);
        if (singleGoodsDetailDTO.getRuleId() != null) {
            RuleDTO ruleDTO = this.ruleDomain.detailRule(singleGoodsDetailDTO.getRuleId());
            singleGoodsDetailDTO.setRuleDTO(ruleDTO);
        }
        return singleGoodsDetailDTO;
    }

    public Integer deleteSingleGoods(SingleGoodsDeleteParam singleGoodsDeleteParam) {
        return this.promotionDomain.deleteSingleGoods(singleGoodsDeleteParam);
    }

    @Transactional(rollbackFor={Exception.class})
    public Long saveSingleGoods(SingleGoodsParam singleGoodsParam) {
        NrosPreconditions.getInstance().notNull(singleGoodsParam.getPromotionId(), "NROS-SBC-PROMOTION-0002");
        NrosPreconditions.getInstance().hasText(singleGoodsParam.getRuleName(), "NROS-SBC-PROMOTION-RULE-0003");
        NrosPreconditions.getInstance().hasText(singleGoodsParam.getSkuCode(), "NROS-SBC-PROMOTION-0017");
        NrosPreconditions.getInstance().hasText(singleGoodsParam.getSkuName(), "NROS-SBC-PROMOTION-0018");
        if (singleGoodsParam.getId() == null) {
            Long ruleId = this.ruleDomain.addRule(singleGoodsParam.getRuleSaveParam());
            singleGoodsParam.setRuleId(ruleId);
            return this.promotionDomain.saveSingleGoods(singleGoodsParam);
        }
        this.ruleDomain.modifyRule(singleGoodsParam.getRuleSaveParam());
        return this.promotionDomain.modifySingleGoods(singleGoodsParam);
    }

    @Transactional(rollbackFor={Exception.class})
    public Integer updatePromotionWithRule(PromotionParam promotionParam) {
        this.promotionDomain.updatePromotionWithRule(promotionParam.getRuleId(), promotionParam.getRuleName(), promotionParam.getId());
        return 1;
    }

    @Transactional(rollbackFor={Exception.class})
    public Integer enablePromotion(PromotionParam promotionParam) {
        this.promotionDomain.clearPromotionCache();
        this.ruleDomain.clearRuleCache("PMS_RULE_CACHE_PROMOTION_KEY");
        this.promotionDomain.enablePromotion(promotionParam);
        List<PromotionBO> promotionBOS = this.promotionDomain.refreshPromotionCache();
        List<Long> ruleIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(promotionBOS)) {
            ruleIds = promotionBOS.stream().map(PromotionBO::getRuleId).collect(Collectors.toList());
            List singleGoodsRuleIds = promotionBOS.stream().filter(o -> PromotionTypeEnum.SINGLE.getState().equals(o.getPromotionType())).flatMap(o -> o.getSingleGoodsList().stream().map(SingleGoodsBean::getRuleId)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(singleGoodsRuleIds)) {
                ruleIds.addAll(singleGoodsRuleIds);
            }
        }
        this.ruleDomain.refreshRuleCache("PMS_RULE_CACHE_PROMOTION_KEY", ruleIds);
        return 1;
    }

    @Transactional(rollbackFor={Exception.class})
    public Integer disablePromotion(PromotionParam promotionParam) {
        this.promotionDomain.clearPromotionCache();
        this.ruleDomain.clearRuleCache("PMS_RULE_CACHE_PROMOTION_KEY");
        this.promotionDomain.disablePromotion(promotionParam);
        List<PromotionBO> promotionBOS = this.promotionDomain.refreshPromotionCache();
        List<Long> ruleIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(promotionBOS)) {
            ruleIds = promotionBOS.stream().map(PromotionBO::getRuleId).collect(Collectors.toList());
            List singleGoodsRuleIds = promotionBOS.stream().filter(o -> PromotionTypeEnum.SINGLE.getState().equals(o.getPromotionType())).flatMap(o -> o.getSingleGoodsList().stream().map(SingleGoodsBean::getRuleId)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(singleGoodsRuleIds)) {
                ruleIds.addAll(singleGoodsRuleIds);
            }
        }
        this.ruleDomain.refreshRuleCache("PMS_RULE_CACHE_PROMOTION_KEY", ruleIds);
        return 1;
    }

    @Transactional(rollbackFor={Exception.class})
    public Integer deleteGoodsRange(GoodsRangeDeleteParam goodsRangeDeleteParam) {
        return this.promotionDomain.deleteGoodsRange(goodsRangeDeleteParam);
    }

    @Transactional(rollbackFor={Exception.class})
    public Integer saveGoodsRangeType(PromotionParam promotionParam) {
        this.promotionDomain.saveGoodsRangeType(promotionParam);
        return 1;
    }

    public AllGoodsDTO listAllGoods(PromotionQuery promotionQuery) {
        if (null != promotionQuery) {
            return this.promotionDomain.listAllGoods(promotionQuery);
        }
        return null;
    }

    private RuleSaveParam builderRuleSaveParam(String discountName, Long amountOfMoney, Long ruleId) {
        RuleSaveParam ruleSaveParam = new RuleSaveParam();
        ruleSaveParam.setId(ruleId);
        ruleSaveParam.setConditionLoop(ConditionLoopEnum.UN_LOOP.getState());
        ruleSaveParam.setDiscountType(DiscountTypeEnum.FULL_FREIGHT.getState());
        ruleSaveParam.setMultipleCondition(YesOrNoEnum.NO.getValue());
        ConditionParam conditionParam = new ConditionParam();
        conditionParam.setConditionType(ConditionTypeEnum.AMT.getState());
        conditionParam.setAmountOfMoney(amountOfMoney);
        conditionParam.setAction("1");
        conditionParam.setDiscountName(discountName);
        DiscountParam discountParam = new DiscountParam();
        discountParam.setFreeFreight(YesOrNoEnum.YES.getValue());
        conditionParam.setDiscount(discountParam);
        ruleSaveParam.setRuleConditions(Arrays.asList(conditionParam));
        return ruleSaveParam;
    }
}

