/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.promotion.server.service.impl;

import com.github.pagehelper.PageInfo;
import com.ztesoft.zsmart.nros.base.annotation.DistributedLock;
import com.ztesoft.zsmart.nros.base.exception.ExceptionHandler;
import com.ztesoft.zsmart.nros.sbc.promotion.client.api.CouponService;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.CouponCodeStatusDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.CouponDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.CouponGoodsRangeDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.CouponInstanceDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.CouponReceiveRecordsDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.CouponReservedAndCheckedDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.RuleDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.CancelReceiveCouponParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.ConditionParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.CouponBatchSendParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.CouponConsumeParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.CouponDeleteParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.CouponGoodsRangeDeleteParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.CouponGoodsRangeParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.CouponSaveParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.DiscountParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.InvalidCouponParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.LockCouponParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.ReceiveCouponParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.RuleDeleteParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.RuleSaveParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.CouponCodeQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.CouponInstanceQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.CouponQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.CouponReceiveListQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.ConditionLoopEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.ConditionTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.CouponTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.DiscountTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.YesOrNoEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.coupon.CouponDomain;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.coupon.model.CouponBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.promotion.PromotionDomain;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.RuleDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CouponServiceImpl
implements CouponService {
    @Autowired
    private CouponDomain couponDomain;
    @Autowired
    private PromotionDomain promotionDomain;
    @Autowired
    private RuleDomain ruleDomain;

    @Transactional(rollbackFor={Exception.class})
    public String save(CouponSaveParam couponSaveParam) {
        if (CouponTypeEnum.FREIGHT.getState().equals(couponSaveParam.getCouponType())) {
            RuleSaveParam ruleSaveParam = this.builderRuleSaveParam(couponSaveParam.getDiscountName(), couponSaveParam.getReducePrice(), null);
            Long ruleId = this.ruleDomain.addRule(ruleSaveParam);
            couponSaveParam.setRuleId(ruleId);
        }
        return this.couponDomain.addCoupon(couponSaveParam);
    }

    public CouponDTO findByCouponCode(String couponCode) {
        return this.couponDomain.findByCouponCode(couponCode);
    }

    public void saveGoodsRangeType(CouponSaveParam couponSaveParam) {
        this.couponDomain.saveGoodsRangeType(couponSaveParam);
    }

    @Transactional(rollbackFor={Exception.class})
    public Long saveCouponGoodsRange(CouponGoodsRangeParam couponGoodsRangeParam) {
        return this.couponDomain.saveCouponGoodsRange(couponGoodsRangeParam);
    }

    @Transactional(rollbackFor={Exception.class})
    public void incrementSaveGoodsRanges(List<CouponGoodsRangeParam> params) {
        this.couponDomain.incrementSaveGoodsRanges(params);
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchSaveGoodsRanges(List<CouponGoodsRangeParam> params) {
        this.couponDomain.batchSaveGoodsRanges(params);
    }

    public List<CouponGoodsRangeDTO> listCouponGoodsRangeByCouponCode(String couponCode) {
        return this.couponDomain.listCouponGoodsRangeByCouponCode(couponCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public void modify(CouponSaveParam couponSaveParam) {
        if (CouponTypeEnum.FREIGHT.getState().equals(couponSaveParam.getCouponType())) {
            RuleSaveParam ruleSaveParam = this.builderRuleSaveParam(couponSaveParam.getDiscountName(), couponSaveParam.getReducePrice(), couponSaveParam.getRuleId());
            this.ruleDomain.modifyRule(ruleSaveParam);
        }
        this.couponDomain.modifyCoupon(couponSaveParam);
    }

    public PageInfo<CouponDTO> listAllCoupon(CouponQuery couponQuery) {
        return this.couponDomain.listAllCoupon(couponQuery);
    }

    public CouponDTO details(String couponCode) {
        CouponDTO couponDTO = this.couponDomain.details(couponCode);
        if (couponDTO.getRuleId() != null) {
            RuleDTO ruleDTO = this.ruleDomain.detailRule(couponDTO.getRuleId());
            couponDTO.setRuleDTO(ruleDTO);
        }
        return couponDTO;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<CouponReceiveRecordsDTO> receiveCoupon(ReceiveCouponParam receiveCouponParam) {
        return this.couponDomain.receiveCoupon(receiveCouponParam);
    }

    public PageInfo<CouponReceiveRecordsDTO> pageReceive(CouponReceiveListQuery couponReceiveListQuery) {
        return this.couponDomain.pageReceive(couponReceiveListQuery);
    }

    @Transactional(rollbackFor={Exception.class})
    public void cancelReceiveCoupon(CancelReceiveCouponParam cancelReceiveCouponParam) {
        this.couponDomain.cancelReceiveCoupon(cancelReceiveCouponParam);
    }

    @Transactional(rollbackFor={Exception.class})
    public void activateCoupon(String couponCode) {
        CouponDTO couponDTO = this.couponDomain.details(couponCode);
        RuleDTO ruleDTO = this.ruleDomain.detailRule(couponDTO.getRuleId());
        this.couponDomain.clearCouponCache();
        this.ruleDomain.clearRuleCache("PMS_RULE_CACHE_COUPON_KEY");
        this.couponDomain.activateCoupon(couponCode, ruleDTO);
        this.couponDomain.refreshCouponCache();
        List<CouponBO> couponBOS = this.couponDomain.refreshCouponCache();
        List<Long> ruleIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(couponBOS)) {
            ruleIds = couponBOS.stream().map(CouponBO::getRuleId).collect(Collectors.toList());
        }
        this.ruleDomain.refreshRuleCache("PMS_RULE_CACHE_COUPON_KEY", ruleIds);
    }

    @Transactional(rollbackFor={Exception.class})
    public void invalidCoupon(InvalidCouponParam invalidCouponParam) {
        this.couponDomain.clearCouponCache();
        this.ruleDomain.clearRuleCache("PMS_RULE_CACHE_COUPON_KEY");
        this.couponDomain.invalidCoupon(invalidCouponParam);
        List<CouponBO> couponBOS = this.couponDomain.refreshCouponCache();
        List<Long> ruleIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(couponBOS)) {
            ruleIds = couponBOS.stream().map(CouponBO::getRuleId).collect(Collectors.toList());
        }
        this.ruleDomain.refreshRuleCache("PMS_RULE_CACHE_COUPON_KEY", ruleIds);
    }

    public CouponCodeStatusDTO getCouponCodeByInstanceCode(String instanceCode) {
        return this.couponDomain.getCouponCodeByInstanceCode(instanceCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public void lockCouponInstance(LockCouponParam lockCouponParam) {
        this.couponDomain.lockCouponInstance(lockCouponParam.getInstanceCode(), lockCouponParam.getIsLock());
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchLockCouponInstance(LockCouponParam lockCouponParam) {
        if (CollectionUtils.isNotEmpty((Collection)lockCouponParam.getInstanceCodes())) {
            for (String instanceCode : lockCouponParam.getInstanceCodes()) {
                this.couponDomain.lockCouponInstance(instanceCode, lockCouponParam.getIsLock());
            }
        }
    }

    public int validation(String instanceCode) {
        CouponCodeStatusDTO dto = this.couponDomain.getCouponCodeByInstanceCode(instanceCode);
        if ("0".equals(dto.getStatus())) {
            return 1;
        }
        return 0;
    }

    @Transactional(rollbackFor={Exception.class})
    @DistributedLock(value="NROS-SBC-PROMOTION-COUPON-0016", key="#consumeParam.instanceCode")
    public String consumeCouponInstance(CouponConsumeParam consumeParam) {
        return this.couponDomain.consumeCouponInstance(consumeParam);
    }

    @Transactional(rollbackFor={Exception.class})
    public String cancelConsumeCouponInstance(String instanceCode) {
        return this.couponDomain.cancelConsumeCouponInstance(instanceCode);
    }

    public List<CouponDTO> listCouponByCodeList(CouponCodeQuery couponCodeQuery) {
        return this.couponDomain.listCouponByCodeList(couponCodeQuery);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<CouponReceiveRecordsDTO> batchSend(CouponBatchSendParam couponBatchSendParam) {
        return this.couponDomain.batchSend(couponBatchSendParam);
    }

    public PageInfo<CouponInstanceDTO> pageCouponInstance(CouponInstanceQuery couponMemberIdQuery) {
        PageInfo<CouponInstanceDTO> couponInstanceDTOPageInfo = this.couponDomain.pageCouponInstance(couponMemberIdQuery);
        return couponInstanceDTOPageInfo;
    }

    public CouponInstanceDTO selectCouponInstanceByInstanceCode(String instanceCode) {
        CouponInstanceDTO couponInstanceDTO = this.couponDomain.selectCouponInstanceByInstanceCode(instanceCode);
        couponInstanceDTO.setRuleDTO(this.ruleDomain.detailRule(couponInstanceDTO.getRuleId()));
        return couponInstanceDTO;
    }

    @Transactional(rollbackFor={Exception.class})
    public Integer deleteCouponGoodsRange(CouponGoodsRangeDeleteParam couponGoodsRangeDeleteParam) {
        return this.couponDomain.deleteCouponGoodsRange(couponGoodsRangeDeleteParam);
    }

    public List<CouponReservedAndCheckedDTO> statisticsOfReservedAndChecked(String activeInstanceCode, String activeCode, String startDate, String endDate) {
        return this.couponDomain.statisticsOfReservedAndChecked(activeInstanceCode, activeCode, startDate, endDate);
    }

    public List<CouponReceiveRecordsDTO> queryRecordsByMemberAndCouponCodes(Long memberId, List<String> couponCodes) {
        return this.couponDomain.queryRecordsByMemberAndCouponCodes(memberId, couponCodes);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteCoupon(CouponDeleteParam couponDeleteParam) {
        CouponDTO couponDTO;
        if (couponDeleteParam.getCouponCode() == null) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0008");
        }
        if ((couponDTO = this.couponDomain.deleteCoupon(couponDeleteParam)).getRuleId() != null) {
            RuleDeleteParam ruleDeleteParam = new RuleDeleteParam();
            ruleDeleteParam.setId(couponDTO.getRuleId());
            this.ruleDomain.deleteRule(ruleDeleteParam);
        }
    }

    private RuleSaveParam builderRuleSaveParam(String discountName, Long reducePrice, Long ruleId) {
        RuleSaveParam ruleSaveParam = new RuleSaveParam();
        ruleSaveParam.setId(ruleId);
        ruleSaveParam.setConditionLoop(ConditionLoopEnum.UN_LOOP.getState());
        ruleSaveParam.setDiscountType(DiscountTypeEnum.FULL_FREIGHT.getState());
        ruleSaveParam.setMultipleCondition(YesOrNoEnum.NO.getValue());
        ConditionParam conditionParam = new ConditionParam();
        conditionParam.setConditionType(ConditionTypeEnum.NO_CONDITION.getState());
        conditionParam.setAction("1");
        conditionParam.setDiscountName(discountName);
        DiscountParam discountParam = new DiscountParam();
        discountParam.setReducePrice(reducePrice);
        discountParam.setFreeFreight(YesOrNoEnum.NO.getValue());
        conditionParam.setDiscount(discountParam);
        ruleSaveParam.setRuleConditions(Arrays.asList(conditionParam));
        return ruleSaveParam;
    }
}

