/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.promotion.server.service.impl;

import com.ztesoft.zsmart.nros.base.exception.ExceptionHandler;
import com.ztesoft.zsmart.nros.sbc.promotion.client.api.ActivityComputeService;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.ActivityComputeResultDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.ActivityComputeParam;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.constant.ComputeContants;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.ComputeConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.OrderConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.ActiveTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.CouponTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.PromotionTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.YesOrNoEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.compute.model.ActivityBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.coupon.CouponDomain;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.coupon.model.CouponBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.coupon.model.CouponReceiveRecordsBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.promotion.PromotionDomain;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.promotion.model.PromotionBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.promotion.model.SingleGoodsBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.RuleDomain;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.RuleBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.Calculator;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.ComputeParam;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.ComputeResult;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityComputeServiceImpl
implements ActivityComputeService {
    private static final Logger logger = LoggerFactory.getLogger(ActivityComputeServiceImpl.class);
    @Autowired
    private RuleDomain ruleDomain;
    @Autowired
    private PromotionDomain promotionDomain;
    @Autowired
    private CouponDomain couponDomain;

    public ActivityComputeResultDTO preview(ActivityComputeParam activityComputeParam) {
        if (CollectionUtils.isEmpty((Collection)activityComputeParam.getOrderList())) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COMPUTE-0003");
        }
        long start = System.currentTimeMillis();
        ComputeParam computeParam = this.createComputeParam(activityComputeParam);
        computeParam.setIsPreview(true);
        long paramEnd = System.currentTimeMillis();
        ComputeResult computeResult = Calculator.execute(computeParam);
        long computeEnd = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder("param-create-time: ");
        sb.append(paramEnd - start).append(", compute-execute-time: ").append(computeEnd - paramEnd).append(", total-time: ").append(computeEnd - start);
        logger.info(sb.toString());
        return ComputeConvertor.INSTANCE.computeResultToActivityResult(computeResult);
    }

    @Transactional(rollbackFor={Exception.class})
    public ActivityComputeResultDTO excute(ActivityComputeParam activityComputeParam) {
        if (CollectionUtils.isEmpty((Collection)activityComputeParam.getOrderList())) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COMPUTE-0003");
        }
        long start = System.currentTimeMillis();
        ComputeParam computeParam = this.createComputeParam(activityComputeParam);
        computeParam.setIsPreview(false);
        long paramEnd = System.currentTimeMillis();
        ComputeResult computeResult = Calculator.execute(computeParam);
        long computeEnd = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder("param-create-time: ");
        sb.append(paramEnd - start).append(", compute-execute-time: ").append(computeEnd - paramEnd).append(", total-time: ").append(computeEnd - start);
        logger.info(sb.toString());
        return ComputeConvertor.INSTANCE.computeResultToActivityResult(computeResult);
    }

    private ComputeParam createComputeParam(ActivityComputeParam activityComputeParam) {
        List<OrderBO> orderList = OrderConvertor.INSTANCE.paramListToBO(activityComputeParam.getOrderList());
        ArrayList<ActivityBO> activityBOList = new ArrayList<ActivityBO>();
        long start = System.currentTimeMillis();
        List<PromotionBO> promotionBOList = this.promotionDomain.getPromotionList();
        List activeCodeList = activityComputeParam.getActiveCodeList();
        ArrayList<Long> promotionRuleIds = new ArrayList<Long>();
        promotionBOList.forEach(promotionBO -> {
            if (StringUtils.equals((CharSequence)promotionBO.getPromotionType(), (CharSequence)PromotionTypeEnum.SINGLE.getState())) {
                List<SingleGoodsBean> singleGoodsList = promotionBO.getSingleGoodsList();
                if (!CollectionUtils.isEmpty(singleGoodsList)) {
                    for (SingleGoodsBean singleGoodsBean : singleGoodsList) {
                        PromotionBO promotionCopy = ComputeConvertor.INSTANCE.promotionCopy((PromotionBO)promotionBO);
                        ArrayList<SingleGoodsBean> singleGoodsBeanList = new ArrayList<SingleGoodsBean>();
                        singleGoodsBeanList.add(singleGoodsBean);
                        promotionCopy.setSingleGoodsList(singleGoodsBeanList);
                        StringBuilder activityCodeBuilder = new StringBuilder("S-");
                        activityCodeBuilder.append(singleGoodsBean.getId());
                        promotionCopy.setActiveCode(activityCodeBuilder.toString());
                        promotionCopy.setSinglePromotionId(promotionBO.getId());
                        promotionCopy.setActiveName(promotionBO.getName());
                        promotionCopy.setActiveType(promotionBO.getPromotionType());
                        promotionCopy.setRuleId(singleGoodsBean.getRuleId());
                        promotionCopy.setComputePriority(ComputeContants.computePriorityConfig.get(promotionCopy.getActiveType()));
                        if (!CollectionUtils.isEmpty((Collection)activeCodeList) && activeCodeList.contains(promotionCopy.getActiveCode())) {
                            promotionCopy.setIsUserSelected(true);
                        } else {
                            promotionCopy.setIsUserSelected(false);
                        }
                        promotionRuleIds.add(singleGoodsBean.getRuleId());
                        activityBOList.add(promotionCopy);
                    }
                }
            } else {
                promotionBO.setActiveCode(String.valueOf(promotionBO.getId()));
                promotionBO.setActiveName(promotionBO.getName());
                promotionBO.setActiveType(promotionBO.getPromotionType());
                promotionBO.setComputePriority(ComputeContants.computePriorityConfig.get(promotionBO.getActiveType()));
                if (!CollectionUtils.isEmpty((Collection)activeCodeList) && activeCodeList.contains(promotionBO.getActiveCode())) {
                    promotionBO.setIsUserSelected(true);
                } else {
                    promotionBO.setIsUserSelected(false);
                }
                activityBOList.add((ActivityBO)promotionBO);
            }
        });
        long promotionEnd = System.currentTimeMillis();
        List<CouponReceiveRecordsBean> couponInstanceList = this.couponDomain.listCouponReceiveRecordsByMemberId(orderList.get(0).getMemberCardId(), YesOrNoEnum.NO.getValue());
        HashMap couponInstanceListMap = new HashMap();
        for (CouponReceiveRecordsBean couponReceiveRecordsBean : couponInstanceList) {
            List<CouponReceiveRecordsBean> couponInstanceBeanList;
            if (couponInstanceListMap.containsKey(couponReceiveRecordsBean.getCouponCode())) {
                couponInstanceBeanList = (List)couponInstanceListMap.get(couponReceiveRecordsBean.getCouponCode());
                couponInstanceBeanList.add(couponReceiveRecordsBean);
                continue;
            }
            couponInstanceBeanList = new ArrayList<CouponReceiveRecordsBean>();
            couponInstanceBeanList.add(couponReceiveRecordsBean);
            couponInstanceListMap.put(couponReceiveRecordsBean.getCouponCode(), couponInstanceBeanList);
        }
        List<CouponBO> couponBOList = this.couponDomain.getCouponList();
        List couponCodeList = activityComputeParam.getCouponCodeList();
        ArrayList freightCouponCodeList = new ArrayList();
        orderList.forEach(orderBO -> {
            if (StringUtils.isNotBlank((CharSequence)orderBO.getFreightCouponCode())) {
                freightCouponCodeList.add(orderBO.getFreightCouponCode());
            }
        });
        couponBOList.forEach(couponBO -> {
            if (couponInstanceListMap.containsKey(couponBO.getCouponCode())) {
                List couponReceiveRecordsList = (List)couponInstanceListMap.get(couponBO.getCouponCode());
                couponBO.setCouponReceiveRecordsList(couponReceiveRecordsList);
                couponBO.setActiveCode(couponBO.getCouponCode());
                couponBO.setActiveName(couponBO.getCouponName());
                if (StringUtils.equals((CharSequence)couponBO.getCouponType(), (CharSequence)CouponTypeEnum.FREIGHT.getState())) {
                    couponBO.setActiveType(ActiveTypeEnum.FREIGHT_COUPON.getState());
                    if (!CollectionUtils.isEmpty((Collection)freightCouponCodeList) && freightCouponCodeList.contains(couponBO.getCouponCode())) {
                        couponBO.setIsUserSelected(true);
                    } else {
                        couponBO.setIsUserSelected(false);
                    }
                } else {
                    couponBO.setActiveType(ActiveTypeEnum.COUPON.getState());
                    if (!CollectionUtils.isEmpty((Collection)couponCodeList) && couponCodeList.contains(couponBO.getCouponCode())) {
                        couponBO.setIsUserSelected(true);
                    } else {
                        couponBO.setIsUserSelected(false);
                    }
                }
                couponBO.setComputePriority(ComputeContants.computePriorityConfig.get(couponBO.getActiveType()));
                activityBOList.add((ActivityBO)couponBO);
            }
        });
        long couponEnd = System.currentTimeMillis();
        Map<Long, RuleBO> ruleMap = this.ruleDomain.getRuleMap("PMS_RULE_CACHE_PROMOTION_KEY", promotionRuleIds);
        List<Long> couponRuleIds = couponBOList.stream().map(CouponBO::getRuleId).collect(Collectors.toList());
        Map<Long, RuleBO> couponRuleMap = this.ruleDomain.getRuleMap("PMS_RULE_CACHE_COUPON_KEY", couponRuleIds);
        ruleMap.putAll(couponRuleMap);
        long ruleEnd = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder("promotion-param-time: ");
        sb.append(promotionEnd - start).append(", coupon-param-time: ").append(couponEnd - promotionEnd).append(", rule-param-time: ").append(ruleEnd - couponEnd);
        logger.info(sb.toString());
        ComputeParam computeParam = new ComputeParam();
        computeParam.setOrderList(orderList);
        computeParam.setActivityBOList(activityBOList);
        computeParam.setRuleMap(ruleMap);
        return computeParam;
    }
}

