/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.promotion.server.repository;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ztesoft.zsmart.nros.common.model.BaseModel;
import com.ztesoft.zsmart.nros.common.model.enums.StatusEnum;
import com.ztesoft.zsmart.nros.core.repository.BaseRepository;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.ConditionDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.DiscountDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.GiftCouponDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.GiftDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.PurchaseDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.RuleDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.RuleQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.ConditionConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.DiscountConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.GiftConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.GiftCouponConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.PurchaseConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.RuleSaveConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.dataobject.generator.ConditionDO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.dataobject.generator.DiscountDO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.dataobject.generator.GiftCouponDO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.dataobject.generator.GiftDO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.dataobject.generator.PurchaseDO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.dataobject.generator.RuleDO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.mapper.ConditionMapper;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.mapper.DiscountMapper;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.mapper.GiftCouponMapper;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.mapper.GiftMapper;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.mapper.PurchaseMapper;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.mapper.RuleMapper;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.mapper.generator.ConditionDOMapper;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.mapper.generator.RuleDOMapper;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.ConditionBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.DiscountBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.GiftBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.GiftCouponBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.PurchaseBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.RuleBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class RuleRepository
implements BaseRepository {
    @Autowired
    private RuleDOMapper ruleDOMapper;
    @Autowired
    private RuleMapper ruleMapper;
    @Autowired
    private ConditionDOMapper conditionDOMapper;
    @Autowired
    private ConditionMapper conditionMapper;
    @Autowired
    private DiscountMapper discountMapper;
    @Autowired
    private GiftMapper giftMapper;
    @Autowired
    private PurchaseMapper purchaseMapper;
    @Autowired
    private GiftCouponMapper giftCouponMapper;

    public Long addRule(RuleBO ruleBO) {
        RuleDO ruleDO = (RuleDO)RuleSaveConvertor.INSTANCE.boToDO(ruleBO);
        ruleDO.setStatus(StatusEnum.ENABLE.getState());
        this.ruleDOMapper.insert(ruleDO);
        ruleBO.setId(ruleDO.getId());
        ruleBO.setCreator(ruleDO.getCreator());
        ruleBO.setGmtCreate(ruleDO.getGmtCreate());
        ruleBO.setModifier(ruleDO.getModifier());
        ruleBO.setGmtModified(ruleDO.getGmtModified());
        ruleBO.setMerchantCode(ruleDO.getMerchantCode());
        ruleBO.setAppId(ruleDO.getAppId());
        this.insertConditonAndDiscount(ruleBO);
        return ruleDO.getId();
    }

    public void deleteRule(RuleBO ruleBO) {
        this.deleteConditionAndDiscount(ruleBO);
        RuleDO ruleDO = new RuleDO();
        ruleDO.setId(ruleBO.getId());
        ruleDO.setStatus(StatusEnum.DISABLE.getState());
        this.ruleDOMapper.updateByPrimaryKeySelective(ruleDO);
    }

    public void modifyRule(RuleBO ruleBO) {
        this.deleteConditionAndDiscount(ruleBO);
        RuleDO ruleDO = (RuleDO)RuleSaveConvertor.INSTANCE.boToDO(ruleBO);
        this.ruleDOMapper.updateByPrimaryKeySelective(ruleDO);
        this.insertConditonAndDiscount(ruleBO);
    }

    public PageInfo<RuleDTO> pageRule(RuleQuery ruleQuery) {
        PageHelper.startPage((int)ruleQuery.getPageIndex(), (int)ruleQuery.getPageSize());
        List<RuleDO> ruleDOList = this.ruleMapper.listRule(ruleQuery);
        PageInfo ruleDOPageInfo = new PageInfo(ruleDOList);
        PageInfo<RuleDTO> ruleDTOPageInfo = RuleSaveConvertor.INSTANCE.doPageToDTO((PageInfo<RuleDO>)ruleDOPageInfo);
        return ruleDTOPageInfo;
    }

    public RuleDTO findRuleById(Long id) {
        RuleDO ruleDO = this.ruleDOMapper.selectByPrimaryKey(id);
        return (RuleDTO)RuleSaveConvertor.INSTANCE.doToDTO(ruleDO);
    }

    public List<ConditionDTO> listConditionDetailByRuleList(List<Long> ruleIds) {
        List<ConditionDO> conditionDOS = this.conditionMapper.listByRuleIds(ruleIds);
        return this.listConditionAndDiscount(conditionDOS);
    }

    public List<ConditionDTO> listConditionAndDiscountByRuleId(Long ruleId) {
        List<ConditionDO> conditionDOList = this.conditionMapper.listByRuleId(ruleId);
        return this.listConditionAndDiscount(conditionDOList);
    }

    private List<ConditionDTO> listConditionAndDiscount(List<ConditionDO> conditionDOList) {
        List<ConditionDTO> conditionDTOList = null;
        if (CollectionUtils.isNotEmpty(conditionDOList)) {
            conditionDTOList = ConditionConvertor.INSTANCE.doListToDTO(conditionDOList);
            conditionDTOList.forEach(conditionDTO -> {
                Long conditionId = conditionDTO.getId();
                List<DiscountDO> discountDOList = this.discountMapper.listByConditionId(conditionId);
                if (CollectionUtils.isNotEmpty(discountDOList)) {
                    List<DiscountDTO> discountDTOList = DiscountConvertor.INSTANCE.doListToDTO(discountDOList);
                    conditionDTO.setDiscount(discountDTOList.get(0));
                }
                List<GiftDO> giftDOList = this.giftMapper.listByConditionId(conditionId);
                List<GiftDTO> giftDTOList = GiftConvertor.INSTANCE.doListToDTO(giftDOList);
                conditionDTO.setGiftList(giftDTOList);
                List<GiftCouponDO> giftCouponDOList = this.giftCouponMapper.listByConditionId(conditionId);
                List<GiftCouponDTO> giftCouponDTOList = GiftCouponConvertor.INSTANCE.doListToDTO(giftCouponDOList);
                conditionDTO.setGiftCouponList(giftCouponDTOList);
                List<PurchaseDO> purchaseDOList = this.purchaseMapper.listByConditionId(conditionId);
                List<PurchaseDTO> purchaseDTOList = PurchaseConvertor.INSTANCE.doListToDTO(purchaseDOList);
                conditionDTO.setPurchaseList(purchaseDTOList);
            });
        }
        return conditionDTOList;
    }

    private void insertConditonAndDiscount(RuleBO ruleBO) {
        JSONObject creator = ruleBO.getCreator();
        Date now = ruleBO.getGmtCreate();
        String merchantCode = ruleBO.getMerchantCode();
        String appId = ruleBO.getAppId();
        List<ConditionBean> conditionBeanList = ruleBO.getRuleConditions();
        ArrayList<DiscountDO> discountDOList = new ArrayList<DiscountDO>();
        ArrayList<GiftDO> giftDOList = new ArrayList<GiftDO>();
        ArrayList<GiftCouponDO> giftCouponDOList = new ArrayList<GiftCouponDO>();
        ArrayList<PurchaseDO> purchaseDOList = new ArrayList<PurchaseDO>();
        conditionBeanList.forEach(conditionBean -> {
            List<PurchaseBean> purchaseBeanList;
            List<GiftCouponBean> giftCouponBeanList;
            List<GiftBean> giftBeanList;
            ConditionDO conditionDO = (ConditionDO)ConditionConvertor.INSTANCE.boToDO(conditionBean);
            conditionDO.setRuleId(ruleBO.getId());
            this.setBaseInfo(conditionDO, creator, now, creator, now, merchantCode, appId, StatusEnum.ENABLE.getState());
            this.conditionDOMapper.insert(conditionDO);
            Long conditionId = conditionDO.getId();
            DiscountBean discountBean = conditionBean.getDiscount();
            if (discountBean != null) {
                DiscountDO discountDO = (DiscountDO)DiscountConvertor.INSTANCE.boToDO(discountBean);
                discountDO.setConditionId(conditionId);
                this.setBaseInfo(discountDO, creator, now, creator, now, merchantCode, appId, StatusEnum.ENABLE.getState());
                discountDOList.add(discountDO);
            }
            if (CollectionUtils.isNotEmpty(giftBeanList = conditionBean.getGiftList())) {
                giftBeanList.forEach(giftBean -> {
                    GiftDO giftDO = (GiftDO)GiftConvertor.INSTANCE.boToDO(giftBean);
                    giftDO.setConditionId(conditionId);
                    this.setBaseInfo(giftDO, creator, now, creator, now, merchantCode, appId, StatusEnum.ENABLE.getState());
                    giftDOList.add(giftDO);
                });
            }
            if (CollectionUtils.isNotEmpty(giftCouponBeanList = conditionBean.getGiftCouponList())) {
                giftCouponBeanList.forEach(giftCouponBean -> {
                    GiftCouponDO giftCouponDO = (GiftCouponDO)GiftCouponConvertor.INSTANCE.boToDO(giftCouponBean);
                    giftCouponDO.setConditionId(conditionId);
                    this.setBaseInfo(giftCouponDO, creator, now, creator, now, merchantCode, appId, StatusEnum.ENABLE.getState());
                    giftCouponDOList.add(giftCouponDO);
                });
            }
            if (CollectionUtils.isNotEmpty(purchaseBeanList = conditionBean.getPurchaseList())) {
                purchaseBeanList.forEach(purchaseBean -> {
                    PurchaseDO purchaseDO = (PurchaseDO)PurchaseConvertor.INSTANCE.boToDO(purchaseBean);
                    purchaseDO.setConditionId(conditionId);
                    this.setBaseInfo(purchaseDO, creator, now, creator, now, merchantCode, appId, StatusEnum.ENABLE.getState());
                    purchaseDOList.add(purchaseDO);
                });
            }
        });
        if (discountDOList.size() > 0) {
            this.discountMapper.batchInsert(discountDOList);
        }
        if (giftCouponDOList.size() > 0) {
            this.giftCouponMapper.batchInsert(giftCouponDOList);
        }
        if (giftDOList.size() > 0) {
            this.giftMapper.batchInsert(giftDOList);
        }
        if (purchaseDOList.size() > 0) {
            this.purchaseMapper.batchInsert(purchaseDOList);
        }
    }

    private void setBaseInfo(BaseModel bmDO, JSONObject creator, Date gmtCreate, JSONObject modifier, Date gmtModified, String merchantCode, String appId, String status) {
        bmDO.setCreator(creator);
        bmDO.setGmtCreate(gmtCreate);
        bmDO.setModifier(modifier);
        bmDO.setGmtModified(gmtModified);
        bmDO.setMerchantCode(merchantCode);
        bmDO.setAppId(appId);
        bmDO.setStatus(status);
    }

    private void deleteConditionAndDiscount(RuleBO ruleBO) {
        Long ruleId = ruleBO.getId();
        JSONObject modifier = ruleBO.getModifier();
        List<ConditionDO> conditionDOList = this.conditionMapper.listByRuleId(ruleId);
        if (CollectionUtils.isNotEmpty(conditionDOList)) {
            conditionDOList.forEach(conditionDO -> {
                DiscountDO deleteDiscountDO = new DiscountDO();
                deleteDiscountDO.setConditionId(conditionDO.getId());
                deleteDiscountDO.setModifier(modifier);
                deleteDiscountDO.setStatus(StatusEnum.DISABLE.getState());
                this.discountMapper.updateByConditionIdSelective(deleteDiscountDO);
                GiftCouponDO deleteGiftCouponDO = new GiftCouponDO();
                deleteGiftCouponDO.setConditionId(conditionDO.getId());
                deleteGiftCouponDO.setModifier(modifier);
                deleteGiftCouponDO.setStatus(StatusEnum.DISABLE.getState());
                this.giftCouponMapper.updateByConditionIdSelective(deleteGiftCouponDO);
                GiftDO deleteGiftDO = new GiftDO();
                deleteGiftDO.setConditionId(conditionDO.getId());
                deleteGiftDO.setModifier(modifier);
                deleteGiftDO.setStatus(StatusEnum.DISABLE.getState());
                this.giftMapper.updateByConditionIdSelective(deleteGiftDO);
                PurchaseDO deletePurchaseDO = new PurchaseDO();
                deletePurchaseDO.setConditionId(conditionDO.getId());
                deletePurchaseDO.setModifier(modifier);
                deletePurchaseDO.setStatus(StatusEnum.DISABLE.getState());
                this.purchaseMapper.updateByConditionIdSelective(deletePurchaseDO);
            });
            ConditionDO deleteConditionDO = new ConditionDO();
            deleteConditionDO.setRuleId(ruleId);
            deleteConditionDO.setModifier(modifier);
            deleteConditionDO.setStatus(StatusEnum.DISABLE.getState());
            this.conditionMapper.updateByRuleIdSelective(deleteConditionDO);
        }
    }

    public List<RuleDTO> listRuleByIds(List<Long> ruleIdList) {
        List<RuleDO> ruleDOList = this.ruleMapper.listByIds(ruleIdList);
        List<RuleDTO> ruleList = RuleSaveConvertor.INSTANCE.doListToDTO(ruleDOList);
        List<ConditionDO> conditionDOList = this.conditionMapper.listByRuleIds(ruleIdList);
        List<ConditionDTO> conditionList = ConditionConvertor.INSTANCE.doListToDTO(conditionDOList);
        ArrayList<Long> conditionIds = new ArrayList<Long>();
        conditionList.forEach(conditionDTO -> conditionIds.add(conditionDTO.getId()));
        List<DiscountDO> discountDOList = this.discountMapper.listByConditionIds(conditionIds);
        List<DiscountDTO> discountList = DiscountConvertor.INSTANCE.doListToDTO(discountDOList);
        List<GiftDO> giftDOList = this.giftMapper.listByConditionIds(conditionIds);
        List<GiftDTO> giftList = GiftConvertor.INSTANCE.doListToDTO(giftDOList);
        List<PurchaseDO> purchaseDOList = this.purchaseMapper.listByConditionIds(conditionIds);
        List<PurchaseDTO> purchaseList = PurchaseConvertor.INSTANCE.doListToDTO(purchaseDOList);
        List<GiftCouponDO> giftCouponDOList = this.giftCouponMapper.listByConditionIds(conditionIds);
        List<GiftCouponDTO> giftCouponList = GiftCouponConvertor.INSTANCE.doListToDTO(giftCouponDOList);
        this.setRuleDetail(ruleList, conditionList, discountList, giftList, purchaseList, giftCouponList);
        return ruleList;
    }

    private void setRuleDetail(List<RuleDTO> ruleList, List<ConditionDTO> ruleConditions, List<DiscountDTO> discountList, List<GiftDTO> giftList, List<PurchaseDTO> purchaseList, List<GiftCouponDTO> giftCouponList) {
        HashMap discountDTOMap = new HashMap();
        if (discountList != null) {
            discountList.forEach(discountDTO -> discountDTOMap.put(discountDTO.getConditionId(), discountDTO));
        }
        HashMap giftListMap = new HashMap();
        if (giftList != null) {
            for (GiftDTO giftDTO : giftList) {
                List<GiftDTO> giftDTOList;
                if (giftListMap.containsKey(giftDTO.getConditionId())) {
                    giftDTOList = (List)giftListMap.get(giftDTO.getConditionId());
                    giftDTOList.add(giftDTO);
                    continue;
                }
                giftDTOList = new ArrayList<GiftDTO>();
                giftDTOList.add(giftDTO);
                giftListMap.put(giftDTO.getConditionId(), giftDTOList);
            }
        }
        HashMap purchaseListMap = new HashMap();
        if (purchaseList != null) {
            for (PurchaseDTO purchaseDTO : purchaseList) {
                List<PurchaseDTO> purchaseDTOList;
                if (purchaseListMap.containsKey(purchaseDTO.getConditionId())) {
                    purchaseDTOList = (List)purchaseListMap.get(purchaseDTO.getConditionId());
                    purchaseDTOList.add(purchaseDTO);
                    continue;
                }
                purchaseDTOList = new ArrayList<PurchaseDTO>();
                purchaseDTOList.add(purchaseDTO);
                purchaseListMap.put(purchaseDTO.getConditionId(), purchaseDTOList);
            }
        }
        HashMap giftCouponListMap = new HashMap();
        if (giftCouponList != null) {
            for (GiftCouponDTO giftCouponDTO : giftCouponList) {
                List<GiftCouponDTO> giftCouponDTOList;
                if (giftCouponListMap.containsKey(giftCouponDTO.getConditionId())) {
                    giftCouponDTOList = (List)giftCouponListMap.get(giftCouponDTO.getConditionId());
                    giftCouponDTOList.add(giftCouponDTO);
                    continue;
                }
                giftCouponDTOList = new ArrayList<GiftCouponDTO>();
                giftCouponDTOList.add(giftCouponDTO);
                giftCouponListMap.put(giftCouponDTO.getConditionId(), giftCouponDTOList);
            }
        }
        HashMap conditionListMap = new HashMap();
        if (ruleConditions != null) {
            for (ConditionDTO ruleCondition : ruleConditions) {
                List<ConditionDTO> conditionDTOList;
                ruleCondition.setDiscount((DiscountDTO)discountDTOMap.get(ruleCondition.getId()));
                ruleCondition.setGiftList((List)giftListMap.get(ruleCondition.getId()));
                ruleCondition.setPurchaseList((List)purchaseListMap.get(ruleCondition.getId()));
                ruleCondition.setGiftCouponList((List)giftCouponListMap.get(ruleCondition.getId()));
                if (conditionListMap.containsKey(ruleCondition.getRuleId())) {
                    conditionDTOList = (List)conditionListMap.get(ruleCondition.getRuleId());
                    conditionDTOList.add(ruleCondition);
                    continue;
                }
                conditionDTOList = new ArrayList<ConditionDTO>();
                conditionDTOList.add(ruleCondition);
                conditionListMap.put(ruleCondition.getRuleId(), conditionDTOList);
            }
        }
        ruleList.forEach(ruleDTO -> ruleDTO.setRuleConditions((List)conditionListMap.get(ruleDTO.getId())));
    }
}

