/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.promotion.server.repository;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ztesoft.zsmart.nros.base.util.DateUtil;
import com.ztesoft.zsmart.nros.common.model.enums.StatusEnum;
import com.ztesoft.zsmart.nros.core.repository.BaseRepository;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.AllGoodsDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.GoodsRangeDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.PromotionDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.SingleGoodsDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.SingleGoodsDetailDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.GoodsRangeDeleteParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.SingleGoodsDeleteParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.GoodsRangeQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.PromotionQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.SingleGoodsQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.GoodsRangeConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.PromotionConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.SingleGoodsConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.SingleGoodsDetailConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.PromotionStateEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.PromotionTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.util.OperatorUtil;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.dataobject.generator.GoodsRangeDO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.dataobject.generator.PromotionDO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.dataobject.generator.SingleGoodsDO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.mapper.GoodsRangeMapper;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.mapper.PromotionMapper;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.mapper.SingleGoodsMapper;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.mapper.generator.GoodsRangeDOMapper;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.mapper.generator.PromotionDOMapper;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.mapper.generator.SingleGoodsDOMapper;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.promotion.model.GoodsRangeBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.promotion.model.PromotionBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.promotion.model.SingleGoodsBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PromotionRepository
implements BaseRepository {
    private static final Logger logger = LoggerFactory.getLogger(PromotionRepository.class);
    @Autowired
    private GoodsRangeDOMapper goodsRangeDOMapper;
    @Autowired
    private SingleGoodsDOMapper singleGoodsDOMapper;
    @Autowired
    private PromotionDOMapper promotionDOMapper;
    @Autowired
    private SingleGoodsMapper singleGoodsMapper;
    @Autowired
    private GoodsRangeMapper goodsRangeMapper;
    @Autowired
    private PromotionMapper promotionMapper;

    public Long savePromotionInfo(PromotionBO promotionBO) {
        PromotionDO promotionDO = (PromotionDO)PromotionConvertor.INSTANCE.boToDO(promotionBO);
        this.promotionDOMapper.insert(promotionDO);
        return promotionDO.getId();
    }

    public Long modifyPromotionInfo(PromotionBO promotionBO) {
        PromotionDO promotionDO = (PromotionDO)PromotionConvertor.INSTANCE.boToDO(promotionBO);
        this.promotionDOMapper.updateByPrimaryKeySelective(promotionDO);
        return promotionDO.getId();
    }

    public void deletePromotion(PromotionBO promotionBO) {
        this.deleteSingleGoodsAndGoodsRange(promotionBO);
        PromotionDO promotionDO = new PromotionDO();
        promotionDO.setId(promotionBO.getId());
        promotionDO.setStatus(StatusEnum.DISABLE.getState());
        this.promotionDOMapper.updateByPrimaryKeySelective(promotionDO);
    }

    private void deleteSingleGoodsAndGoodsRange(PromotionBO promotionBO) {
        Long promotionId = promotionBO.getId();
        JSONObject modifier = promotionBO.getModifier();
        SingleGoodsQuery singleGoodsQuery = new SingleGoodsQuery();
        GoodsRangeQuery goodsRangeQuery = new GoodsRangeQuery();
        singleGoodsQuery.setPromotionId(promotionId);
        goodsRangeQuery.setPromotionId(promotionId);
        List<SingleGoodsDO> singleGoodsDOList = this.singleGoodsMapper.listSingleGoods(singleGoodsQuery);
        List<GoodsRangeDO> goodsRangeDOList = this.goodsRangeMapper.listGoodsRange(goodsRangeQuery);
        if (CollectionUtils.isNotEmpty(singleGoodsDOList)) {
            SingleGoodsDO deleteSingleGoodsDO = new SingleGoodsDO();
            deleteSingleGoodsDO.setPromotionId(promotionId);
            deleteSingleGoodsDO.setModifier(modifier);
            deleteSingleGoodsDO.setStatus(StatusEnum.DISABLE.getState());
            this.singleGoodsMapper.updateByPromotionIdSelective(deleteSingleGoodsDO);
        }
        if (CollectionUtils.isNotEmpty(goodsRangeDOList)) {
            GoodsRangeDO deleteGoodsRangeDO = new GoodsRangeDO();
            deleteGoodsRangeDO.setPromotionId(promotionId);
            deleteGoodsRangeDO.setModifier(modifier);
            deleteGoodsRangeDO.setStatus(StatusEnum.DISABLE.getState());
            this.goodsRangeMapper.updateByPromotionIdSelective(deleteGoodsRangeDO);
        }
    }

    public PromotionDTO selectByPrimaryKey(Long promotionId) {
        PromotionDO promotionDO = this.promotionDOMapper.selectByPrimaryKey(promotionId);
        return PromotionConvertor.INSTANCE.doToDTO(promotionDO);
    }

    public List<SingleGoodsDTO> querySingleGoods(SingleGoodsQuery singleGoodsQuery) {
        List<SingleGoodsDO> singleGoodsDOList = this.singleGoodsMapper.listSingleGoods(singleGoodsQuery);
        return SingleGoodsConvertor.INSTANCE.doListToDTO(singleGoodsDOList);
    }

    public Integer getSingleGoodsCountByPromotionId(Long promotionId) {
        return this.singleGoodsMapper.getSingleGoodsCountByPromotionId(promotionId);
    }

    public Integer getGoodsRangeCountByPromotionId(Long promotionId) {
        return this.goodsRangeMapper.getGoodsRangeCountByPromotionId(promotionId);
    }

    public List<GoodsRangeDTO> listGoodsRangeByPromotionId(Long promotionId) {
        GoodsRangeQuery goodsRangeQuery = new GoodsRangeQuery();
        goodsRangeQuery.setPromotionId(promotionId);
        goodsRangeQuery.setStatus(StatusEnum.ENABLE.getState());
        List<GoodsRangeDO> goodsRangeDOList = this.goodsRangeMapper.listGoodsRange(goodsRangeQuery);
        return GoodsRangeConvertor.INSTANCE.doListToDTO(goodsRangeDOList);
    }

    public PageInfo<PromotionDTO> pagePromotion(PromotionQuery promotionQuery) {
        PageHelper.startPage((int)promotionQuery.getPageIndex(), (int)promotionQuery.getPageSize());
        List<PromotionDO> promotionDOList = this.promotionMapper.listPromotion(promotionQuery);
        PageInfo promotionDOPageInfo = new PageInfo(promotionDOList);
        PageInfo<PromotionDTO> promotionDTOPageInfo = PromotionConvertor.INSTANCE.doPageToDTO((PageInfo<PromotionDO>)promotionDOPageInfo);
        return promotionDTOPageInfo;
    }

    public Long saveSingleGoods(SingleGoodsBean singleGoodsBean) {
        SingleGoodsDO singleGoodsDO = (SingleGoodsDO)SingleGoodsConvertor.INSTANCE.boToDO(singleGoodsBean);
        this.singleGoodsDOMapper.insertSelective(singleGoodsDO);
        return singleGoodsDO.getId();
    }

    public Long modifySingleGoods(SingleGoodsBean singleGoodsBean) {
        SingleGoodsDO singleGoodsDO = (SingleGoodsDO)SingleGoodsConvertor.INSTANCE.boToDO(singleGoodsBean);
        this.singleGoodsDOMapper.updateByPrimaryKeySelective(singleGoodsDO);
        return singleGoodsDO.getId();
    }

    public Long saveGoodsRange(GoodsRangeBean goodsRangeBean) {
        GoodsRangeDO goodsRangeDO = (GoodsRangeDO)GoodsRangeConvertor.INSTANCE.boToDO(goodsRangeBean);
        this.goodsRangeDOMapper.insert(goodsRangeDO);
        return goodsRangeDO.getId();
    }

    public void modifySingleGoods(List<SingleGoodsBean> singleGoodsBeanList) {
        Long promotionId = singleGoodsBeanList.get(0).getPromotionId();
        SingleGoodsDO deleteSingleGoodsDO = new SingleGoodsDO();
        deleteSingleGoodsDO.setPromotionId(promotionId);
        deleteSingleGoodsDO.setStatus(StatusEnum.DISABLE.getState());
        this.singleGoodsMapper.updateByPromotionIdSelective(deleteSingleGoodsDO);
        List<SingleGoodsDO> singleGoodsDOList = SingleGoodsConvertor.INSTANCE.beanListToDO(singleGoodsBeanList);
        singleGoodsDOList.forEach(singleGoodsDO -> singleGoodsDO.setStatus(StatusEnum.ENABLE.getState()));
        this.singleGoodsMapper.batchInsert(singleGoodsDOList);
    }

    public void batchInsertGoodsRanges(List<GoodsRangeBean> goodsRangeBeanList) {
        List<GoodsRangeDO> goodsRangeDOList = GoodsRangeConvertor.INSTANCE.beanListToDO(goodsRangeBeanList);
        Date now = DateUtil.getNow();
        goodsRangeDOList.forEach(goodsRangeDO -> {
            goodsRangeDO.setStatus(StatusEnum.ENABLE.getState());
            goodsRangeDO.setGmtCreate(now);
            goodsRangeDO.setGmtModified(now);
            goodsRangeDO.setCreator(OperatorUtil.getOperatorJson());
        });
        this.goodsRangeMapper.batchInsert(goodsRangeDOList);
    }

    public void deletedByPromotionIdAndRangeCodes(Long promotionId, List<String> rangeCodes) {
        this.goodsRangeMapper.deletedByPromotionIdAndRangeCodes(promotionId, rangeCodes);
    }

    public PageInfo<GoodsRangeDTO> pageGoodsRange(GoodsRangeQuery goodsRangeQuery) {
        PageHelper.startPage((int)goodsRangeQuery.getPageIndex(), (int)goodsRangeQuery.getPageSize());
        List<GoodsRangeDO> goodsRangeDOList = this.goodsRangeMapper.listGoodsRange(goodsRangeQuery);
        PageInfo goodsRangeDOPageInfo = new PageInfo(goodsRangeDOList);
        return GoodsRangeConvertor.INSTANCE.doPageToDTO((PageInfo<GoodsRangeDO>)goodsRangeDOPageInfo);
    }

    public List<GoodsRangeDTO> selectGoodsRange(GoodsRangeQuery goodsRangeQuery) {
        List<GoodsRangeDO> goodsRangeDOList = this.goodsRangeMapper.listGoodsRange(goodsRangeQuery);
        return GoodsRangeConvertor.INSTANCE.doListToDTO(goodsRangeDOList);
    }

    public PageInfo<SingleGoodsDTO> pageSingleGoods(SingleGoodsQuery singleGoodsQuery) {
        PageHelper.startPage((int)singleGoodsQuery.getPageIndex(), (int)singleGoodsQuery.getPageSize());
        List<SingleGoodsDO> singleGoodsDOList = this.singleGoodsMapper.listSingleGoods(singleGoodsQuery);
        PageInfo singleGoodsDOPageInfo = new PageInfo(singleGoodsDOList);
        return SingleGoodsConvertor.INSTANCE.doPageToDTO((PageInfo<SingleGoodsDO>)singleGoodsDOPageInfo);
    }

    public SingleGoodsDetailDTO findSingleGoodsById(Long id) {
        SingleGoodsDO singleGoodsDO = this.singleGoodsDOMapper.selectByPrimaryKey(id);
        return SingleGoodsDetailConvertor.INSTANCE.doToDTO(singleGoodsDO);
    }

    public void deleteSingleGoods(SingleGoodsDeleteParam singleGoodsDeleteParam) {
        SingleGoodsDO singleGoodsDO = new SingleGoodsDO();
        singleGoodsDO.setId(singleGoodsDeleteParam.getId());
        singleGoodsDO.setStatus(StatusEnum.DISABLE.getState());
        this.singleGoodsDOMapper.updateByPrimaryKeySelective(singleGoodsDO);
    }

    public void updatePromotion(PromotionBO promotionBO) {
        PromotionDO promotionDO = (PromotionDO)PromotionConvertor.INSTANCE.boToDO(promotionBO);
        this.promotionDOMapper.updateByPrimaryKeySelective(promotionDO);
    }

    public List<PromotionDTO> listPromotion(PromotionQuery promotionQuery) {
        List<PromotionDO> promotionDOList = this.promotionMapper.listPromotion(promotionQuery);
        return PromotionConvertor.INSTANCE.doListToDTO(promotionDOList);
    }

    public void deleteSingleGoods(GoodsRangeDeleteParam goodsRangeDeleteParam) {
        GoodsRangeDO goodsRangeDO = new GoodsRangeDO();
        goodsRangeDO.setId(goodsRangeDeleteParam.getId());
        goodsRangeDO.setStatus(StatusEnum.DISABLE.getState());
        this.goodsRangeDOMapper.updateByPrimaryKeySelective(goodsRangeDO);
    }

    public Integer getPromotionCountByRuleId(Long ruleId) {
        return this.promotionMapper.getPromotionCountByRuleId(ruleId);
    }

    public Integer getSingleGoodsCountByRuleId(Long ruleId) {
        return this.singleGoodsMapper.getSingleGoodsCountByRuleId(ruleId);
    }

    public void saveGoodsRangeType(PromotionBO promotionBO) {
        PromotionDO promotionDO = (PromotionDO)PromotionConvertor.INSTANCE.boToDO(promotionBO);
        this.promotionDOMapper.updateByPrimaryKeySelective(promotionDO);
    }

    public List<PromotionDTO> listAll() {
        List<PromotionDO> promotionDOList = this.promotionMapper.listAll(StatusEnum.ENABLE.getState(), PromotionStateEnum.ENABLE.getState());
        List<PromotionDTO> promotionList = PromotionConvertor.INSTANCE.doListToDTO(promotionDOList);
        List<SingleGoodsDO> singleGoodsDOList = this.singleGoodsMapper.listAll(StatusEnum.ENABLE.getState());
        List<SingleGoodsDTO> singleGoodsList = SingleGoodsConvertor.INSTANCE.doListToDTO(singleGoodsDOList);
        List<GoodsRangeDO> goodsRangeDOList = this.goodsRangeMapper.listAll(StatusEnum.ENABLE.getState());
        List<GoodsRangeDTO> goodsRangeDTOList = GoodsRangeConvertor.INSTANCE.doListToDTO(goodsRangeDOList);
        this.setPromotionDetail(promotionList, singleGoodsList, goodsRangeDTOList);
        return promotionList;
    }

    public AllGoodsDTO listAllGoods(PromotionQuery promotionQuery) {
        AllGoodsDTO allGoods = new AllGoodsDTO();
        PageHelper.startPage((int)promotionQuery.getPageIndex(), (int)promotionQuery.getPageSize());
        List<PromotionDO> promotionDOS = this.promotionMapper.listPromotion(promotionQuery);
        if (CollectionUtils.isEmpty(promotionDOS)) {
            return null;
        }
        PromotionDO promotionDO = promotionDOS.get(0);
        allGoods.setPromotionType(promotionDO.getPromotionType());
        allGoods.setGoodsRangeType(promotionDO.getGoodsRangeType());
        if (promotionDO.getPromotionType().equals(PromotionTypeEnum.SINGLE.getState())) {
            SingleGoodsQuery singleGoodsQuery = new SingleGoodsQuery();
            singleGoodsQuery.setPromotionId(promotionDO.getId());
            List<SingleGoodsDTO> singleGoods = SingleGoodsConvertor.INSTANCE.doListToDTO(this.singleGoodsMapper.listSingleGoods(singleGoodsQuery));
            PageInfo singleGoodsDTOPageInfo = new PageInfo(singleGoods);
            allGoods.setSingleGoodsList(singleGoodsDTOPageInfo);
        }
        if (promotionDO.getPromotionType().equals(PromotionTypeEnum.ORDER.getState()) && StringUtils.isNotBlank((String)promotionDO.getGoodsRangeType())) {
            GoodsRangeQuery goodsRangeQuery = new GoodsRangeQuery();
            goodsRangeQuery.setPromotionId(promotionDO.getId());
            List<GoodsRangeDO> goodsRanges = this.goodsRangeMapper.listGoodsRange(goodsRangeQuery);
            PageInfo goodsRangesDTOPageInfo = new PageInfo(GoodsRangeConvertor.INSTANCE.doListToDTO(goodsRanges));
            allGoods.setGoodsRangeList(goodsRangesDTOPageInfo);
        }
        return allGoods;
    }

    public int disableExpiredPromotion() {
        return this.promotionMapper.disableExpiredPromotion();
    }

    private void setPromotionDetail(List<PromotionDTO> promotionList, List<SingleGoodsDTO> singleGoodsList, List<GoodsRangeDTO> goodsRangeList) {
        HashMap singleGoodsListMap = new HashMap();
        if (singleGoodsList != null) {
            for (SingleGoodsDTO singleGoodsDTO : singleGoodsList) {
                List<SingleGoodsDTO> singleGoodsDTOList;
                if (singleGoodsListMap.containsKey(singleGoodsDTO.getPromotionId())) {
                    singleGoodsDTOList = (List)singleGoodsListMap.get(singleGoodsDTO.getPromotionId());
                    singleGoodsDTOList.add(singleGoodsDTO);
                    continue;
                }
                singleGoodsDTOList = new ArrayList<SingleGoodsDTO>();
                singleGoodsDTOList.add(singleGoodsDTO);
                singleGoodsListMap.put(singleGoodsDTO.getPromotionId(), singleGoodsDTOList);
            }
        }
        HashMap goodsRangeListMap = new HashMap();
        if (goodsRangeList != null) {
            for (GoodsRangeDTO goodsRangeDTO : goodsRangeList) {
                List<GoodsRangeDTO> goodsRangeDTOList;
                if (goodsRangeListMap.containsKey(goodsRangeDTO.getPromotionId())) {
                    goodsRangeDTOList = (List)goodsRangeListMap.get(goodsRangeDTO.getPromotionId());
                    goodsRangeDTOList.add(goodsRangeDTO);
                    continue;
                }
                goodsRangeDTOList = new ArrayList<GoodsRangeDTO>();
                goodsRangeDTOList.add(goodsRangeDTO);
                goodsRangeListMap.put(goodsRangeDTO.getPromotionId(), goodsRangeDTOList);
            }
        }
        promotionList.forEach(promotionDTO -> {
            promotionDTO.setSingleGoodsList((List)singleGoodsListMap.get(promotionDTO.getId()));
            promotionDTO.setGoodsRangeList((List)goodsRangeListMap.get(promotionDTO.getId()));
        });
    }
}

