/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.promotion.server.repository;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ztesoft.zsmart.nros.base.util.DateUtil;
import com.ztesoft.zsmart.nros.common.model.enums.StatusEnum;
import com.ztesoft.zsmart.nros.core.repository.BaseRepository;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.CouponDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.CouponGoodsRangeDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.CouponInstanceDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.CouponReceiveRecordsDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.CouponReservedAndCheckedDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.CouponGoodsRangeDeleteParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.CouponGoodsRangeQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.CouponInstanceQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.CouponQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.CouponReceiveListQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.CouponGoodsRangeConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.CouponQueryConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.CouponReceiveRecordsConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.CouponReservedAndCheckedConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.CouponSaveConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.CouponInstanceStatusEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.CouponStatusEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.YesOrNoEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.util.OperatorUtil;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.dataobject.CouponInstanceQueryDO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.dataobject.CouponQueryDO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.dataobject.CouponReservedAndCheckedDO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.dataobject.generator.CouponDO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.dataobject.generator.CouponGoodsRangeDO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.dataobject.generator.CouponReceiveRecordsDO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.mapper.CouponGoodsRangeMapper;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.mapper.CouponMapper;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.mapper.CouponReceiveRecordsMapper;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.mapper.generator.CouponDOMapper;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.mapper.generator.CouponGoodsRangeDOMapper;
import com.ztesoft.zsmart.nros.sbc.promotion.server.dao.mapper.generator.CouponReceiveRecordsDOMapper;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.coupon.model.CouponBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.coupon.model.CouponGoodsRangeBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.coupon.model.CouponReceiveRecordsBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CouponRepository
implements BaseRepository {
    @Autowired
    private CouponDOMapper couponDOMapper;
    @Autowired
    private CouponMapper couponMapper;
    @Autowired
    private CouponGoodsRangeDOMapper couponGoodsRangeDOMapper;
    @Autowired
    private CouponGoodsRangeMapper couponGoodsRangeMapper;
    @Autowired
    private CouponReceiveRecordsDOMapper couponReceiveRecordsDOMapper;
    @Autowired
    private CouponReceiveRecordsMapper couponReceiveRecordsMapper;

    public String addCoupon(CouponBO couponBO) {
        CouponDO couponDO = (CouponDO)CouponSaveConvertor.INSTANCE.boToDO(couponBO);
        couponDO.setVersion(1);
        couponDO.setReceivedCount(0);
        this.couponDOMapper.insert(couponDO);
        return couponDO.getCouponCode();
    }

    public void saveCouponRuleRelationship(String couponCode, Long ruleId, String ruleName, Long couponAmt) {
        this.couponMapper.updateRuleIdByCouponCode(couponCode, ruleId, ruleName, couponAmt);
    }

    public CouponDTO selectCouponByCode(String couponCode) {
        CouponDO couponDO = new CouponDO();
        couponDO.setCouponCode(couponCode);
        couponDO.setStatus(StatusEnum.ENABLE.getState());
        return (CouponDTO)CouponSaveConvertor.INSTANCE.doToDTO(this.couponMapper.selectCoupon(couponDO));
    }

    public void modifyCoupon(CouponBO couponBO) {
        CouponDO couponDO = (CouponDO)CouponSaveConvertor.INSTANCE.boToDO(couponBO);
        this.couponDOMapper.updateByPrimaryKeySelective(couponDO);
    }

    public PageInfo<CouponDTO> pageCoupon(CouponQuery couponQuery) {
        PageHelper.startPage((int)couponQuery.getPageIndex(), (int)couponQuery.getPageSize());
        CouponQueryDO couponQueryDO = CouponQueryConvertor.INSTANCE.queryToDO(couponQuery);
        List<CouponDO> couponDOList = this.couponMapper.listCoupon(couponQueryDO);
        PageInfo couponDOPageInfo = new PageInfo(couponDOList);
        PageInfo<CouponDTO> couponDTOPageInfo = CouponSaveConvertor.INSTANCE.doPageToDTO((PageInfo<CouponDO>)couponDOPageInfo);
        return couponDTOPageInfo;
    }

    public Long countCouponReceiveRecordsByCouponCode(String couponCode) {
        Long receivedNumber = this.couponReceiveRecordsMapper.countCouponReceiveRecordsByCouponCode(couponCode);
        return receivedNumber;
    }

    public Long countCouponReceiveRecordsUsedByCouponCode(String couponCode) {
        Long receivedNumber = this.couponReceiveRecordsMapper.countCouponReceiveRecordsUsedByCouponCode(couponCode);
        return receivedNumber;
    }

    public Long countCouponReceiveRecordsByFromUserIdAndCouponCode(Long memberId, String couponCode) {
        return this.couponReceiveRecordsMapper.countCouponReceiveRecordsByFromUserIdAndCouponCode(memberId, couponCode);
    }

    public CouponReceiveRecordsDTO addCouponReceiveRecords(CouponReceiveRecordsBean couponReceiveRecords) {
        CouponReceiveRecordsDO couponReceiveRecordsDO = (CouponReceiveRecordsDO)CouponReceiveRecordsConvertor.INSTANCE.boToDO(couponReceiveRecords);
        this.couponReceiveRecordsDOMapper.insertSelective(couponReceiveRecordsDO);
        return (CouponReceiveRecordsDTO)CouponReceiveRecordsConvertor.INSTANCE.doToDTO(couponReceiveRecordsDO);
    }

    public PageInfo<CouponReceiveRecordsDTO> pageReceiveRecords(CouponReceiveListQuery couponReceiveListQuery) {
        PageHelper.startPage((int)couponReceiveListQuery.getPageIndex(), (int)couponReceiveListQuery.getPageSize());
        List<CouponReceiveRecordsDO> list = this.couponReceiveRecordsMapper.listCouponReceiveRecords(couponReceiveListQuery);
        if (list == null) {
            return new PageInfo();
        }
        PageInfo couponReceiveRecordsDOPageInfo = new PageInfo(list);
        PageInfo<CouponReceiveRecordsDTO> pageInfo = CouponReceiveRecordsConvertor.INSTANCE.doPageToDTO((PageInfo<CouponReceiveRecordsDO>)couponReceiveRecordsDOPageInfo);
        return pageInfo;
    }

    public CouponReceiveRecordsDTO selectByInstanceCode(String instanceCode) {
        CouponReceiveRecordsDO couponReceiveRecordsDO = this.couponReceiveRecordsMapper.selectByInstanceCode(instanceCode);
        return (CouponReceiveRecordsDTO)CouponReceiveRecordsConvertor.INSTANCE.doToDTO(couponReceiveRecordsDO);
    }

    public void modifyCouponReceiveRecords(CouponReceiveRecordsBean couponReceiveRecords) {
        CouponReceiveRecordsDO couponReceiveRecordsDO = (CouponReceiveRecordsDO)CouponReceiveRecordsConvertor.INSTANCE.boToDO(couponReceiveRecords);
        this.couponReceiveRecordsDOMapper.updateByPrimaryKeySelective(couponReceiveRecordsDO);
    }

    public void updateReceiveRecordsById(CouponReceiveRecordsBean couponReceiveRecords) {
        CouponReceiveRecordsDO couponReceiveRecordsDO = (CouponReceiveRecordsDO)CouponReceiveRecordsConvertor.INSTANCE.boToDO(couponReceiveRecords);
        this.couponReceiveRecordsDOMapper.updateByPrimaryKey(couponReceiveRecordsDO);
    }

    public List<CouponDTO> listCouponByCodeList(List<String> couponCodeList) {
        List<CouponDO> couponDOList = this.couponMapper.listCouponByCodeList(couponCodeList);
        if (CollectionUtils.isEmpty(couponDOList)) {
            return new ArrayList<CouponDTO>();
        }
        return CouponSaveConvertor.INSTANCE.listDOToDTO(couponDOList);
    }

    public List<CouponInstanceDTO> selectReceiveRecordsByMemberId(Long memberId, String isUse, List<String> channel) {
        CouponInstanceQueryDO couponInstanceQueryDO = new CouponInstanceQueryDO();
        couponInstanceQueryDO.setMemberId(memberId);
        couponInstanceQueryDO.setIsUse(isUse);
        couponInstanceQueryDO.setChannel(channel);
        return this.couponReceiveRecordsMapper.selectInstanceAndCoupon(couponInstanceQueryDO);
    }

    public CouponInstanceDTO selectCouponInstanceByInstanceCode(String instanceCode) {
        return this.couponReceiveRecordsMapper.selectCouponInstanceByInstanceCode(instanceCode);
    }

    public void saveCouponGoodsRange(CouponGoodsRangeBean couponGoodsRangeBean) {
        CouponGoodsRangeDO couponGoodsRangeDO = (CouponGoodsRangeDO)CouponGoodsRangeConvertor.INSTANCE.boToDO(couponGoodsRangeBean);
        this.couponGoodsRangeDOMapper.insert(couponGoodsRangeDO);
    }

    public void deletedByCouponCodeAndRangeCodes(String couponCode, List<String> rangeCodes) {
        this.couponGoodsRangeMapper.deletedByCouponCodeAndRangeCodes(couponCode, rangeCodes);
    }

    public void batchInsertGoodsRanges(List<CouponGoodsRangeBean> beans) {
        List<CouponGoodsRangeDO> goodsRangeDOList = CouponGoodsRangeConvertor.INSTANCE.beanListToDO(beans);
        Date now = DateUtil.getNow();
        goodsRangeDOList.forEach(goodsRangeDO -> {
            goodsRangeDO.setStatus(StatusEnum.ENABLE.getState());
            goodsRangeDO.setGmtCreate(now);
            goodsRangeDO.setGmtModified(now);
            goodsRangeDO.setCreator(OperatorUtil.getOperatorJson());
        });
        this.couponGoodsRangeMapper.batchInsert(goodsRangeDOList);
    }

    public List<CouponGoodsRangeDTO> listCouponGoodsRangeByCouponCode(String couponCode) {
        List<CouponGoodsRangeDO> couponGoodsRangeDOList = this.couponGoodsRangeMapper.selectByCouponCode(couponCode);
        return CouponGoodsRangeConvertor.INSTANCE.doListToDTO(couponGoodsRangeDOList);
    }

    public List<CouponGoodsRangeDTO> listCouponGoodsRange(CouponGoodsRangeQuery couponGoodsRangeQuery) {
        CouponGoodsRangeDO couponGoodsRangeDO = (CouponGoodsRangeDO)CouponGoodsRangeConvertor.INSTANCE.queryToDO(couponGoodsRangeQuery);
        List<CouponGoodsRangeDO> couponGoodsRangeDOList = this.couponGoodsRangeMapper.listCouponGoodsRange(couponGoodsRangeDO);
        return CouponGoodsRangeConvertor.INSTANCE.doListToDTO(couponGoodsRangeDOList);
    }

    public void deleteCouponGoodsRange(CouponGoodsRangeDeleteParam couponGoodsRangeDeleteParam) {
        CouponGoodsRangeDO couponGoodsRangeDO = new CouponGoodsRangeDO();
        couponGoodsRangeDO.setId(couponGoodsRangeDeleteParam.getId());
        couponGoodsRangeDO.setStatus(StatusEnum.DISABLE.getState());
        this.couponGoodsRangeDOMapper.updateByPrimaryKeySelective(couponGoodsRangeDO);
    }

    public PageInfo<CouponInstanceDTO> pageCouponInstance(CouponInstanceQuery couponMemberIdQuery) {
        CouponInstanceQueryDO couponInstanceQueryDO = new CouponInstanceQueryDO();
        couponInstanceQueryDO.setMemberId(couponMemberIdQuery.getMemberId());
        couponInstanceQueryDO.setStatus(couponMemberIdQuery.getStatus());
        if (!CouponInstanceStatusEnum.NOT_FORCE.getState().equals(couponInstanceQueryDO.getStatus())) {
            if (CouponInstanceStatusEnum.VALID.getState().equals(couponInstanceQueryDO.getStatus())) {
                couponInstanceQueryDO.setIsLock(YesOrNoEnum.NO.getValue());
                couponInstanceQueryDO.setIsUse(YesOrNoEnum.NO.getValue());
            } else if (CouponInstanceStatusEnum.LOCKED.getState().equals(couponInstanceQueryDO.getStatus())) {
                couponInstanceQueryDO.setIsLock(YesOrNoEnum.YES.getValue());
                couponInstanceQueryDO.setIsUse(YesOrNoEnum.NO.getValue());
            } else if (CouponInstanceStatusEnum.USED.getState().equals(couponMemberIdQuery.getStatus())) {
                couponInstanceQueryDO.setIsUse(YesOrNoEnum.YES.getValue());
            } else if (CouponInstanceStatusEnum.INVALID.getState().equals(couponMemberIdQuery.getStatus())) {
                couponInstanceQueryDO.setIsLock(YesOrNoEnum.NO.getValue());
                couponInstanceQueryDO.setIsUse(YesOrNoEnum.NO.getValue());
            }
        }
        couponInstanceQueryDO.setReceiveStartTime(couponMemberIdQuery.getReceiveStartTime());
        couponInstanceQueryDO.setReceiveEndTime(couponMemberIdQuery.getReceiveEndTime());
        couponInstanceQueryDO.setUsedStartTime(couponMemberIdQuery.getUsedStartTime());
        couponInstanceQueryDO.setUsedEndTime(couponMemberIdQuery.getUsedEndTime());
        couponInstanceQueryDO.setChannel(couponMemberIdQuery.getChannel());
        couponInstanceQueryDO.setCouponTypes(couponMemberIdQuery.getCouponTypes());
        PageHelper.startPage((int)couponMemberIdQuery.getPageIndex(), (int)couponMemberIdQuery.getPageSize());
        List<CouponInstanceDTO> couponInstanceDTOS = this.couponReceiveRecordsMapper.selectInstanceAndCoupon(couponInstanceQueryDO);
        if (null == couponInstanceDTOS) {
            couponInstanceDTOS = new ArrayList<CouponInstanceDTO>();
        }
        PageInfo couponInstanceDTOPageInfo = new PageInfo(couponInstanceDTOS);
        return couponInstanceDTOPageInfo;
    }

    public Integer getCouponCountByRuleId(Long ruleId) {
        return this.couponMapper.getCouponCountByRuleId(ruleId);
    }

    public List<CouponDTO> listAll() {
        List<CouponDO> couponDOList = this.couponMapper.listAll(StatusEnum.ENABLE.getState(), CouponStatusEnum.ACTIVATED.getState());
        List<CouponDTO> couponList = CouponSaveConvertor.INSTANCE.listDOToDTO(couponDOList);
        List<CouponGoodsRangeDO> goodsRangeDOList = this.couponGoodsRangeMapper.listAll(StatusEnum.ENABLE.getState());
        List<CouponGoodsRangeDTO> goodsRangeList = CouponGoodsRangeConvertor.INSTANCE.doListToDTO(goodsRangeDOList);
        this.setCouponDetail(couponList, goodsRangeList);
        return couponList;
    }

    public List<CouponReceiveRecordsDTO> listCouponReceiveRecordsByMemberId(Long memberId, String isUse) {
        CouponReceiveListQuery couponReceiveListQuery = new CouponReceiveListQuery();
        couponReceiveListQuery.setMemberId(memberId);
        couponReceiveListQuery.setIsUse(isUse);
        List<CouponReceiveRecordsDO> couponReceiveRecordsDOS = this.couponReceiveRecordsMapper.listCouponReceiveRecords(couponReceiveListQuery);
        return CouponReceiveRecordsConvertor.INSTANCE.doListToDTO(couponReceiveRecordsDOS);
    }

    public int updateCouponByVersion(Long id, int version, int receivedCount) {
        return this.couponMapper.updateCouponByVersion(id, version, receivedCount);
    }

    public List<CouponReservedAndCheckedDTO> statisticsOfReservedAndChecked(String activeInstanceCode, String activeCode, String startDate, String endDate) {
        List<CouponReservedAndCheckedDO> couponReservedAndCheckedDO = this.couponReceiveRecordsMapper.statisticsOfReservedAndChecked(activeInstanceCode, activeCode, startDate, endDate);
        return CouponReservedAndCheckedConvertor.INSTANCE.doListToDTO(couponReservedAndCheckedDO);
    }

    public List<CouponReceiveRecordsDTO> queryRecordsByMemberAndCouponCodes(Long memberId, List<String> couponCodes) {
        List<CouponReceiveRecordsDO> recordsDOS = this.couponReceiveRecordsMapper.queryRecordsByMemberAndCouponCodes(memberId, couponCodes);
        return CouponReceiveRecordsConvertor.INSTANCE.doListToDTO(recordsDOS);
    }

    public void deleteCoupon(CouponBO couponBO) {
        String couponCode = couponBO.getCouponCode();
        this.couponGoodsRangeMapper.deleteByCouponCode(couponCode);
        CouponDO couponDO = new CouponDO();
        couponDO.setCouponCode(couponCode);
        couponDO.setStatus(StatusEnum.DISABLE.getState());
        this.couponMapper.updateByCouponCodeSelective(couponDO);
    }

    private void setCouponDetail(List<CouponDTO> couponList, List<CouponGoodsRangeDTO> goodsRangeList) {
        HashMap goodsRangeListMap = new HashMap();
        if (goodsRangeList != null) {
            for (CouponGoodsRangeDTO goodsRangeDTO : goodsRangeList) {
                List<CouponGoodsRangeDTO> goodsRangeDTOList;
                if (goodsRangeListMap.containsKey(goodsRangeDTO.getCouponCode())) {
                    goodsRangeDTOList = (List)goodsRangeListMap.get(goodsRangeDTO.getCouponCode());
                    goodsRangeDTOList.add(goodsRangeDTO);
                    continue;
                }
                goodsRangeDTOList = new ArrayList<CouponGoodsRangeDTO>();
                goodsRangeDTOList.add(goodsRangeDTO);
                goodsRangeListMap.put(goodsRangeDTO.getCouponCode(), goodsRangeDTOList);
            }
        }
        couponList.forEach(couponDTO -> couponDTO.setCouponGoodsRangeList((List)goodsRangeListMap.get(couponDTO.getCouponCode())));
    }
}

