/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.mq.producer;

import com.alibaba.fastjson.JSONArray;
import com.aliyun.openservices.ons.api.Producer;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.ztesoft.zsmart.nros.base.util.DateUtil;
import com.ztesoft.zsmart.nros.base.zmq.entity.NrosMQMessage;
import com.ztesoft.zsmart.nros.base.zmq.producer.DefaultZMQProducer;
import com.ztesoft.zsmart.nros.sbc.promotion.client.api.PromotionService;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.ConditionDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.GiftDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.PromotionDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.SingleGoodsDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.SingleGoodsDetailDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.PromotionQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.SingleGoodsQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.ActiveTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.ChannelEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.ConditionTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.PromotionStateEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.PromotionTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.UserScopeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.YesOrNoEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.mq.model.PromotionOrderDiscountMQ;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.mq.model.PromotionSingleGiftMQ;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PromotionProducer {
    private static final Logger log = LoggerFactory.getLogger(PromotionProducer.class);
    @Value(value="${zmq.produce.promotion.activity.gift.topic}")
    private String giftTopic;
    @Value(value="${zmq.produce.promotion.activity.order.topic}")
    private String orderTopic;
    @Value(value="${zmq.produce.promotion.activity.omo.tag}")
    private String omoTag;
    @Value(value="${zmq.produce.promotion.activity.pos.tag}")
    private String posTag;
    @Autowired
    private DefaultZMQProducer producerHandler;
    @Autowired
    private PromotionService promotionService;

    public <T> T sendMsg(PromotionDTO promotionDTO) {
        Producer producer = this.producerHandler.getProducer();
        if (PromotionTypeEnum.SINGLE.getState().equals(promotionDTO.getPromotionType())) {
            this.sendSingleGiftMQ(promotionDTO, producer);
        } else if (PromotionTypeEnum.ORDER.getState().equals(promotionDTO.getPromotionType())) {
            this.sendOrderDiscountMQ(promotionDTO, producer);
        }
        return null;
    }

    private void sendOrderDiscountMQ(PromotionDTO promotionDTO, Producer producer) {
        PromotionQuery query = new PromotionQuery();
        query.setId(promotionDTO.getId());
        PromotionDTO promotion = this.promotionService.detailPromotion(query);
        try {
            PromotionOrderDiscountMQ promotionOrderDiscountMQ;
            if (PromotionStateEnum.ENABLE.getState().equals(promotionDTO.getPromotionState())) {
                promotionOrderDiscountMQ = this.convertPromotionOrderDiscountMQ(promotion);
            } else {
                promotionOrderDiscountMQ = new PromotionOrderDiscountMQ();
                promotionOrderDiscountMQ.setIsForbidden(BigDecimal.ONE.toString());
                promotionOrderDiscountMQ.setSchemeNo(String.valueOf(promotion.getId()));
            }
            if (promotionDTO.getChannel().contains((Object)ChannelEnum.CLOUD_POS.getState().toString())) {
                JSONObject msgBody = new JSONObject();
                msgBody.put((Object)"contentStatus", (Object)"");
                msgBody.put((Object)"contentType", (Object)"PROMOTION_ORDER_DISCOUNT_SYNC");
                msgBody.put((Object)"content", (Object)"\u4fc3\u9500\u8ba2\u5355\u6298\u6263\u6d3b\u52a8\u6570\u636e\u540c\u6b65");
                msgBody.put((Object)"data", (Object)promotionOrderDiscountMQ);
                NrosMQMessage msg = NrosMQMessage.buildNrosMQMessage((JSONObject)msgBody, (String)this.orderTopic, (String)this.posTag);
                this.producerHandler.sendMessage(producer, msg);
            }
        }
        catch (Exception e) {
            log.error("send order discount mq error,message:{},e:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void sendSingleGiftMQ(PromotionDTO promotionDTO, Producer producer) {
        SingleGoodsQuery singleGoodsQuery = new SingleGoodsQuery();
        singleGoodsQuery.setPromotionId(promotionDTO.getId());
        singleGoodsQuery.setPageIndex(1);
        singleGoodsQuery.setPageSize(999);
        PageInfo singleGoodsDTOPageInfo = this.promotionService.pageSingleGoods(singleGoodsQuery);
        List singleGoods = singleGoodsDTOPageInfo.getList();
        if (CollectionUtils.isNotEmpty((Collection)singleGoods)) {
            for (SingleGoodsDTO singleGood : singleGoods) {
                PromotionSingleGiftMQ promotionSingleGiftMQ;
                SingleGoodsQuery singleGoodsId = new SingleGoodsQuery();
                singleGoodsId.setId(singleGood.getId());
                if (PromotionStateEnum.ENABLE.getState().equals(promotionDTO.getPromotionState())) {
                    SingleGoodsDetailDTO singleGoodsDetailDTO = this.promotionService.detailSingleGoods(singleGoodsId);
                    promotionSingleGiftMQ = this.convertPromotionSingleGiftMQ(promotionDTO, singleGoodsDetailDTO);
                } else {
                    promotionSingleGiftMQ = new PromotionSingleGiftMQ();
                    promotionSingleGiftMQ.setIsForbidden(BigDecimal.ONE.toString());
                    promotionSingleGiftMQ.setSchemeNo("S-" + singleGood.getId());
                }
                try {
                    NrosMQMessage msg;
                    if (promotionDTO.getChannel().contains((Object)ChannelEnum.CLOUD_POS.getState().toString())) {
                        JSONObject posMsgBody = this.getMsgBody(promotionSingleGiftMQ);
                        msg = NrosMQMessage.buildNrosMQMessage((JSONObject)posMsgBody, (String)this.giftTopic, (String)this.posTag);
                        this.producerHandler.sendMessage(producer, msg);
                    }
                    if (!promotionDTO.getChannel().contains((Object)ChannelEnum.OMO.getState().toString())) continue;
                    JSONObject omoMsgBody = this.getMsgBody(promotionSingleGiftMQ);
                    msg = NrosMQMessage.buildNrosMQMessage((JSONObject)omoMsgBody, (String)this.giftTopic, (String)this.omoTag);
                    this.producerHandler.sendMessage(producer, msg);
                }
                catch (Exception e) {
                    log.error("send single gift mq error,message:{},e:{}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    private PromotionOrderDiscountMQ convertPromotionOrderDiscountMQ(PromotionDTO promotionDTO) {
        PromotionOrderDiscountMQ promotionOrderDiscountMQ = new PromotionOrderDiscountMQ();
        promotionOrderDiscountMQ.setActiveType(ActiveTypeEnum.ORDER.getState());
        promotionOrderDiscountMQ.setSchemeNo(String.valueOf(promotionDTO.getId()));
        promotionOrderDiscountMQ.setSchemeName(promotionDTO.getName());
        if (YesOrNoEnum.YES.getValue().equals(promotionDTO.getUseAllLocations())) {
            promotionOrderDiscountMQ.setSubList(new JSONArray());
        } else {
            JSONArray subbh = promotionDTO.getStoreCode().stream().map(a -> ImmutableMap.of((Object)"subbh", (Object)a)).collect(Collectors.toCollection(JSONArray::new));
            promotionOrderDiscountMQ.setSubList(subbh);
        }
        if (UserScopeEnum.VIP.getState().equals(promotionDTO.getUserScope())) {
            JSONArray memberGroupList = promotionDTO.getMemberLevelScope().stream().map(o -> {
                com.alibaba.fastjson.JSONObject object = (com.alibaba.fastjson.JSONObject)o;
                return ImmutableMap.of((Object)"memberGroupNo", (Object)object.getString("level"), (Object)"defaultDiscount", (Object)"100");
            }).collect(Collectors.toCollection(JSONArray::new));
            promotionOrderDiscountMQ.setMemberGroupList(memberGroupList);
        } else {
            promotionOrderDiscountMQ.setMemberGroupList(new JSONArray());
        }
        promotionOrderDiscountMQ.setCategoryList(new JSONArray());
        BigDecimal discount = ((ConditionDTO)promotionDTO.getRuleDTO().getRuleConditions().get(0)).getDiscount().getDiscount();
        String discountPercent = discount.multiply(BigDecimal.TEN).toString();
        promotionOrderDiscountMQ.setDiscount(discountPercent);
        if (CollectionUtils.isNotEmpty((Collection)promotionDTO.getGoodsRangeList())) {
            JSONArray goodsList = promotionDTO.getGoodsRangeList().stream().map(o -> ImmutableMap.of((Object)"goodsNo", (Object)o.getRangeCode(), (Object)"goodsDiscount", (Object)"100")).collect(Collectors.toCollection(JSONArray::new));
            promotionOrderDiscountMQ.setGoodsList(goodsList);
        }
        promotionOrderDiscountMQ.setIsForbidden(BigDecimal.ZERO.toString());
        promotionOrderDiscountMQ.setStartDate(DateUtil.dateToStr((Date)promotionDTO.getStartTime(), (String)"yyyy-MM-dd"));
        promotionOrderDiscountMQ.setStartTime(DateUtil.dateToStr((Date)promotionDTO.getStartTime(), (String)"HH:mm:ss"));
        promotionOrderDiscountMQ.setEndDate(DateUtil.dateToStr((Date)promotionDTO.getEndTime(), (String)"yyyy-MM-dd"));
        promotionOrderDiscountMQ.setEndTime(DateUtil.dateToStr((Date)promotionDTO.getEndTime(), (String)"HH:mm:ss"));
        return promotionOrderDiscountMQ;
    }

    private PromotionSingleGiftMQ convertPromotionSingleGiftMQ(PromotionDTO promotionDTO, SingleGoodsDetailDTO singleGoodsDetailDTO) {
        ConditionDTO conditionDTO = (ConditionDTO)singleGoodsDetailDTO.getRuleDTO().getRuleConditions().get(0);
        List giftList = conditionDTO.getGiftList();
        PromotionSingleGiftMQ promotionMQ = new PromotionSingleGiftMQ();
        promotionMQ.setActiveType(ActiveTypeEnum.SINGLE.getState());
        if (ConditionTypeEnum.AMT.getState().equals(conditionDTO.getConditionType())) {
            promotionMQ.setConditionAmount(String.valueOf(conditionDTO.getAmountOfMoney()));
            promotionMQ.setConditionType(BigDecimal.ONE.toString());
        } else if (ConditionTypeEnum.QUANTITY.getState().equals(conditionDTO.getConditionType())) {
            promotionMQ.setConditionAmount(String.valueOf(conditionDTO.getQuantity()));
            promotionMQ.setConditionType(BigDecimal.ZERO.toString());
        }
        promotionMQ.setStartDate(DateUtil.dateToStr((Date)promotionDTO.getStartTime(), (String)"yyyy-MM-dd"));
        promotionMQ.setStartTime(DateUtil.dateToStr((Date)promotionDTO.getStartTime(), (String)"HH:mm:ss"));
        promotionMQ.setEndDate(DateUtil.dateToStr((Date)promotionDTO.getEndTime(), (String)"yyyy-MM-dd"));
        promotionMQ.setEndTime(DateUtil.dateToStr((Date)promotionDTO.getEndTime(), (String)"HH:mm:ss"));
        if (CollectionUtils.isNotEmpty((Collection)giftList)) {
            promotionMQ.setGiftList(Arrays.asList(((GiftDTO)giftList.get(0)).getSkuCode()));
            promotionMQ.setGiftNum(String.valueOf(((GiftDTO)giftList.get(0)).getQuantity()));
        }
        promotionMQ.setGoodsList(Lists.newArrayList((Object[])new String[]{singleGoodsDetailDTO.getSkuCode()}));
        promotionMQ.setIsAmountPromotion(BigDecimal.ONE.toString());
        promotionMQ.setIsForbidden(BigDecimal.ZERO.toString());
        promotionMQ.setIsFrequency(BigDecimal.ZERO.toString());
        if (UserScopeEnum.VIP.getState().equals(promotionDTO.getUserScope())) {
            promotionMQ.setIsMember(BigDecimal.ONE.toString());
        } else {
            promotionMQ.setIsMember(BigDecimal.ZERO.toString());
        }
        promotionMQ.setIsRebate(BigDecimal.ZERO.toString());
        promotionMQ.setIsRetailPrice(BigDecimal.ZERO.toString());
        promotionMQ.setMemberList(new JSONArray());
        promotionMQ.setNotes(promotionDTO.getPromotionRemark());
        promotionMQ.setSchemeName(promotionDTO.getName());
        promotionMQ.setSchemeNo("S-" + singleGoodsDetailDTO.getId());
        if (YesOrNoEnum.YES.getValue().equals(promotionDTO.getUseAllLocations())) {
            promotionMQ.setSubList(new JSONArray());
        } else {
            promotionMQ.setSubList(promotionDTO.getStoreCode());
        }
        return promotionMQ;
    }

    private <T> JSONObject getMsgBody(T data) {
        JSONObject msgBody = new JSONObject();
        msgBody.put((Object)"contentStatus", (Object)"");
        msgBody.put((Object)"contentType", (Object)"PROMOTION_SYNC");
        msgBody.put((Object)"content", (Object)"\u4fc3\u9500\u6d3b\u52a8\u6570\u636e\u540c\u6b65");
        msgBody.put((Object)"data", data);
        return msgBody;
    }
}

