/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.mq.consumer;

import com.alibaba.ans.shaded.com.alibaba.fastjson.JSONArray;
import com.alibaba.ans.shaded.com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.ztesoft.zsmart.nros.base.util.SpringContextUtils;
import com.ztesoft.zsmart.nros.base.zmq.consumer.AbstractZMQHandler;
import com.ztesoft.zsmart.nros.base.zmq.entity.NrosMQMessage;
import com.ztesoft.zsmart.nros.sbc.promotion.client.api.CouponService;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.CouponConsumeParam;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CheckCouponConsumer
extends AbstractZMQHandler {
    private static final Logger log = LoggerFactory.getLogger(CheckCouponConsumer.class);
    private Logger logger = LoggerFactory.getLogger(CheckCouponConsumer.class);

    public Action doBusinesses(NrosMQMessage nrosMQMessage, ConsumeContext consumeContext) {
        this.logger.info("this is the time to get check coupon MQ info");
        byte[] orderByte = nrosMQMessage.getMqMessage().getBody();
        if (null != orderByte && orderByte.length > 0) {
            String jsonBody = null;
            try {
                jsonBody = new String(orderByte, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error("check coupon consumer msg convert error\uff1amessage:{},e:{}", (Object)e.getMessage(), (Object)e);
                return Action.ReconsumeLater;
            }
            JSONObject jsonObject = JSONObject.parseObject((String)jsonBody);
            String orderCode = jsonObject.getString("orderCode");
            JSONArray instanceCodes = jsonObject.getJSONArray("instanceCode");
            String storeName = jsonObject.getString("storeName");
            String consumeChannel = jsonObject.getString("consumeChannel");
            String externalOrderNum = jsonObject.getString("externalOrderNum");
            String useStoreCode = jsonObject.getString("useStoreCode");
            String type = jsonObject.getString("type");
            for (Object instanceCodeObject : instanceCodes) {
                String instanceCode = (String)instanceCodeObject;
                CouponService couponService = (CouponService)SpringContextUtils.getBean(CouponService.class);
                if (1 == Integer.parseInt(type)) {
                    CouponConsumeParam couponConsumeParam = new CouponConsumeParam();
                    couponConsumeParam.setOrderCode(orderCode);
                    couponConsumeParam.setInstanceCode(instanceCode);
                    couponConsumeParam.setStoreName(storeName);
                    couponConsumeParam.setConsumeChannel(consumeChannel);
                    couponConsumeParam.setExternalOrderNum(externalOrderNum);
                    couponConsumeParam.setUseStoreCode(useStoreCode);
                    couponService.consumeCouponInstance(couponConsumeParam);
                    continue;
                }
                if (2 != Integer.parseInt(type)) continue;
                couponService.cancelConsumeCouponInstance(instanceCode);
            }
            return Action.CommitMessage;
        }
        this.logger.error("check coupon consumer msg body is empty");
        return Action.CommitMessage;
    }
}

