/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.job.jobhandler;

import com.ztesoft.zsmart.nros.base.util.DateUtil;
import com.ztesoft.zsmart.nros.job.core.biz.model.ReturnT;
import com.ztesoft.zsmart.nros.job.core.handler.IJobHandler;
import com.ztesoft.zsmart.nros.job.core.handler.annotation.JobHandler;
import com.ztesoft.zsmart.nros.job.core.log.XxlJobLogger;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.PromotionTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.promotion.PromotionDomain;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.promotion.model.PromotionBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.promotion.model.SingleGoodsBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.RuleDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@JobHandler(value="disableExpiredPromotionJob")
public class DisableExpiredPromotionJob
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(DisableExpiredPromotionJob.class);
    @Autowired
    private PromotionDomain promotionDomain;
    @Autowired
    private RuleDomain ruleDomain;

    public ReturnT<String> execute(String s) throws Exception {
        XxlJobLogger.log((String)"disableExpiredPromotionJob start execute {}", (Object[])new Object[]{DateUtil.getNow((String)"yyyy-MM-dd HH:mm:ss")});
        if (this.promotionDomain.disableExpiredPromotion() != 0) {
            List<PromotionBO> promotionBOS = this.promotionDomain.refreshPromotionCache();
            List<Long> ruleIds = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty(promotionBOS)) {
                ruleIds = promotionBOS.stream().map(PromotionBO::getRuleId).collect(Collectors.toList());
                List singleGoodsRuleIds = promotionBOS.stream().filter(o -> PromotionTypeEnum.SINGLE.getState().equals(o.getPromotionType())).flatMap(o -> o.getSingleGoodsList().stream().map(SingleGoodsBean::getRuleId)).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(singleGoodsRuleIds)) {
                    ruleIds.addAll(singleGoodsRuleIds);
                }
            }
            this.ruleDomain.refreshRuleCache("PMS_RULE_CACHE_PROMOTION_KEY", ruleIds);
        }
        XxlJobLogger.log((String)"disableExpiredPromotionJob end execute {}", (Object[])new Object[]{DateUtil.getNow((String)"yyyy-MM-dd HH:mm:ss")});
        return SUCCESS;
    }
}

