/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.impl.discount;

import com.ztesoft.zsmart.nros.base.exception.ExceptionHandler;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.DiscountTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.compute.model.ActivityBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.ConditionBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.PurchaseBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.BaseDiscountCalculator;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.OrderComputeResult;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderLineBean;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PurchaseCalculator
extends BaseDiscountCalculator {
    @Override
    protected BigDecimal totalDiscountCompute(ConditionBean hitConditioin, BigDecimal totalAmt, BigDecimal totalQuantity, Integer loopTimes, OrderBO orderBO) {
        List<PurchaseBean> purchaseList = hitConditioin.getPurchaseList();
        BigDecimal totalDiscountAmt = BigDecimal.ZERO;
        for (PurchaseBean purchaseBean : purchaseList) {
            BigDecimal originalPrice = new BigDecimal(purchaseBean.getOriginalPrice());
            BigDecimal price = new BigDecimal(purchaseBean.getPrice());
            BigDecimal orderQuantityLimit = new BigDecimal(purchaseBean.getOrderQuantityLimit());
            BigDecimal purchaseDiscountAmt = originalPrice.subtract(price).multiply(orderQuantityLimit);
            totalDiscountAmt = totalDiscountAmt.add(purchaseDiscountAmt);
        }
        return totalDiscountAmt.multiply(new BigDecimal(loopTimes));
    }

    @Override
    protected void discountShareAndRecord(ActivityBO hitActivityBO, List<OrderLineBean> needOrderLineList, OrderComputeResult orderComputeResult) {
        List<OrderLineBean> orderLineBeanList = hitActivityBO.getOrderLineList();
        BigDecimal totalDiscountAmt = hitActivityBO.getTotalDiscountAmt();
        BigDecimal totalAmt = hitActivityBO.getTotalAmt();
        Integer loopTimes = hitActivityBO.getLoopTimes();
        boolean isEffective = false;
        for (OrderLineBean orderLineBean : orderLineBeanList) {
            BigDecimal lastDiscountAmt;
            String activityType;
            BigDecimal oldRealityAmt = orderLineBean.getActualAmount();
            BigDecimal discountAmt = oldRealityAmt.divide(totalAmt, 8, RoundingMode.valueOf(4)).multiply(totalDiscountAmt);
            Map<String, BigDecimal> activityMap = orderLineBean.getActivityMap();
            if (activityMap.containsKey(activityType = hitActivityBO.getActiveType()) && (lastDiscountAmt = activityMap.get(activityType)).compareTo(discountAmt) >= 0) {
                return;
            }
            orderLineBean.getActivityMap().put(hitActivityBO.getActiveType(), discountAmt);
            isEffective = true;
        }
        if (isEffective) {
            Map<String, List<PurchaseBean>> activePurchaseListMap = orderComputeResult.getActivePurchaseListMap();
            Map<String, PurchaseBean> purchaseSkuMap = orderComputeResult.getPurchaseSkuMap();
            ConditionBean hitConditioin = hitActivityBO.getHitCondition();
            List<PurchaseBean> purchaseList = hitConditioin.getPurchaseList();
            purchaseList.forEach(purchaseBean -> {
                purchaseBean.setActiveType(hitActivityBO.getActiveType());
                purchaseBean.setActiveName(hitActivityBO.getActiveName());
                purchaseBean.setActiveCode(hitActivityBO.getActiveCode());
                purchaseBean.setOrderQuantityLimit(purchaseBean.getOrderQuantityLimit() * loopTimes);
                purchaseBean.setDiscountName(hitConditioin.getDiscountName());
            });
            activePurchaseListMap.put(hitActivityBO.getActiveCode(), purchaseList);
            List<PurchaseBean> allPurchaseList = orderComputeResult.getPurchaseList();
            allPurchaseList.addAll(purchaseList);
            allPurchaseList.forEach(purchaseBean -> {
                StringBuilder keyStr = new StringBuilder();
                keyStr.append(purchaseBean.getSkuCode()).append("-").append(purchaseBean.getPrice());
                String key = keyStr.toString();
                if (purchaseSkuMap.containsKey(key)) {
                    PurchaseBean purchase = (PurchaseBean)purchaseSkuMap.get(key);
                    purchase.setOrderQuantityLimit(purchase.getOrderQuantityLimit() + purchaseBean.getOrderQuantityLimit());
                } else {
                    purchaseSkuMap.put(key, (PurchaseBean)purchaseBean);
                }
            });
            orderComputeResult.setPurchaseList(new ArrayList<PurchaseBean>(purchaseSkuMap.values()));
        }
    }

    public void purchaseCompute(List<OrderLineBean> purchaseList, OrderComputeResult orderComputeResult, Boolean isPreview) {
        Map<String, PurchaseBean> purchaseSkuMap = orderComputeResult.getPurchaseSkuMap();
        if (isPreview.booleanValue()) {
            purchaseList.forEach(orderLineBean -> {
                StringBuilder keyStr = new StringBuilder();
                keyStr.append(orderLineBean.getSkuCode()).append("-").append(orderLineBean.getActualPrice());
                String key = keyStr.toString();
                if (purchaseSkuMap.containsKey(key)) {
                    PurchaseBean purchaseBean = (PurchaseBean)purchaseSkuMap.get(key);
                    BigDecimal purchaseQuantityLimit = new BigDecimal(purchaseBean.getOrderQuantityLimit());
                    if (orderLineBean.getSkuUnitQuantity().compareTo(purchaseQuantityLimit) > 0) {
                        orderLineBean.setQuantityLimit(purchaseQuantityLimit);
                    } else if (orderLineBean.getSkuUnitQuantity().compareTo(purchaseQuantityLimit) < 0) {
                        BigDecimal recommendQuantity = purchaseQuantityLimit.subtract(orderLineBean.getSkuUnitQuantity());
                        purchaseBean.setOrderQuantityLimit(recommendQuantity.intValue());
                        orderLineBean.setQuantityLimit(recommendQuantity);
                    } else {
                        purchaseSkuMap.remove(key);
                    }
                } else {
                    orderLineBean.setQuantityLimit(BigDecimal.ZERO);
                }
                this.savePurchaseDiscount((OrderLineBean)orderLineBean, orderComputeResult, isPreview);
            });
            orderComputeResult.setPurchaseList(new ArrayList<PurchaseBean>(purchaseSkuMap.values()));
        } else {
            purchaseList.forEach(orderLineBean -> {
                StringBuilder keyStr = new StringBuilder();
                keyStr.append(orderLineBean.getSkuCode()).append("-").append(orderLineBean.getActualPrice());
                String key = keyStr.toString();
                if (purchaseSkuMap.containsKey(key)) {
                    PurchaseBean purchaseBean = (PurchaseBean)purchaseSkuMap.get(key);
                    BigDecimal purchaseQuantityLimit = new BigDecimal(purchaseBean.getOrderQuantityLimit());
                    if (orderLineBean.getSkuUnitQuantity().compareTo(purchaseQuantityLimit) > 0) {
                        ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COMPUTE-0004");
                    }
                } else {
                    ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COMPUTE-0005");
                }
                this.savePurchaseDiscount((OrderLineBean)orderLineBean, orderComputeResult, isPreview);
            });
        }
    }

    private void savePurchaseDiscount(OrderLineBean orderLineBean, OrderComputeResult orderComputeResult, Boolean isPreview) {
        Map<String, List<PurchaseBean>> activePurchaseListMap = orderComputeResult.getActivePurchaseListMap();
        BigDecimal discountQuantity = orderLineBean.getSkuUnitQuantity();
        BigDecimal purchasePrice = null;
        StringBuilder orderLinekeyStr = new StringBuilder();
        orderLinekeyStr.append(orderLineBean.getSkuCode()).append("-").append(orderLineBean.getActualPrice());
        String orderLineKey = orderLinekeyStr.toString();
        boolean isBreak = false;
        for (String activeCode : activePurchaseListMap.keySet()) {
            List<PurchaseBean> purchaseBeanList = activePurchaseListMap.get(activeCode);
            for (PurchaseBean purchaseBean : purchaseBeanList) {
                BigDecimal currentDiscountQuantity;
                StringBuilder purchaseKeyStr = new StringBuilder();
                purchaseKeyStr.append(purchaseBean.getSkuCode()).append("-").append(purchaseBean.getPrice());
                String purchaseKey = purchaseKeyStr.toString();
                if (!StringUtils.equals((CharSequence)orderLineKey, (CharSequence)purchaseKey)) continue;
                BigDecimal purchaseQuantityLimit = new BigDecimal(purchaseBean.getOrderQuantityLimit());
                if (discountQuantity.compareTo(purchaseQuantityLimit) > 0) {
                    currentDiscountQuantity = purchaseQuantityLimit;
                    discountQuantity = discountQuantity.subtract(currentDiscountQuantity);
                } else if (discountQuantity.compareTo(purchaseQuantityLimit) < 0) {
                    currentDiscountQuantity = discountQuantity;
                    isBreak = true;
                } else {
                    currentDiscountQuantity = discountQuantity;
                    isBreak = true;
                }
                BigDecimal originPrice = orderLineBean.getOriginPrice();
                BigDecimal originAmt = currentDiscountQuantity.multiply(originPrice);
                purchasePrice = new BigDecimal(purchaseBean.getPrice());
                BigDecimal actualAmt = currentDiscountQuantity.multiply(purchasePrice);
                BigDecimal currentDiscountAmt = originAmt.subtract(actualAmt);
                ActivityBO activityBO = new ActivityBO();
                activityBO.setActiveCode(purchaseBean.getActiveCode());
                activityBO.setActiveName(purchaseBean.getActiveName());
                activityBO.setActiveType(purchaseBean.getActiveType());
                activityBO.setIsGiftOrPurchase(true);
                activityBO.setTotalDiscountAmt(currentDiscountAmt);
                this.recordDiscount(orderComputeResult, orderLineBean, activityBO, purchaseBean.getDiscountName(), currentDiscountAmt, DiscountTypeEnum.FULL_PURCHASE.getState(), currentDiscountQuantity);
                this.recordEffectiveActivity(orderComputeResult, activityBO);
                if (!isBreak) continue;
                break;
            }
            if (!isBreak) continue;
            break;
        }
        if (purchasePrice != null) {
            BigDecimal realityAmt = purchasePrice.multiply(orderLineBean.getSkuUnitQuantity());
            this.computeByRealityAmt(orderLineBean, realityAmt);
        } else if (!isPreview.booleanValue()) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COMPUTE-0005");
        }
    }
}

