/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.impl.discount;

import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.ComputeConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.CouponTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.compute.model.ActivityBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.ConditionBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.GiftCouponBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.RuleBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.BaseDiscountCalculator;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.OrderComputeResult;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderGiftCouponBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderLineBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderPromotionBean;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class GiftCouponCalculator
extends BaseDiscountCalculator {
    @Override
    protected BigDecimal totalDiscountCompute(ConditionBean hitConditioin, BigDecimal totalAmt, BigDecimal totalQuantity, Integer loopTimes, OrderBO orderBO) {
        List<GiftCouponBean> giftCouponList = hitConditioin.getGiftCouponList();
        BigDecimal totalDiscountAmt = BigDecimal.ZERO;
        for (GiftCouponBean giftCouponBean : giftCouponList) {
            BigDecimal couponAmt = new BigDecimal(giftCouponBean.getCouponAmt());
            if (StringUtils.equals((CharSequence)CouponTypeEnum.DISCOUNT.getState(), (CharSequence)giftCouponBean.getCouponType())) {
                couponAmt = new BigDecimal(Integer.MAX_VALUE);
            }
            BigDecimal quantity = new BigDecimal(giftCouponBean.getQuantity());
            BigDecimal couponTotalAmt = couponAmt.multiply(quantity);
            totalDiscountAmt = totalDiscountAmt.add(couponTotalAmt);
        }
        return totalDiscountAmt.multiply(new BigDecimal(loopTimes));
    }

    @Override
    protected void discountShareAndRecord(ActivityBO hitActivityBO, List<OrderLineBean> needOrderLineList, OrderComputeResult orderComputeResult) {
        List<OrderLineBean> orderLineBeanList = hitActivityBO.getOrderLineList();
        BigDecimal totalDiscountAmt = hitActivityBO.getTotalDiscountAmt();
        BigDecimal totalAmt = hitActivityBO.getTotalAmt();
        Integer loopTimes = hitActivityBO.getLoopTimes();
        boolean isEffective = false;
        for (OrderLineBean orderLineBean : orderLineBeanList) {
            BigDecimal lastDiscountAmt;
            String activityType;
            BigDecimal oldRealityAmt = orderLineBean.getActualAmount();
            BigDecimal discountAmt = oldRealityAmt.divide(totalAmt, 8, RoundingMode.valueOf(4)).multiply(totalDiscountAmt);
            Map<String, BigDecimal> activityMap = orderLineBean.getActivityMap();
            if (activityMap.containsKey(activityType = hitActivityBO.getActiveType()) && (lastDiscountAmt = activityMap.get(activityType)).compareTo(discountAmt) >= 0) {
                return;
            }
            orderLineBean.getActivityMap().put(hitActivityBO.getActiveType(), discountAmt);
            isEffective = true;
        }
        if (isEffective) {
            ConditionBean hitConditioin = hitActivityBO.getHitCondition();
            List<GiftCouponBean> giftCouponList = hitConditioin.getGiftCouponList();
            giftCouponList.forEach(giftCouponBean -> giftCouponBean.setQuantity(giftCouponBean.getQuantity() * loopTimes));
            List<GiftCouponBean> allGiftCouponList = orderComputeResult.getGiftCouponList();
            allGiftCouponList.addAll(giftCouponList);
            Map<String, GiftCouponBean> giftCouponMap = orderComputeResult.getGiftCouponMap();
            allGiftCouponList.forEach(giftCouponBean -> {
                if (giftCouponMap.containsKey(giftCouponBean.getCouponCode())) {
                    GiftCouponBean giftCoupon = (GiftCouponBean)giftCouponMap.get(giftCouponBean.getCouponCode());
                    giftCoupon.setQuantity(giftCoupon.getQuantity() + giftCouponBean.getQuantity());
                } else {
                    giftCouponMap.put(giftCouponBean.getCouponCode(), (GiftCouponBean)giftCouponBean);
                }
            });
            orderComputeResult.setGiftCouponList(new ArrayList<GiftCouponBean>(giftCouponMap.values()));
            this.recordGiftCouponDiscount(orderComputeResult, hitActivityBO, hitConditioin.getDiscountName(), BigDecimal.ZERO, BigDecimal.ZERO);
        }
    }

    private void recordGiftCouponDiscount(OrderComputeResult orderComputeResult, ActivityBO activityBO, String discountName, BigDecimal discountAmt, BigDecimal discountQuantity) {
        RuleBO hitRule = activityBO.getHitRule();
        OrderBO orderBO = orderComputeResult.getOrder();
        OrderPromotionBean orderPromotion = new OrderPromotionBean();
        orderPromotion.setRootOrderNo(orderBO.getRootOrderNo());
        orderPromotion.setOrderNo(orderBO.getOrderNo());
        orderPromotion.setChannelId(orderBO.getChannelId());
        orderPromotion.setStoreCode(orderBO.getShopCode());
        orderPromotion.setDiscountAmt(discountAmt);
        orderPromotion.setActiveType(activityBO.getActiveType());
        orderPromotion.setActiveName(activityBO.getActiveName());
        orderPromotion.setActiveCode(activityBO.getActiveCode());
        orderPromotion.setDiscountType(hitRule.getDiscountType());
        orderPromotion.setDiscountName(discountName);
        orderPromotion.setDiscountQuantity(discountQuantity);
        orderPromotion.setOriginalAmt(orderBO.getOldShipmentFee());
        orderPromotion.setExclusiveWithOther(activityBO.getExclusiveWithOther());
        orderComputeResult.getOrderPromotionList().add(orderPromotion);
        List<OrderGiftCouponBean> orderGiftCouponBeanList = ComputeConvertor.INSTANCE.giftCouponListCopy(orderComputeResult.getGiftCouponList());
        orderGiftCouponBeanList.forEach(orderGiftCouponBean -> {
            orderGiftCouponBean.setOrderNo(orderBO.getOrderNo());
            orderGiftCouponBean.setActiveType(activityBO.getActiveType());
            orderGiftCouponBean.setActiveName(activityBO.getActiveName());
            orderGiftCouponBean.setActiveCode(activityBO.getActiveCode());
            orderGiftCouponBean.setRootOrderNo(orderBO.getRootOrderNo());
        });
        orderBO.setOrderGiftCouponList(orderGiftCouponBeanList);
    }
}

