/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.impl.discount;

import com.ztesoft.zsmart.nros.base.exception.ExceptionHandler;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.DiscountTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.compute.model.ActivityBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.ConditionBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.GiftBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.BaseDiscountCalculator;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.OrderComputeResult;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderLineBean;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class GiftCalculator
extends BaseDiscountCalculator {
    @Override
    protected BigDecimal totalDiscountCompute(ConditionBean hitConditioin, BigDecimal totalAmt, BigDecimal totalQuantity, Integer loopTimes, OrderBO orderBO) {
        List<GiftBean> giftList = hitConditioin.getGiftList();
        BigDecimal totalDiscountAmt = BigDecimal.ZERO;
        for (GiftBean giftBean : giftList) {
            BigDecimal originalPrice = new BigDecimal(giftBean.getOriginalPrice());
            BigDecimal giftQuantity = new BigDecimal(giftBean.getQuantity());
            BigDecimal giftAmt = originalPrice.multiply(giftQuantity);
            totalDiscountAmt = totalDiscountAmt.add(giftAmt);
        }
        return totalDiscountAmt.multiply(new BigDecimal(loopTimes));
    }

    @Override
    protected void discountShareAndRecord(ActivityBO hitActivityBO, List<OrderLineBean> needOrderLineList, OrderComputeResult orderComputeResult) {
        List<OrderLineBean> orderLineBeanList = hitActivityBO.getOrderLineList();
        BigDecimal totalDiscountAmt = hitActivityBO.getTotalDiscountAmt();
        BigDecimal totalAmt = hitActivityBO.getTotalAmt();
        Integer loopTimes = hitActivityBO.getLoopTimes();
        boolean isEffective = false;
        for (OrderLineBean orderLineBean : orderLineBeanList) {
            BigDecimal lastDiscountAmt;
            String activityType;
            BigDecimal oldRealityAmt = orderLineBean.getActualAmount();
            BigDecimal discountAmt = oldRealityAmt.divide(totalAmt, 8, RoundingMode.valueOf(4)).multiply(totalDiscountAmt);
            Map<String, BigDecimal> activityMap = orderLineBean.getActivityMap();
            if (activityMap.containsKey(activityType = hitActivityBO.getActiveType()) && (lastDiscountAmt = activityMap.get(activityType)).compareTo(discountAmt) >= 0) {
                return;
            }
            orderLineBean.getActivityMap().put(hitActivityBO.getActiveType(), discountAmt);
            isEffective = true;
        }
        if (isEffective) {
            Map<String, List<GiftBean>> activeGiftListMap = orderComputeResult.getActiveGiftListMap();
            Map<String, GiftBean> giftSkuMap = orderComputeResult.getGiftSkuMap();
            ConditionBean hitConditioin = hitActivityBO.getHitCondition();
            List<GiftBean> giftList = hitConditioin.getGiftList();
            giftList.forEach(giftBean -> {
                giftBean.setActiveType(hitActivityBO.getActiveType());
                giftBean.setActiveName(hitActivityBO.getActiveName());
                giftBean.setActiveCode(hitActivityBO.getActiveCode());
                giftBean.setQuantity(giftBean.getQuantity() * loopTimes);
                giftBean.setDiscountName(hitConditioin.getDiscountName());
            });
            activeGiftListMap.put(hitActivityBO.getActiveCode(), giftList);
            List<GiftBean> allGiftList = orderComputeResult.getGiftList();
            allGiftList.addAll(giftList);
            allGiftList.forEach(giftBean -> {
                if (giftSkuMap.containsKey(giftBean.getSkuCode())) {
                    GiftBean gift = (GiftBean)giftSkuMap.get(giftBean.getSkuCode());
                    gift.setQuantity(gift.getQuantity() + giftBean.getQuantity());
                } else {
                    giftSkuMap.put(giftBean.getSkuCode(), (GiftBean)giftBean);
                }
            });
            orderComputeResult.setGiftList(new ArrayList<GiftBean>(giftSkuMap.values()));
        }
    }

    public void giftCompute(List<OrderLineBean> giftList, OrderComputeResult orderComputeResult, Boolean isPreview) {
        Map<String, GiftBean> giftSkuMap = orderComputeResult.getGiftSkuMap();
        if (isPreview.booleanValue()) {
            giftList.forEach(orderLineBean -> {
                String skuCode = orderLineBean.getSkuCode();
                if (giftSkuMap.containsKey(skuCode)) {
                    GiftBean giftBean = (GiftBean)giftSkuMap.get(skuCode);
                    BigDecimal giftQuantityLimit = new BigDecimal(giftBean.getQuantity());
                    if (orderLineBean.getSkuUnitQuantity().compareTo(giftQuantityLimit) > 0) {
                        orderLineBean.setQuantityLimit(giftQuantityLimit);
                    } else if (orderLineBean.getSkuUnitQuantity().compareTo(giftQuantityLimit) < 0) {
                        BigDecimal recommendQuantity = giftQuantityLimit.subtract(orderLineBean.getSkuUnitQuantity());
                        giftBean.setQuantity(recommendQuantity.intValue());
                        orderLineBean.setQuantityLimit(recommendQuantity);
                    } else {
                        giftSkuMap.remove(skuCode);
                    }
                } else {
                    orderLineBean.setQuantityLimit(BigDecimal.ZERO);
                }
                this.saveGiftDiscount((OrderLineBean)orderLineBean, orderComputeResult);
            });
            orderComputeResult.setGiftList(new ArrayList<GiftBean>(giftSkuMap.values()));
        } else {
            giftList.forEach(orderLineBean -> {
                String skuCode = orderLineBean.getSkuCode();
                if (giftSkuMap.containsKey(skuCode)) {
                    GiftBean giftBean = (GiftBean)giftSkuMap.get(skuCode);
                    BigDecimal giftQuantityLimit = new BigDecimal(giftBean.getQuantity());
                    if (orderLineBean.getSkuUnitQuantity().compareTo(giftQuantityLimit) > 0) {
                        ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COMPUTE-0001");
                    }
                } else {
                    ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COMPUTE-0002");
                }
                this.saveGiftDiscount((OrderLineBean)orderLineBean, orderComputeResult);
            });
        }
    }

    private void saveGiftDiscount(OrderLineBean orderLineBean, OrderComputeResult orderComputeResult) {
        Map<String, List<GiftBean>> activeGiftListMap = orderComputeResult.getActiveGiftListMap();
        BigDecimal discountQuantity = orderLineBean.getSkuUnitQuantity();
        String skuCode = orderLineBean.getSkuCode();
        boolean isBreak = false;
        for (String activeCode : activeGiftListMap.keySet()) {
            List<GiftBean> giftBeanList = activeGiftListMap.get(activeCode);
            for (GiftBean giftBean : giftBeanList) {
                BigDecimal currentDiscountQuantity;
                if (!StringUtils.equals((CharSequence)skuCode, (CharSequence)giftBean.getSkuCode())) continue;
                BigDecimal giftQuantityLimit = new BigDecimal(giftBean.getQuantity());
                if (discountQuantity.compareTo(giftQuantityLimit) > 0) {
                    currentDiscountQuantity = giftQuantityLimit;
                    discountQuantity = discountQuantity.subtract(currentDiscountQuantity);
                } else if (discountQuantity.compareTo(giftQuantityLimit) < 0) {
                    currentDiscountQuantity = discountQuantity;
                    isBreak = true;
                } else {
                    currentDiscountQuantity = discountQuantity;
                    isBreak = true;
                }
                BigDecimal originPrice = orderLineBean.getOriginPrice();
                BigDecimal currentDiscountAmt = currentDiscountQuantity.multiply(originPrice);
                ActivityBO activityBO = new ActivityBO();
                activityBO.setActiveCode(giftBean.getActiveCode());
                activityBO.setActiveName(giftBean.getActiveName());
                activityBO.setActiveType(giftBean.getActiveType());
                activityBO.setIsGiftOrPurchase(true);
                activityBO.setTotalDiscountAmt(currentDiscountAmt);
                this.recordDiscount(orderComputeResult, orderLineBean, activityBO, giftBean.getDiscountName(), currentDiscountAmt, DiscountTypeEnum.FULL_GIFT.getState(), currentDiscountQuantity);
                this.recordEffectiveActivity(orderComputeResult, activityBO);
                if (!isBreak) continue;
                break;
            }
            if (!isBreak) continue;
            break;
        }
        BigDecimal realityAmt = BigDecimal.ZERO;
        this.computeByRealityAmt(orderLineBean, realityAmt);
    }
}

