/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.impl.discount;

import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.DiscountTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.compute.model.ActivityBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.ConditionBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.DiscountBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.BaseDiscountCalculator;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.OrderComputeResult;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderLineBean;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;

public class DiscountCalculator
extends BaseDiscountCalculator {
    @Override
    protected BigDecimal totalDiscountCompute(ConditionBean hitConditioin, BigDecimal totalAmt, BigDecimal totalQuantity, Integer loopTimes, OrderBO orderBO) {
        DiscountBean discountBean = hitConditioin.getDiscount();
        BigDecimal discount = discountBean.getDiscount();
        BigDecimal totalAmtAfterDiscount = totalAmt.multiply(discount).divide(new BigDecimal(10), 8, RoundingMode.valueOf(4));
        return totalAmt.subtract(totalAmtAfterDiscount);
    }

    @Override
    protected void discountShareAndRecord(ActivityBO hitActivityBO, List<OrderLineBean> needOrderLineList, OrderComputeResult orderComputeResult) {
        List<OrderLineBean> orderLineBeanList = hitActivityBO.getOrderLineList();
        ConditionBean hitConditioin = hitActivityBO.getHitCondition();
        DiscountBean discountBean = hitConditioin.getDiscount();
        BigDecimal discount = discountBean.getDiscount();
        for (OrderLineBean orderLineBean : orderLineBeanList) {
            BigDecimal lastDiscountAmt;
            String activityType;
            BigDecimal oldRealityAmt = orderLineBean.getActualAmount();
            BigDecimal realityAmt = oldRealityAmt.multiply(discount).divide(new BigDecimal(10), 8, RoundingMode.valueOf(4));
            BigDecimal discountAmt = oldRealityAmt.subtract(realityAmt);
            Map<String, BigDecimal> activityMap = orderLineBean.getActivityMap();
            if (activityMap.containsKey(activityType = hitActivityBO.getActiveType()) && (lastDiscountAmt = activityMap.get(activityType)).compareTo(discountAmt) >= 0) {
                return;
            }
            this.computeByRealityAmt(orderLineBean, realityAmt);
            this.recordDiscount(orderComputeResult, orderLineBean, hitActivityBO, hitConditioin.getDiscountName(), discountAmt, DiscountTypeEnum.FULL_DISCOUNT.getState(), orderLineBean.getSkuQuantity());
            orderLineBean.getActivityMap().put(hitActivityBO.getActiveType(), discountAmt);
            this.recordEffectiveActivity(orderComputeResult, hitActivityBO);
        }
    }
}

