/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.impl.discount;

import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.DiscountTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.compute.model.ActivityBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.ConditionBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.DiscountBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.BaseDiscountCalculator;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.OrderComputeResult;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderLineBean;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;

public class BargainPriceCalculator
extends BaseDiscountCalculator {
    @Override
    protected BigDecimal totalDiscountCompute(ConditionBean hitConditioin, BigDecimal totalAmt, BigDecimal totalQuantity, Integer loopTimes, OrderBO orderBO) {
        DiscountBean discountBean = hitConditioin.getDiscount();
        BigDecimal bargainPrice = new BigDecimal(discountBean.getBargainPrice());
        BigDecimal realityAmt = bargainPrice.multiply(totalQuantity);
        return totalAmt.subtract(realityAmt);
    }

    @Override
    protected void discountShareAndRecord(ActivityBO hitActivityBO, List<OrderLineBean> needOrderLineList, OrderComputeResult orderComputeResult) {
        List<OrderLineBean> orderLineBeanList = hitActivityBO.getOrderLineList();
        ConditionBean hitConditioin = hitActivityBO.getHitCondition();
        BigDecimal totalDiscountAmt = hitActivityBO.getTotalDiscountAmt();
        BigDecimal totalAmt = hitActivityBO.getTotalAmt();
        for (OrderLineBean orderLineBean : orderLineBeanList) {
            BigDecimal lastDiscountAmt;
            String activityType;
            BigDecimal oldRealityAmt = orderLineBean.getActualAmount();
            BigDecimal discountAmt = oldRealityAmt.divide(totalAmt, 8, RoundingMode.valueOf(4)).multiply(totalDiscountAmt);
            BigDecimal realityAmt = oldRealityAmt.subtract(discountAmt);
            Map<String, BigDecimal> activityMap = orderLineBean.getActivityMap();
            if (activityMap.containsKey(activityType = hitActivityBO.getActiveType()) && (lastDiscountAmt = activityMap.get(activityType)).compareTo(discountAmt) >= 0) continue;
            this.computeByRealityAmt(orderLineBean, realityAmt);
            this.recordDiscount(orderComputeResult, orderLineBean, hitActivityBO, hitConditioin.getDiscountName(), discountAmt, DiscountTypeEnum.BARGAIN_PRICE.getState(), orderLineBean.getSkuQuantity());
            orderLineBean.getActivityMap().put(hitActivityBO.getActiveType(), discountAmt);
            this.recordEffectiveActivity(orderComputeResult, hitActivityBO);
        }
    }
}

