/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.impl.activity;

import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.compute.model.ActivityBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.promotion.model.PromotionBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.promotion.model.SingleGoodsBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.RuleBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.BaseActivityCalculator;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.ComputeParam;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.OrderComputeResult;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderLineBean;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SingleActivityCalculator
extends BaseActivityCalculator {
    @Override
    protected void hitActivity(ComputeParam computeParam, OrderComputeResult orderComputeResult, ActivityBO activityBO, List<OrderLineBean> needOrderLineList, List<ActivityBO> hitActivityList) {
        OrderBO orderBO = orderComputeResult.getOrder();
        PromotionBO promotionBO = (PromotionBO)activityBO;
        List<SingleGoodsBean> singleGoodsList = promotionBO.getSingleGoodsList();
        HashMap orderLineListMap = new HashMap();
        for (OrderLineBean orderLineBean : needOrderLineList) {
            List<OrderLineBean> orderLineList;
            String skuCode = orderLineBean.getSkuCode();
            if (orderLineListMap.containsKey(skuCode)) {
                orderLineList = (List)orderLineListMap.get(skuCode);
                orderLineList.add(orderLineBean);
                continue;
            }
            orderLineList = new ArrayList();
            orderLineList.add(orderLineBean);
            orderLineListMap.put(skuCode, orderLineList);
        }
        HashMap<String, SingleGoodsBean> singleGoodsMap = new HashMap<String, SingleGoodsBean>();
        for (SingleGoodsBean singleGoodsBean : singleGoodsList) {
            singleGoodsMap.put(singleGoodsBean.getSkuCode(), singleGoodsBean);
        }
        Map<Long, RuleBO> map = computeParam.getRuleMap();
        for (String sku : orderLineListMap.keySet()) {
            if (!singleGoodsMap.containsKey(sku)) continue;
            List orderLineBeanList = (List)orderLineListMap.get(sku);
            Map<String, BigDecimal> amtAndQuantityMap = this.getTotalAmtAndQuantity(orderLineBeanList);
            BigDecimal totalAmt = amtAndQuantityMap.get("totalAmt");
            BigDecimal totalQuantity = amtAndQuantityMap.get("totalQuantity");
            SingleGoodsBean singleGoodsBean = (SingleGoodsBean)singleGoodsMap.get(sku);
            RuleBO ruleBO = map.get(singleGoodsBean.getRuleId());
            ActivityBO hitActivityBO = this.ruleDiscountCompute(activityBO, ruleBO, orderBO, orderLineBeanList, totalAmt, totalQuantity);
            if (hitActivityBO == null || hitActivityBO.getTotalDiscountAmt() == null || hitActivityBO.getTotalDiscountAmt().compareTo(BigDecimal.ZERO) <= 0) continue;
            OrderLineBean orderLineBean = (OrderLineBean)orderLineBeanList.get(0);
            hitActivityBO.setSingleOrderLineId(orderLineBean.getOrderLineId());
            hitActivityList.add(hitActivityBO);
        }
    }

    @Override
    protected Map<String, BigDecimal> getTotalAmtAndQuantity(List<OrderLineBean> orderLineBeanList) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        BigDecimal totalAmt = BigDecimal.ZERO;
        BigDecimal totalQuantity = BigDecimal.ZERO;
        for (OrderLineBean orderLineBean : orderLineBeanList) {
            totalAmt = totalAmt.add(orderLineBean.getAmount());
            totalQuantity = totalQuantity.add(orderLineBean.getSkuUnitQuantity());
        }
        map.put("totalAmt", totalAmt);
        map.put("totalQuantity", totalQuantity);
        return map;
    }
}

