/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.impl.activity;

import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.GoodsRangeTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.compute.model.ActivityBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.promotion.model.PromotionBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.RuleBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.BaseActivityCalculator;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.ComputeParam;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.OrderComputeResult;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderLineBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class OrderActivityCalculator
extends BaseActivityCalculator {
    @Override
    protected void hitActivity(ComputeParam computeParam, OrderComputeResult orderComputeResult, ActivityBO activityBO, List<OrderLineBean> needOrderLineList, List<ActivityBO> hitActivityList) {
        OrderBO orderBO = orderComputeResult.getOrder();
        PromotionBO promotionBO = (PromotionBO)activityBO;
        Map<Long, RuleBO> ruleBOMap = computeParam.getRuleMap();
        RuleBO ruleBO = ruleBOMap.get(promotionBO.getRuleId());
        List<OrderLineBean> orderLineList = StringUtils.equals((CharSequence)promotionBO.getGoodsRangeType(), (CharSequence)GoodsRangeTypeEnum.ALL_GOODS.getState()) ? needOrderLineList : OrderActivityCalculator.filterOrderLineByRange(promotionBO, needOrderLineList);
        this.hitActivity(activityBO, ruleBO, orderBO, hitActivityList, orderLineList);
    }

    private static List<OrderLineBean> filterOrderLineByRange(PromotionBO promotionBO, List<OrderLineBean> needOrderLineList) {
        ArrayList<OrderLineBean> orderLineList = new ArrayList<OrderLineBean>();
        if (!CollectionUtils.isEmpty(promotionBO.getGoodsRangeList())) {
            HashMap goodsRangeMap = new HashMap();
            promotionBO.getGoodsRangeList().forEach(goodsRangeBean -> goodsRangeMap.put(goodsRangeBean.getRangeCode(), goodsRangeBean));
            needOrderLineList.forEach(orderLineBean -> {
                if (StringUtils.equals((CharSequence)promotionBO.getGoodsRangeType(), (CharSequence)GoodsRangeTypeEnum.CATEGORY.getState())) {
                    if (goodsRangeMap.containsKey(String.valueOf(orderLineBean.getCategoryId()))) {
                        orderLineList.add((OrderLineBean)orderLineBean);
                    }
                } else if (StringUtils.equals((CharSequence)promotionBO.getGoodsRangeType(), (CharSequence)GoodsRangeTypeEnum.BRAND.getState())) {
                    if (goodsRangeMap.containsKey(String.valueOf(orderLineBean.getBrandId()))) {
                        orderLineList.add((OrderLineBean)orderLineBean);
                    }
                } else if (StringUtils.equals((CharSequence)promotionBO.getGoodsRangeType(), (CharSequence)GoodsRangeTypeEnum.GOODS_POOL.getState()) && goodsRangeMap.containsKey(orderLineBean.getSkuCode())) {
                    orderLineList.add((OrderLineBean)orderLineBean);
                }
            });
        }
        return orderLineList;
    }
}

