/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.impl.activity;

import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.GoodsRangeTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.compute.model.ActivityBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.coupon.model.CouponBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.coupon.model.CouponReceiveRecordsBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.RuleBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.BaseActivityCalculator;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.ComputeParam;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.OrderComputeResult;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderLineBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class CouponActivityCalculator
extends BaseActivityCalculator {
    @Override
    protected void hitActivity(ComputeParam computeParam, OrderComputeResult orderComputeResult, ActivityBO activityBO, List<OrderLineBean> needOrderLineList, List<ActivityBO> hitActivityList) {
        OrderBO orderBO = orderComputeResult.getOrder();
        CouponBO couponBO = (CouponBO)activityBO;
        Map<Long, RuleBO> ruleBOMap = computeParam.getRuleMap();
        RuleBO ruleBO = ruleBOMap.get(couponBO.getRuleId());
        List<OrderLineBean> orderLineList = StringUtils.equals((CharSequence)couponBO.getGoodsRangeLimitType(), (CharSequence)GoodsRangeTypeEnum.ALL_GOODS.getState()) ? needOrderLineList : CouponActivityCalculator.filterOrderLineByRange(couponBO, needOrderLineList);
        List<CouponReceiveRecordsBean> couponReceiveRecordsList = couponBO.getCouponReceiveRecordsList();
        activityBO.setHitCouponInstanceCode(couponReceiveRecordsList.get(0).getInstanceCode());
        this.hitActivity(activityBO, ruleBO, orderBO, hitActivityList, orderLineList);
    }

    private static List<OrderLineBean> filterOrderLineByRange(CouponBO couponBO, List<OrderLineBean> needOrderLineList) {
        ArrayList<OrderLineBean> orderLineList = new ArrayList<OrderLineBean>();
        if (!CollectionUtils.isEmpty(couponBO.getCouponGoodsRangeList())) {
            HashMap goodsRangeMap = new HashMap();
            couponBO.getCouponGoodsRangeList().forEach(couponGoodsRangeBean -> goodsRangeMap.put(couponGoodsRangeBean.getRangeCode(), couponGoodsRangeBean));
            needOrderLineList.forEach(orderLineBean -> {
                if (StringUtils.equals((CharSequence)couponBO.getGoodsRangeLimitType(), (CharSequence)GoodsRangeTypeEnum.CATEGORY.getState())) {
                    if (goodsRangeMap.containsKey(String.valueOf(orderLineBean.getCategoryId()))) {
                        orderLineList.add((OrderLineBean)orderLineBean);
                    }
                } else if (StringUtils.equals((CharSequence)couponBO.getGoodsRangeLimitType(), (CharSequence)GoodsRangeTypeEnum.BRAND.getState())) {
                    if (goodsRangeMap.containsKey(String.valueOf(orderLineBean.getBrandId()))) {
                        orderLineList.add((OrderLineBean)orderLineBean);
                    }
                } else if (StringUtils.equals((CharSequence)couponBO.getGoodsRangeLimitType(), (CharSequence)GoodsRangeTypeEnum.GOODS_POOL.getState()) && goodsRangeMap.containsKey(orderLineBean.getSkuCode())) {
                    orderLineList.add((OrderLineBean)orderLineBean);
                }
            });
        }
        return orderLineList;
    }
}

