/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ztesoft.zsmart.nros.base.util.ExceptionUtil;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.constant.ComputeContants;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.ComputeConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.ActiveTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.ItemTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.YesOrNoEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.compute.model.ActivityBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.BaseActivityCalculator;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.BaseDiscountCalculator;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.impl.discount.GiftCalculator;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.impl.discount.PurchaseCalculator;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.ComputeParam;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.ComputeResult;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.OrderComputeResult;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderActiveRecordBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderLineBean;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class Calculator {
    private static final Logger logger = LoggerFactory.getLogger(Calculator.class);

    public static ComputeResult execute(ComputeParam computeParam) {
        ComputeResult computeResult = new ComputeResult();
        ArrayList<OrderComputeResult> orderComputeResultList = new ArrayList<OrderComputeResult>();
        List<OrderBO> shopOrderBOList = computeParam.getOrderList();
        BigDecimal originalTotalAmt = BigDecimal.ZERO;
        BigDecimal realityTotalAmt = BigDecimal.ZERO;
        ArrayList<OrderActiveRecordBean> activeRecordList = new ArrayList<OrderActiveRecordBean>();
        for (OrderBO orderBO : shopOrderBOList) {
            OrderComputeResult orderComputeResult = Calculator.orderCompute(computeParam, orderBO);
            orderComputeResultList.add(orderComputeResult);
            originalTotalAmt = originalTotalAmt.add(orderBO.getAmount());
            realityTotalAmt = realityTotalAmt.add(orderBO.getActualAmount());
            if (CollectionUtils.isEmpty(orderBO.getOrderActiveRecordList())) continue;
            activeRecordList.addAll(orderBO.getOrderActiveRecordList());
        }
        computeResult.setOrderComputeResultList(orderComputeResultList);
        computeResult.setOriginalTotalAmt(originalTotalAmt);
        computeResult.setActiveRecordList(activeRecordList);
        computeResult.setRealityTotalAmt(realityTotalAmt);
        return computeResult;
    }

    private static OrderComputeResult orderCompute(ComputeParam computeParam, OrderBO orderBO) {
        BaseDiscountCalculator calculator;
        ArrayList<OrderLineBean> needOrderLineBeanList = new ArrayList<OrderLineBean>();
        ArrayList<OrderLineBean> noNeedOrderLineBeanList = new ArrayList<OrderLineBean>();
        ArrayList<OrderLineBean> giftList = new ArrayList<OrderLineBean>();
        ArrayList<OrderLineBean> purchaseList = new ArrayList<OrderLineBean>();
        Calculator.orderInit(orderBO, needOrderLineBeanList, noNeedOrderLineBeanList, giftList, purchaseList);
        OrderComputeResult orderComputeResult = new OrderComputeResult();
        orderComputeResult.setOrder(orderBO);
        orderComputeResult.setOrderLineBeanList(Lists.newArrayList());
        orderComputeResult.setOrderPromotionList(Lists.newArrayList());
        orderComputeResult.setGiftCouponList(Lists.newArrayList());
        orderComputeResult.setGiftList(Lists.newArrayList());
        orderComputeResult.setPurchaseList(Lists.newArrayList());
        orderComputeResult.setEffectiveTypeActivityMap(Maps.newHashMap());
        orderComputeResult.setEffectiveActivityMap(Maps.newHashMap());
        orderComputeResult.setGiftSkuMap(Maps.newHashMap());
        orderComputeResult.setActiveGiftListMap(Maps.newLinkedHashMap());
        orderComputeResult.setPurchaseSkuMap(Maps.newHashMap());
        orderComputeResult.setActivePurchaseListMap(Maps.newLinkedHashMap());
        orderComputeResult.setGiftCouponMap(Maps.newHashMap());
        orderComputeResult.setSingleActivityMap(Maps.newHashMap());
        List<ActivityBO> activityBOList = computeParam.getActivityBOList();
        Collections.sort(activityBOList);
        LinkedHashMap activityListMap = new LinkedHashMap();
        for (ActivityBO activityBO : activityBOList) {
            List<ActivityBO> tmpActivityList;
            String activityType2 = activityBO.getActiveType();
            if (activityListMap.containsKey(activityType2)) {
                tmpActivityList = (List)activityListMap.get(activityType2);
                tmpActivityList.add(activityBO);
                continue;
            }
            tmpActivityList = new ArrayList();
            tmpActivityList.add(activityBO);
            activityListMap.put(activityType2, tmpActivityList);
        }
        Map<String, String> activityTypeImplConfig = ComputeContants.computeImplClassConfig.get("ACTIVITY_TYPE_COMPUTE_IMPL_KEY");
        activityListMap.keySet().forEach(activityType -> {
            String classPath = (String)activityTypeImplConfig.get(activityType);
            try {
                BaseActivityCalculator calculator = (BaseActivityCalculator)Class.forName(classPath).newInstance();
                calculator.mainProcess(computeParam, (List)activityListMap.get(activityType), orderComputeResult, (String)activityType, (List<OrderLineBean>)needOrderLineBeanList);
            }
            catch (ReflectiveOperationException e) {
                logger.error("\u6d3b\u52a8\u8ba1\u7b97\u5b9e\u73b0\u7c7b\u53cd\u5c04\u5f02\u5e38\uff1a", (Object)ExceptionUtil.getStackTrace((Exception)e));
            }
        });
        if (!CollectionUtils.isEmpty(giftList)) {
            calculator = new GiftCalculator();
            ((GiftCalculator)calculator).giftCompute(giftList, orderComputeResult, computeParam.getIsPreview());
        }
        if (!CollectionUtils.isEmpty(purchaseList)) {
            calculator = new PurchaseCalculator();
            ((PurchaseCalculator)calculator).purchaseCompute(purchaseList, orderComputeResult, computeParam.getIsPreview());
        }
        orderComputeResult.getOrderLineBeanList().addAll(needOrderLineBeanList);
        orderComputeResult.getOrderLineBeanList().addAll(noNeedOrderLineBeanList);
        orderComputeResult.getOrderLineBeanList().addAll(giftList);
        orderComputeResult.getOrderLineBeanList().addAll(purchaseList);
        Calculator.orderResultSummary(orderComputeResult);
        return orderComputeResult;
    }

    private static void orderResultSummary(OrderComputeResult orderComputeResult) {
        OrderBO orderBO = orderComputeResult.getOrder();
        orderComputeResult.getOrder().setOrderLineList(orderComputeResult.getOrderLineBeanList());
        ArrayList<OrderActiveRecordBean> orderActiveRecordList = new ArrayList<OrderActiveRecordBean>();
        Map<String, ActivityBO> effectiveTypeActivityMap = orderComputeResult.getEffectiveTypeActivityMap();
        effectiveTypeActivityMap.keySet().forEach(activeType -> {
            ActivityBO activityBO = (ActivityBO)effectiveTypeActivityMap.get(activeType);
            OrderActiveRecordBean orderActiveRecordBean = ComputeConvertor.INSTANCE.activeToOrderActiveRecord(activityBO);
            orderActiveRecordBean.setOrderNo(orderBO.getOrderNo());
            orderActiveRecordBean.setStoreCode(orderBO.getShopCode());
            orderActiveRecordBean.setChannelCode(orderBO.getChannelId());
            orderActiveRecordBean.setMemberId(orderBO.getMemberCardId());
            if (StringUtils.equals((CharSequence)activeType, (CharSequence)ActiveTypeEnum.SINGLE.getState())) {
                orderActiveRecordBean.setActiveName(ActiveTypeEnum.SINGLE.getName() + "\u6d3b\u52a8");
            }
            orderActiveRecordList.add(orderActiveRecordBean);
        });
        orderBO.setOrderActiveRecordList(orderActiveRecordList);
        BigDecimal totalAmountAfterDiscount = BigDecimal.ZERO;
        Map<Long, List<ActivityBO>> singleActivityMap = orderComputeResult.getSingleActivityMap();
        for (OrderLineBean orderLineBean : orderBO.getOrderLineList()) {
            totalAmountAfterDiscount = totalAmountAfterDiscount.add(orderLineBean.getActualAmount());
            if (!singleActivityMap.containsKey(orderLineBean.getOrderLineId())) continue;
            List<ActivityBO> singleActivityList = singleActivityMap.get(orderLineBean.getOrderLineId());
            orderLineBean.setSingleActivityList(singleActivityList);
        }
        BigDecimal actualAmount = totalAmountAfterDiscount.add(orderBO.getShipmentFee()).subtract(orderBO.getDeductionPointAmount()).subtract(orderBO.getLostAmount());
        orderBO.setActualAmount(actualAmount);
    }

    private static void orderInit(OrderBO orderBO, List<OrderLineBean> orderLineBeanList, List<OrderLineBean> noNeedOrderLineBeanList, List<OrderLineBean> giftList, List<OrderLineBean> purchaseList) {
        BigDecimal amount = BigDecimal.ZERO;
        for (OrderLineBean orderLineBean : orderBO.getOrderLineList()) {
            BigDecimal originalAmt = orderLineBean.getSkuQuantity().multiply(orderLineBean.getOriginPrice());
            BigDecimal skuPrice = orderLineBean.getSkuPrice();
            BigDecimal actualPrice = orderLineBean.getActualPrice();
            BigDecimal actualAmount = orderLineBean.getSkuQuantity().multiply(skuPrice);
            amount = amount.add(actualAmount);
            if (StringUtils.equals((CharSequence)orderLineBean.getItemType(), (CharSequence)ItemTypeEnum.GIFT.getState()) || StringUtils.equals((CharSequence)orderLineBean.getItemType(), (CharSequence)ItemTypeEnum.EXCHANGE.getState())) {
                actualAmount = orderLineBean.getSkuQuantity().multiply(actualPrice);
            }
            BigDecimal discount = actualAmount.divide(originalAmt, 8, RoundingMode.valueOf(4)).multiply(new BigDecimal(100));
            orderLineBean.setAmount(originalAmt);
            orderLineBean.setActualAmount(actualAmount);
            orderLineBean.setTotalDiscountAmt(originalAmt.subtract(actualAmount));
            orderLineBean.setDiscount(discount);
            orderLineBean.setSingleActivityList(new ArrayList<ActivityBO>());
            if (StringUtils.equals((CharSequence)orderLineBean.getAdjustLable(), (CharSequence)YesOrNoEnum.YES.getValue())) {
                noNeedOrderLineBeanList.add(orderLineBean);
                continue;
            }
            if (StringUtils.equals((CharSequence)orderLineBean.getItemType(), (CharSequence)ItemTypeEnum.GIFT.getState())) {
                giftList.add(orderLineBean);
                continue;
            }
            if (StringUtils.equals((CharSequence)orderLineBean.getItemType(), (CharSequence)ItemTypeEnum.EXCHANGE.getState())) {
                purchaseList.add(orderLineBean);
                continue;
            }
            orderLineBeanList.add(orderLineBean);
        }
        orderBO.setAmount(amount);
        orderBO.setShipmentFee(orderBO.getShipmentFee() == null ? BigDecimal.ZERO : orderBO.getShipmentFee());
        orderBO.setOldShipmentFee(orderBO.getShipmentFee());
        orderBO.setLostAmount(orderBO.getLostAmount() == null ? BigDecimal.ZERO : orderBO.getLostAmount());
        orderBO.setDeductionPointAmount(orderBO.getDeductionPointAmount() == null ? BigDecimal.ZERO : orderBO.getDeductionPointAmount());
        orderBO.setActualAmount(amount);
        orderBO.setOrderActiveRecordList(Lists.newArrayList());
    }
}

