/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute;

import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.ActiveTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.compute.model.ActivityBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.ConditionBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.BaseCalculator;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.OrderComputeResult;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderLineBean;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDiscountCalculator
extends BaseCalculator {
    private static final Logger logger = LoggerFactory.getLogger(BaseDiscountCalculator.class);

    protected abstract BigDecimal totalDiscountCompute(ConditionBean var1, BigDecimal var2, BigDecimal var3, Integer var4, OrderBO var5);

    protected abstract void discountShareAndRecord(ActivityBO var1, List<OrderLineBean> var2, OrderComputeResult var3);

    protected void recordEffectiveActivity(OrderComputeResult orderComputeResult, ActivityBO effectiveActivity) {
        Map<String, ActivityBO> effectiveActivityMap = orderComputeResult.getEffectiveActivityMap();
        if (!effectiveActivityMap.containsKey(effectiveActivity.getActiveCode())) {
            effectiveActivityMap.put(effectiveActivity.getActiveCode(), effectiveActivity);
        } else if (effectiveActivity.getIsGiftOrPurchase().booleanValue()) {
            ActivityBO activityBO = effectiveActivityMap.get(effectiveActivity.getActiveCode());
            activityBO.setTotalDiscountAmt(activityBO.getTotalDiscountAmt().add(effectiveActivity.getTotalDiscountAmt()));
        }
        Map<String, ActivityBO> effectiveTypeActivityMap = orderComputeResult.getEffectiveTypeActivityMap();
        if (!effectiveTypeActivityMap.containsKey(effectiveActivity.getActiveType())) {
            effectiveTypeActivityMap.put(effectiveActivity.getActiveType(), effectiveActivity);
        } else if (StringUtils.equals((CharSequence)effectiveActivity.getActiveType(), (CharSequence)ActiveTypeEnum.SINGLE.getState())) {
            ActivityBO activityBO = effectiveTypeActivityMap.get(effectiveActivity.getActiveType());
            activityBO.setTotalDiscountAmt(activityBO.getTotalDiscountAmt().add(effectiveActivity.getTotalDiscountAmt()));
        } else if (effectiveActivity.getIsGiftOrPurchase().booleanValue()) {
            ActivityBO activityBO = effectiveTypeActivityMap.get(effectiveActivity.getActiveType());
            activityBO.setTotalDiscountAmt(activityBO.getTotalDiscountAmt().add(effectiveActivity.getTotalDiscountAmt()));
        }
        if (StringUtils.isNotBlank((CharSequence)effectiveActivity.getHitCouponInstanceCode())) {
            orderComputeResult.setEffectiveCouponInstanceCode(effectiveActivity.getHitCouponInstanceCode());
        }
    }
}

