/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute;

import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.compute.model.ActivityBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.OrderComputeResult;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderLineBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderPromotionBean;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseCalculator {
    protected void computeByRealityAmt(OrderLineBean orderLineBean, BigDecimal realityAmt) {
        if (realityAmt.compareTo(BigDecimal.ZERO) < 0) {
            realityAmt = BigDecimal.ZERO;
        }
        BigDecimal originalAmt = orderLineBean.getAmount();
        BigDecimal promotionPrice = realityAmt.divide(orderLineBean.getSkuQuantity(), 8, RoundingMode.valueOf(4));
        BigDecimal totalDiscountAmt = originalAmt.subtract(realityAmt);
        BigDecimal discount = realityAmt.divide(originalAmt, 8, RoundingMode.valueOf(4)).multiply(new BigDecimal(100));
        orderLineBean.setTotalDiscountAmt(totalDiscountAmt);
        orderLineBean.setActualPrice(promotionPrice);
        orderLineBean.setActualAmount(realityAmt);
        orderLineBean.setDiscount(discount.setScale(2, 4));
    }

    protected void recordDiscount(OrderComputeResult orderComputeResult, OrderLineBean orderLineBean, ActivityBO activityBO, String discountName, BigDecimal discountAmt, String discountType, BigDecimal discountQuantity) {
        OrderBO orderBO = orderComputeResult.getOrder();
        OrderPromotionBean orderPromotion = new OrderPromotionBean();
        orderPromotion.setRootOrderNo(orderBO.getRootOrderNo());
        orderPromotion.setOrderLineId(orderLineBean.getOrderLineId());
        orderPromotion.setOrderNo(orderLineBean.getOrderNo());
        orderPromotion.setChannelId(orderBO.getChannelId());
        orderPromotion.setStoreCode(orderBO.getShopCode());
        orderPromotion.setSkuCode(orderLineBean.getSkuCode());
        orderPromotion.setDiscountAmt(discountAmt);
        orderPromotion.setActiveType(activityBO.getActiveType());
        orderPromotion.setActiveName(activityBO.getActiveName());
        orderPromotion.setActiveCode(activityBO.getActiveCode());
        orderPromotion.setDiscountType(discountType);
        orderPromotion.setDiscountName(discountName);
        orderPromotion.setDiscountQuantity(discountQuantity);
        orderPromotion.setUnitId(orderLineBean.getPackingUnit());
        orderPromotion.setOriginalAmt(orderLineBean.getAmount());
        orderPromotion.setOriginalSkuPrice(orderLineBean.getSkuPrice());
        orderPromotion.setExclusiveWithOther(activityBO.getExclusiveWithOther());
        if (StringUtils.isNotBlank((CharSequence)activityBO.getHitCouponInstanceCode())) {
            orderPromotion.setCouponInstanceCode(activityBO.getHitCouponInstanceCode());
        }
        orderComputeResult.getOrderPromotionList().add(orderPromotion);
    }
}

