/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ztesoft.zsmart.nros.base.util.DateUtil;
import com.ztesoft.zsmart.nros.base.util.ExceptionUtil;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.constant.ComputeContants;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.ActiveTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.ConditionLoopEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.ConditionTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.CouponStatusEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.PromotionStateEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.SellUnitEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.UserScopeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.YesOrNoEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.compute.model.ActivityBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.coupon.model.CouponBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.coupon.model.CouponReceiveRecordsBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.promotion.model.PromotionBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.ConditionBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.RuleBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.BaseCalculator;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.BaseDiscountCalculator;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.ComputeParam;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.OrderComputeResult;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderLineBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.compute.model.order.OrderPromotionBean;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseActivityCalculator
extends BaseCalculator {
    private static final Logger logger = LoggerFactory.getLogger(BaseActivityCalculator.class);

    protected void mainProcess(ComputeParam computeParam, List<ActivityBO> activityBOList, OrderComputeResult orderComputeResult, String activityType, List<OrderLineBean> orderLineBeanList) {
        OrderBO orderBO = orderComputeResult.getOrder();
        ArrayList<OrderLineBean> needOrderLineList = new ArrayList<OrderLineBean>();
        Boolean isVip = false;
        if (orderBO.getMemberCardId() != null) {
            isVip = true;
        }
        this.orderLineFilter(orderLineBeanList, needOrderLineList, orderComputeResult);
        ArrayList<ActivityBO> hitActivityList = new ArrayList<ActivityBO>();
        for (ActivityBO activityBO : activityBOList) {
            if (!this.activityFilter(activityBO, orderBO, isVip, computeParam.getRuleMap()).booleanValue()) continue;
            this.hitActivity(computeParam, orderComputeResult, activityBO, needOrderLineList, hitActivityList);
        }
        Collections.sort(hitActivityList);
        if (!CollectionUtils.isEmpty(hitActivityList)) {
            if (StringUtils.equals((CharSequence)activityType, (CharSequence)ActiveTypeEnum.SINGLE.getState())) {
                HashMap<Long, List<ActivityBO>> singleActivityMap = new HashMap<Long, List<ActivityBO>>();
                for (ActivityBO hitActivityBO : hitActivityList) {
                    List<ActivityBO> singleActivityList;
                    if (singleActivityMap.containsKey(hitActivityBO.getSingleOrderLineId())) {
                        singleActivityList = (List)singleActivityMap.get(hitActivityBO.getSingleOrderLineId());
                        singleActivityList.add(hitActivityBO);
                    } else {
                        singleActivityList = new ArrayList<ActivityBO>();
                        singleActivityList.add(hitActivityBO);
                        singleActivityMap.put(hitActivityBO.getSingleOrderLineId(), singleActivityList);
                    }
                    BaseDiscountCalculator calculator = hitActivityBO.getCalculator();
                    calculator.discountShareAndRecord(hitActivityBO, needOrderLineList, orderComputeResult);
                }
                orderComputeResult.setSingleActivityMap(singleActivityMap);
            } else {
                ActivityBO hitActivityBO = (ActivityBO)hitActivityList.get(0);
                BaseDiscountCalculator calculator = hitActivityBO.getCalculator();
                calculator.discountShareAndRecord(hitActivityBO, needOrderLineList, orderComputeResult);
            }
        }
    }

    protected abstract void hitActivity(ComputeParam var1, OrderComputeResult var2, ActivityBO var3, List<OrderLineBean> var4, List<ActivityBO> var5);

    protected void orderLineFilter(List<OrderLineBean> orderLineBeanList, List<OrderLineBean> needOrderLineList, OrderComputeResult orderComputeResult) {
        List<OrderPromotionBean> orderPromotionList = orderComputeResult.getOrderPromotionList();
        HashMap exclusiveDiscountMap = new HashMap();
        if (!CollectionUtils.isEmpty(orderPromotionList)) {
            orderPromotionList.forEach(orderPromotionBean -> {
                if (StringUtils.equals((CharSequence)orderPromotionBean.getActiveType(), (CharSequence)ActiveTypeEnum.SINGLE.getState()) && StringUtils.equals((CharSequence)orderPromotionBean.getExclusiveWithOther(), (CharSequence)YesOrNoEnum.YES.getValue())) {
                    exclusiveDiscountMap.put(orderPromotionBean.getOrderLineId(), "");
                }
            });
        }
        if (exclusiveDiscountMap.isEmpty()) {
            needOrderLineList.addAll(orderLineBeanList);
        } else {
            for (OrderLineBean orderLineBean : orderLineBeanList) {
                if (exclusiveDiscountMap.containsKey(orderLineBean.getOrderLineId())) continue;
                needOrderLineList.add(orderLineBean);
            }
        }
    }

    private Boolean activityFilter(ActivityBO activityBO, OrderBO orderBO, Boolean isVip, Map<Long, RuleBO> ruleMap) {
        Date now = new Date();
        JSONArray channels = activityBO.getChannel();
        if (!CollectionUtils.isEmpty((Collection)channels) && !channels.contains((Object)orderBO.getChannelId())) {
            return false;
        }
        JSONArray storeCodes = activityBO.getStoreCode();
        if (!CollectionUtils.isEmpty((Collection)storeCodes) && !storeCodes.contains((Object)orderBO.getShopCode())) {
            return false;
        }
        if (StringUtils.equals((CharSequence)ActiveTypeEnum.COUPON.getState(), (CharSequence)activityBO.getActiveType()) || StringUtils.equals((CharSequence)ActiveTypeEnum.FREIGHT_COUPON.getState(), (CharSequence)activityBO.getActiveType())) {
            CouponBO couponBO = (CouponBO)activityBO;
            if (!StringUtils.equals((CharSequence)CouponStatusEnum.ACTIVATED.getState(), (CharSequence)couponBO.getCouponStatus())) {
                return false;
            }
            if (!ruleMap.containsKey(couponBO.getRuleId())) {
                return false;
            }
            List<CouponReceiveRecordsBean> couponReceiveRecordsList = couponBO.getCouponReceiveRecordsList();
            if (CollectionUtils.isEmpty(couponReceiveRecordsList)) {
                return false;
            }
            Collections.sort(couponReceiveRecordsList);
            ArrayList<CouponReceiveRecordsBean> effectiveList = new ArrayList<CouponReceiveRecordsBean>();
            for (CouponReceiveRecordsBean couponReceiveRecords : couponReceiveRecordsList) {
                if (couponReceiveRecords.getUseStartTime().getTime() > now.getTime() || couponReceiveRecords.getUseEndTime().getTime() < now.getTime()) continue;
                effectiveList.add(couponReceiveRecords);
                break;
            }
            if (effectiveList.size() == 0) {
                return false;
            }
            couponBO.setCouponReceiveRecordsList(effectiveList);
        } else {
            PromotionBO promotionBO = (PromotionBO)activityBO;
            if (!StringUtils.equals((CharSequence)PromotionStateEnum.ENABLE.getState(), (CharSequence)promotionBO.getPromotionState())) {
                return false;
            }
            if (!ruleMap.containsKey(promotionBO.getRuleId())) {
                return false;
            }
            if (promotionBO.getStartTime().getTime() > now.getTime() || promotionBO.getEndTime().getTime() < now.getTime()) {
                return false;
            }
            if (StringUtils.isNotBlank((CharSequence)promotionBO.getStartPoint()) && StringUtils.isNotBlank((CharSequence)promotionBO.getEndPoint())) {
                String startPoint = DateUtil.dateToStr((Date)now, (String)"yyyy-MM-dd") + " " + promotionBO.getStartPoint();
                String endPoint = DateUtil.dateToStr((Date)now, (String)"yyyy-MM-dd") + " " + promotionBO.getEndPoint();
                if (DateUtil.strToDate((String)startPoint).getTime() > now.getTime() || DateUtil.strToDate((String)endPoint).getTime() < now.getTime()) {
                    return false;
                }
            }
            if (StringUtils.equals((CharSequence)promotionBO.getUserScope(), (CharSequence)UserScopeEnum.VIP.getState())) {
                if (!isVip.booleanValue()) {
                    return false;
                }
                if (CollectionUtils.isNotEmpty((Collection)promotionBO.getMemberLevelScope())) {
                    boolean flag = false;
                    JSONArray memberLevelScope = promotionBO.getMemberLevelScope();
                    for (Object obj : memberLevelScope) {
                        JSONObject memberLevelScopeJson = (JSONObject)obj;
                        if (!StringUtils.equals((CharSequence)orderBO.getMemberCategoryId(), (CharSequence)memberLevelScopeJson.getString("categoryId")) || !StringUtils.equals((CharSequence)orderBO.getMemberLevel(), (CharSequence)memberLevelScopeJson.getString("level"))) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        return false;
                    }
                }
            } else if (StringUtils.equals((CharSequence)promotionBO.getUserScope(), (CharSequence)UserScopeEnum.NON_VIP.getState()) && isVip.booleanValue()) {
                return false;
            }
        }
        return true;
    }

    protected Map<String, BigDecimal> getTotalAmtAndQuantity(List<OrderLineBean> orderLineBeanList) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        BigDecimal totalAmt = BigDecimal.ZERO;
        BigDecimal totalQuantity = BigDecimal.ZERO;
        for (OrderLineBean orderLineBean : orderLineBeanList) {
            totalAmt = totalAmt.add(orderLineBean.getActualAmount());
            if (!SellUnitEnum.STANDARD.getState().equals(orderLineBean.getSellUnit())) continue;
            totalQuantity = totalQuantity.add(orderLineBean.getSkuUnitQuantity());
        }
        map.put("totalAmt", totalAmt);
        map.put("totalQuantity", totalQuantity);
        return map;
    }

    protected ConditionBean getHitCondition(RuleBO ruleBO, BigDecimal totalAmt, BigDecimal totalQuantity) {
        List<ConditionBean> conditionList = ruleBO.getRuleConditions();
        Collections.sort(conditionList);
        for (ConditionBean conditionBean : conditionList) {
            if (StringUtils.equals((CharSequence)conditionBean.getConditionType(), (CharSequence)ConditionTypeEnum.AMT.getState()) && totalAmt.longValue() >= conditionBean.getAmountOfMoney()) {
                return conditionBean;
            }
            if (StringUtils.equals((CharSequence)conditionBean.getConditionType(), (CharSequence)ConditionTypeEnum.QUANTITY.getState()) && totalQuantity.longValue() >= (long)conditionBean.getQuantity().intValue()) {
                return conditionBean;
            }
            if (!StringUtils.equals((CharSequence)conditionBean.getConditionType(), (CharSequence)ConditionTypeEnum.NO_CONDITION.getState())) continue;
            return conditionBean;
        }
        return null;
    }

    protected ActivityBO ruleDiscountCompute(ActivityBO activityBO, RuleBO ruleBO, OrderBO orderBO, List<OrderLineBean> orderLineBeanList, BigDecimal totalAmt, BigDecimal totalQuantity) {
        ConditionBean hitCondition = this.getHitCondition(ruleBO, totalAmt, totalQuantity);
        if (hitCondition == null) {
            return null;
        }
        Integer loopTimes = 1;
        if (StringUtils.equals((CharSequence)ruleBO.getConditionLoop(), (CharSequence)ConditionLoopEnum.LOOP.getState())) {
            if (StringUtils.equals((CharSequence)hitCondition.getConditionType(), (CharSequence)ConditionTypeEnum.AMT.getState())) {
                loopTimes = totalAmt.divide(new BigDecimal(hitCondition.getAmountOfMoney()), 8, RoundingMode.valueOf(4)).intValue();
            } else if (StringUtils.equals((CharSequence)hitCondition.getConditionType(), (CharSequence)ConditionTypeEnum.QUANTITY.getState())) {
                loopTimes = totalQuantity.divide(new BigDecimal(hitCondition.getQuantity()), 8, RoundingMode.valueOf(4)).intValue();
            }
        }
        String discountType = ruleBO.getDiscountType();
        Map<String, String> discountTypeImplConfig = ComputeContants.computeImplClassConfig.get("DISCOUNT_TYPE_COMPUTE_IMPL_KEY");
        String classPath = discountTypeImplConfig.get(discountType);
        BaseDiscountCalculator calculator = null;
        try {
            calculator = (BaseDiscountCalculator)Class.forName(classPath).newInstance();
            BigDecimal totalAiscountAmt = calculator.totalDiscountCompute(hitCondition, totalAmt, totalQuantity, loopTimes, orderBO);
            activityBO.setHitRule(ruleBO);
            activityBO.setHitCondition(hitCondition);
            activityBO.setOrderLineList(orderLineBeanList);
            activityBO.setTotalAmt(totalAmt);
            activityBO.setLoopTimes(loopTimes);
            activityBO.setTotalQuantity(totalQuantity);
            activityBO.setTotalDiscountAmt(totalAiscountAmt);
            activityBO.setCalculator(calculator);
            return activityBO;
        }
        catch (ReflectiveOperationException e) {
            logger.error("\u4f18\u60e0\u8ba1\u7b97\u5b9e\u73b0\u7c7b\u53cd\u5c04\u5f02\u5e38\uff1a", (Object)ExceptionUtil.getStackTrace((Exception)e));
            return null;
        }
    }

    protected void hitActivity(ActivityBO activityBO, RuleBO ruleBO, OrderBO orderBO, List<ActivityBO> hitActivityList, List<OrderLineBean> orderLineList) {
        BigDecimal totalQuantity;
        Map<String, BigDecimal> amtAndQuantityMap;
        BigDecimal totalAmt;
        ActivityBO hitActivityBO;
        if (!CollectionUtils.isEmpty(orderLineList) && (hitActivityBO = this.ruleDiscountCompute(activityBO, ruleBO, orderBO, orderLineList, totalAmt = (amtAndQuantityMap = this.getTotalAmtAndQuantity(orderLineList)).get("totalAmt"), totalQuantity = amtAndQuantityMap.get("totalQuantity"))) != null && hitActivityBO.getTotalDiscountAmt() != null && hitActivityBO.getTotalDiscountAmt().compareTo(BigDecimal.ZERO) > 0) {
            hitActivityList.add(hitActivityBO);
        }
    }
}

