/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule;

import com.github.pagehelper.PageInfo;
import com.ztesoft.zsmart.nros.base.exception.ExceptionHandler;
import com.ztesoft.zsmart.nros.base.util.paas.CacheUtils;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.ConditionDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.RuleDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.RuleDeleteParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.RuleSaveParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.RuleQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.RuleDeleteConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.RuleSaveConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.DiscountTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.util.NrosPreconditions;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.coupon.CouponDomain;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.ConditionBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.DiscountBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.GiftBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.GiftCouponBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.PurchaseBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.rule.model.RuleBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.repository.RuleRepository;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RuleDomain {
    private static final Logger logger = LoggerFactory.getLogger(CouponDomain.class);
    @Autowired
    private RuleRepository ruleRepository;
    @Autowired
    private CacheUtils cacheUtils;

    public Long addRule(RuleSaveParam ruleSaveParam) {
        RuleBO ruleBO = (RuleBO)RuleSaveConvertor.INSTANCE.paramToBO(ruleSaveParam);
        this.addCheck(ruleBO);
        return this.ruleRepository.addRule(ruleBO);
    }

    public void modifyRule(RuleSaveParam ruleSaveParam) {
        NrosPreconditions.getInstance().notNull(ruleSaveParam.getId(), "NROS-SBC-PROMOTION-RULE-0001");
        RuleBO ruleBO = (RuleBO)RuleSaveConvertor.INSTANCE.paramToBO(ruleSaveParam);
        this.ruleRepository.modifyRule(ruleBO);
    }

    public void deleteRule(RuleDeleteParam ruleDeleteParam) {
        RuleBO ruleBO = RuleDeleteConvertor.INSTANCE.paramToBO(ruleDeleteParam);
        this.ruleRepository.deleteRule(ruleBO);
    }

    private void addCheck(RuleBO ruleBO) {
        String discountType = ruleBO.getDiscountType();
        List<ConditionBean> conditionList = ruleBO.getRuleConditions();
        NrosPreconditions.getInstance().hasText(discountType, "NROS-SBC-PROMOTION-RULE-0005");
        NrosPreconditions.getInstance().hasText(ruleBO.getConditionLoop(), "NROS-SBC-PROMOTION-RULE-0007");
        NrosPreconditions.getInstance().notEmpty(conditionList, "NROS-SBC-PROMOTION-RULE-0009");
        if (DiscountTypeEnum.FULL_DISCOUNT.getState().equals(discountType)) {
            conditionList.forEach(conditionBean -> {
                DiscountBean discountBean = conditionBean.getDiscount();
                NrosPreconditions.getInstance().hasPositiveNumber(discountBean.getDiscount(), "NROS-SBC-PROMOTION-RULE-0011");
            });
        } else if (DiscountTypeEnum.FULL_REDUCTION.getState().equals(discountType)) {
            conditionList.forEach(conditionBean -> {
                DiscountBean discountBean = conditionBean.getDiscount();
                NrosPreconditions.getInstance().hasPositiveNumber(discountBean.getReducePrice(), "NROS-SBC-PROMOTION-RULE-0012");
            });
        } else if (DiscountTypeEnum.FULL_FREE.getState().equals(discountType)) {
            conditionList.forEach(conditionBean -> {
                DiscountBean discountBean = conditionBean.getDiscount();
                NrosPreconditions.getInstance().hasPositiveNumber(discountBean.getFreeQuantity(), "NROS-SBC-PROMOTION-RULE-0013");
            });
        } else if (DiscountTypeEnum.BARGAIN_PRICE.getState().equals(discountType)) {
            conditionList.forEach(conditionBean -> {
                DiscountBean discountBean = conditionBean.getDiscount();
                NrosPreconditions.getInstance().hasPositiveNumber(discountBean.getBargainPrice(), "NROS-SBC-PROMOTION-RULE-0012");
            });
        } else if (DiscountTypeEnum.FULL_GIFT.getState().equals(discountType)) {
            conditionList.forEach(conditionBean -> {
                List<GiftBean> giftBeans = conditionBean.getGiftList();
                giftBeans.forEach(giftBean -> {
                    NrosPreconditions.getInstance().hasPositiveNumber(giftBean.getQuantity(), "NROS-SBC-PROMOTION-RULE-0013");
                    NrosPreconditions.getInstance().hasText(giftBean.getSkuCode(), "NROS-SBC-PROMOTION-RULE-0014");
                    NrosPreconditions.getInstance().hasText(giftBean.getName(), "NROS-SBC-PROMOTION-RULE-0015");
                });
            });
        } else if (DiscountTypeEnum.FULL_PURCHASE.getState().equals(discountType)) {
            conditionList.forEach(conditionBean -> {
                List<PurchaseBean> purchaseBeanList = conditionBean.getPurchaseList();
                purchaseBeanList.forEach(purchaseBean -> {
                    NrosPreconditions.getInstance().hasPositiveNumber(purchaseBean.getPrice(), "NROS-SBC-PROMOTION-RULE-0012");
                    NrosPreconditions.getInstance().hasText(purchaseBean.getSkuCode(), "NROS-SBC-PROMOTION-RULE-0014");
                    NrosPreconditions.getInstance().hasText(purchaseBean.getName(), "NROS-SBC-PROMOTION-RULE-0015");
                });
            });
        } else if (DiscountTypeEnum.FULL_GIFT_COUPON.getState().equals(discountType)) {
            conditionList.forEach(conditionBean -> {
                List<GiftCouponBean> giftCouponBeanList = conditionBean.getGiftCouponList();
                giftCouponBeanList.forEach(giftCouponBean -> {
                    NrosPreconditions.getInstance().hasPositiveNumber(giftCouponBean.getQuantity(), "NROS-SBC-PROMOTION-RULE-0013");
                    NrosPreconditions.getInstance().hasText(giftCouponBean.getCouponCode(), "NROS-SBC-PROMOTION-COUPON-0008");
                    NrosPreconditions.getInstance().hasText(giftCouponBean.getCouponName(), "NROS-SBC-PROMOTION-COUPON-0001");
                });
            });
        }
    }

    public PageInfo<RuleDTO> pageRule(RuleQuery ruleQuery) {
        PageInfo<RuleDTO> ruleDTOPageInfo = this.ruleRepository.pageRule(ruleQuery);
        return ruleDTOPageInfo;
    }

    public RuleDTO detailRule(Long ruleId) {
        RuleDTO ruleDTO;
        if (ruleId == null) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-RULE-0001");
        }
        if ((ruleDTO = this.ruleRepository.findRuleById(ruleId)) == null) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-RULE-0002");
        }
        List<ConditionDTO> conditionDTOList = this.ruleRepository.listConditionAndDiscountByRuleId(ruleId);
        ruleDTO.setRuleConditions(conditionDTOList);
        return ruleDTO;
    }

    public List<ConditionDTO> listConditionDetailByRuleList(List<Long> ruleIds) {
        List<ConditionDTO> rs = new ArrayList<ConditionDTO>();
        if (CollectionUtils.isNotEmpty(ruleIds)) {
            rs = this.ruleRepository.listConditionDetailByRuleList(ruleIds);
        }
        return rs;
    }

    public Map<Long, RuleBO> getRuleMap(String ruleKey, List<Long> ruleIdList) {
        Map<Long, RuleBO> ruleMap;
        Object couponObjectMap = this.cacheUtils.get(ruleKey);
        if (couponObjectMap == null) {
            ruleMap = this.refreshRuleCache(ruleKey, ruleIdList);
        } else {
            Map ruleStrMap = (Map)couponObjectMap;
            ruleMap = new HashMap<Long, RuleBO>();
            ruleStrMap.keySet().forEach(ruleIdStr -> ruleMap.put(Long.parseLong(ruleIdStr), (RuleBO)ruleStrMap.get(ruleIdStr)));
        }
        return ruleMap;
    }

    public void clearRuleCache(String ruleKey) {
        this.cacheUtils.remove(ruleKey);
    }

    public Map<Long, RuleBO> refreshRuleCache(String ruleKey, List<Long> ruleIdList) {
        HashMap<Long, RuleBO> ruleMap = new HashMap<Long, RuleBO>();
        List<RuleDTO> ruleDTOList = this.ruleRepository.listRuleByIds(ruleIdList);
        if (CollectionUtils.isNotEmpty(ruleDTOList)) {
            List<RuleBO> ruleList = RuleSaveConvertor.INSTANCE.dtoListToBO(ruleDTOList);
            for (RuleBO ruleBO : ruleList) {
                ruleMap.put(ruleBO.getId(), ruleBO);
            }
            this.cacheUtils.set(ruleKey, ruleMap);
        }
        return ruleMap;
    }
}

