/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.promotion.server.domain.promotion;

import com.alibaba.ans.shaded.com.google.common.collect.Lists;
import com.github.pagehelper.PageInfo;
import com.ztesoft.zsmart.nros.base.exception.ExceptionHandler;
import com.ztesoft.zsmart.nros.base.util.paas.CacheUtils;
import com.ztesoft.zsmart.nros.common.model.enums.StatusEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.AllGoodsDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.GoodsRangeDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.PromotionDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.SingleGoodsDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.SingleGoodsDetailDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.GoodsRangeDeleteParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.GoodsRangeParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.PromotionDeleteParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.PromotionParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.SingleGoodsDeleteParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.SingleGoodsParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.GoodsRangeQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.PromotionQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.SingleGoodsQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.GoodsRangeConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.PromotionConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.PromotionDeleteConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.SingleGoodsConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.GoodsRangeTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.PromotionStateEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.PromotionTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.YesOrNoEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.util.NrosPreconditions;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.promotion.model.GoodsRangeBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.promotion.model.PromotionBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.promotion.model.SingleGoodsBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.middleware.mq.producer.PromotionProducer;
import com.ztesoft.zsmart.nros.sbc.promotion.server.repository.PromotionRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PromotionDomain {
    public static final Logger logger = LoggerFactory.getLogger(PromotionDomain.class);
    @Autowired
    private PromotionRepository promotionRepository;
    @Autowired
    private CacheUtils cacheUtils;
    @Autowired
    private PromotionProducer promotionProducer;

    public Long savePromotionInfo(PromotionParam promotionParam) {
        promotionParam.setPromotionState(PromotionStateEnum.IN_DESIGN.getState());
        this.checkBeforeSave(promotionParam);
        PromotionBO promotionBO = this.promotionParamToBO(promotionParam);
        return this.promotionRepository.savePromotionInfo(promotionBO);
    }

    private void checkBeforeSave(PromotionParam promotionParam) {
        NrosPreconditions.getInstance().hasText(promotionParam.getPromotionType(), "NROS-SBC-PROMOTION-0004");
        NrosPreconditions.getInstance().hasText(promotionParam.getName(), "NROS-SBC-PROMOTION-0008");
        NrosPreconditions.getInstance().notEmpty((Collection<?>)promotionParam.getChannel(), "NROS-SBC-PROMOTION-0010");
        if (YesOrNoEnum.NO.getValue().equals(promotionParam.getUseAllLocations())) {
            NrosPreconditions.getInstance().notEmpty((Collection<?>)promotionParam.getStoreCode(), "NROS-SBC-PROMOTION-0011");
        }
        NrosPreconditions.getInstance().hasText(promotionParam.getUserScope(), "NROS-SBC-PROMOTION-0012");
        NrosPreconditions.getInstance().notNull(promotionParam.getStartTime(), "NROS-SBC-PROMOTION-0013");
        NrosPreconditions.getInstance().notNull(promotionParam.getEndTime(), "NROS-SBC-PROMOTION-0014");
    }

    public Long modifyPromotionInfo(PromotionParam promotionParam) {
        PromotionDTO promotionDTO = this.checkBeforeModify(promotionParam.getId());
        if (!StringUtils.equals((CharSequence)promotionDTO.getPromotionType(), (CharSequence)promotionParam.getPromotionType())) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-0027");
        }
        this.checkBeforeSave(promotionParam);
        PromotionBO promotionBO = this.promotionParamToBO(promotionParam);
        return this.promotionRepository.modifyPromotionInfo(promotionBO);
    }

    public PromotionBO promotionParamToBO(PromotionParam promotionParam) {
        PromotionBO promotionBO = (PromotionBO)PromotionConvertor.INSTANCE.paramToBO(promotionParam);
        promotionBO.setCouponBatchLimit(promotionParam.getCouponBatchLimits());
        promotionBO.setChannel(promotionParam.getChannel());
        promotionBO.setStoreCode(promotionParam.getStoreCode());
        return promotionBO;
    }

    public void deletePromotion(PromotionDeleteParam promotionDeleteParam) {
        this.checkBeforeDelete(promotionDeleteParam.getId());
        PromotionBO promotionBO = PromotionDeleteConvertor.INSTANCE.paramToBO(promotionDeleteParam);
        this.promotionRepository.deletePromotion(promotionBO);
    }

    public PageInfo<PromotionDTO> pagePromotion(PromotionQuery promotionQuery) {
        return this.promotionRepository.pagePromotion(promotionQuery);
    }

    public PromotionDTO detailPromotion(PromotionQuery promotionQuery) {
        Long promotionId = promotionQuery.getId();
        PromotionDTO promotionDTO = this.checkPromotionById(promotionId);
        String promotionType = promotionDTO.getPromotionType();
        if (PromotionTypeEnum.SINGLE.getState().equals(promotionType)) {
            SingleGoodsQuery singleGoodsQuery = new SingleGoodsQuery();
            singleGoodsQuery.setPromotionId(promotionId);
            List<SingleGoodsDTO> singleGoodsDTOList = this.promotionRepository.querySingleGoods(singleGoodsQuery);
            promotionDTO.setSingleGoodsList(singleGoodsDTOList);
        } else if (PromotionTypeEnum.ORDER.getState().equals(promotionType)) {
            List<GoodsRangeDTO> goodsRangeDTOList = this.promotionRepository.listGoodsRangeByPromotionId(promotionId);
            promotionDTO.setGoodsRangeList(goodsRangeDTOList);
        }
        return promotionDTO;
    }

    public Long saveSingleGoods(SingleGoodsParam singleGoodsParam) {
        this.checkBeforeModify(singleGoodsParam.getPromotionId());
        SingleGoodsQuery singleGoodsQuery = new SingleGoodsQuery();
        singleGoodsQuery.setPromotionId(singleGoodsParam.getPromotionId());
        singleGoodsQuery.setSkuCode(singleGoodsParam.getSkuCode());
        List<SingleGoodsDTO> singleGoodsDTOS = this.promotionRepository.querySingleGoods(singleGoodsQuery);
        if (CollectionUtils.isNotEmpty(singleGoodsDTOS)) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-0022");
        }
        SingleGoodsBean singleGoodsBean = (SingleGoodsBean)SingleGoodsConvertor.INSTANCE.paramToBO(singleGoodsParam);
        return this.promotionRepository.saveSingleGoods(singleGoodsBean);
    }

    public Long modifySingleGoods(SingleGoodsParam singleGoodsParam) {
        this.checkBeforeModify(singleGoodsParam.getPromotionId());
        SingleGoodsBean singleGoodsBean = (SingleGoodsBean)SingleGoodsConvertor.INSTANCE.paramToBO(singleGoodsParam);
        return this.promotionRepository.modifySingleGoods(singleGoodsBean);
    }

    public Long saveGoodsRange(GoodsRangeParam goodsRangeParam) {
        this.checkBeforeModify(goodsRangeParam.getPromotionId());
        GoodsRangeQuery goodsRangeQuery = new GoodsRangeQuery();
        goodsRangeQuery.setPromotionId(goodsRangeParam.getPromotionId());
        goodsRangeQuery.setRangeCode(goodsRangeParam.getRangeCode());
        goodsRangeQuery.setStatus(StatusEnum.ENABLE.getState());
        List<GoodsRangeDTO> goodsRangeDTOList = this.promotionRepository.selectGoodsRange(goodsRangeQuery);
        if (CollectionUtils.isNotEmpty(goodsRangeDTOList)) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-0022");
        }
        GoodsRangeBean goodsRangeBean = (GoodsRangeBean)GoodsRangeConvertor.INSTANCE.paramToBO(goodsRangeParam);
        return this.promotionRepository.saveGoodsRange(goodsRangeBean);
    }

    public void incrementSaveGoodsRanges(List<GoodsRangeParam> goodsRangeParams) {
        if (CollectionUtils.isNotEmpty(goodsRangeParams)) {
            List<Object> incrementRanges;
            List<String> deleteRanges = new ArrayList<String>();
            Long promotionId = goodsRangeParams.get(0).getPromotionId();
            this.checkBeforeModify(promotionId);
            GoodsRangeQuery goodsRangeQuery = new GoodsRangeQuery();
            goodsRangeQuery.setPromotionId(promotionId);
            goodsRangeQuery.setStatus(StatusEnum.ENABLE.getState());
            List<GoodsRangeDTO> existRanges = this.promotionRepository.selectGoodsRange(goodsRangeQuery);
            if (CollectionUtils.isNotEmpty(existRanges)) {
                List newRangeCodes = goodsRangeParams.stream().map(GoodsRangeParam::getRangeCode).collect(Collectors.toList());
                List existRangeCodes = existRanges.stream().map(GoodsRangeDTO::getRangeCode).collect(Collectors.toList());
                deleteRanges = ListUtils.removeAll(existRangeCodes, newRangeCodes);
                List incrementCodes = ListUtils.removeAll(newRangeCodes, existRangeCodes);
                incrementRanges = goodsRangeParams.stream().filter(o -> incrementCodes.contains(o.getRangeCode())).collect(Collectors.toList());
            } else {
                incrementRanges = Lists.newArrayList(goodsRangeParams);
            }
            if (CollectionUtils.isNotEmpty(deleteRanges)) {
                this.promotionRepository.deletedByPromotionIdAndRangeCodes(promotionId, deleteRanges);
            }
            if (CollectionUtils.isNotEmpty((Collection)incrementRanges)) {
                this.promotionRepository.batchInsertGoodsRanges(GoodsRangeConvertor.INSTANCE.paramListToBean(incrementRanges));
            }
        }
    }

    public void batchSaveGoodsRanges(List<GoodsRangeParam> goodsRangeParams) {
        if (CollectionUtils.isNotEmpty(goodsRangeParams)) {
            List<Object> addRanges;
            Long promotionId = goodsRangeParams.get(0).getPromotionId();
            this.checkBeforeModify(promotionId);
            GoodsRangeQuery goodsRangeQuery = new GoodsRangeQuery();
            goodsRangeQuery.setPromotionId(promotionId);
            goodsRangeQuery.setStatus(StatusEnum.ENABLE.getState());
            List<GoodsRangeDTO> existRanges = this.promotionRepository.selectGoodsRange(goodsRangeQuery);
            if (CollectionUtils.isNotEmpty(existRanges)) {
                List newRangeCodes = goodsRangeParams.stream().map(GoodsRangeParam::getRangeCode).collect(Collectors.toList());
                List existRangeCodes = existRanges.stream().map(GoodsRangeDTO::getRangeCode).collect(Collectors.toList());
                List addCodes = ListUtils.removeAll(newRangeCodes, existRangeCodes);
                addRanges = goodsRangeParams.stream().filter(o -> addCodes.contains(o.getRangeCode())).collect(Collectors.toList());
            } else {
                addRanges = Lists.newArrayList(goodsRangeParams);
            }
            if (CollectionUtils.isNotEmpty((Collection)addRanges)) {
                this.promotionRepository.batchInsertGoodsRanges(GoodsRangeConvertor.INSTANCE.paramListToBean(addRanges));
            }
        }
    }

    public PageInfo<GoodsRangeDTO> pageGoodsRange(GoodsRangeQuery goodsRangeQuery) {
        return this.promotionRepository.pageGoodsRange(goodsRangeQuery);
    }

    public PageInfo<SingleGoodsDTO> pageSingleGoods(SingleGoodsQuery singleGoodsQuery) {
        return this.promotionRepository.pageSingleGoods(singleGoodsQuery);
    }

    public PromotionDTO getPromotionBasicInfo(PromotionQuery promotionQuery) {
        return this.promotionRepository.selectByPrimaryKey(promotionQuery.getId());
    }

    public SingleGoodsDetailDTO detailSingleGoodsById(SingleGoodsQuery singleGoodsQuery) {
        SingleGoodsDetailDTO singleGoodsDetailDTO;
        Long singleGoodsId = singleGoodsQuery.getId();
        if (singleGoodsId == null) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-0015");
        }
        if ((singleGoodsDetailDTO = this.promotionRepository.findSingleGoodsById(singleGoodsId)) == null) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-0016");
        }
        return singleGoodsDetailDTO;
    }

    public Integer deleteSingleGoods(SingleGoodsDeleteParam singleGoodsDeleteParam) {
        if (singleGoodsDeleteParam.getId() == null) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-0015");
        }
        this.checkBeforeModify(singleGoodsDeleteParam.getPromotionId());
        this.promotionRepository.deleteSingleGoods(singleGoodsDeleteParam);
        return 1;
    }

    public void updatePromotionWithRule(Long ruleId, String ruleName, Long promotionId) {
        NrosPreconditions.getInstance().notNull(promotionId, "NROS-SBC-PROMOTION-0002");
        this.checkBeforeModify(promotionId);
        PromotionBO promotionBO = new PromotionBO();
        promotionBO.setId(promotionId);
        promotionBO.setRuleId(ruleId);
        promotionBO.setRuleName(ruleName);
        this.promotionRepository.updatePromotion(promotionBO);
    }

    public void enablePromotion(PromotionParam promotionParam) {
        Long promotionId = promotionParam.getId();
        PromotionDTO promotionDTO = this.checkPromotionById(promotionId);
        this.checkPromotionBeforeEnable(promotionDTO);
        PromotionBO promotionBO = (PromotionBO)PromotionConvertor.INSTANCE.paramToBO(promotionParam);
        promotionBO.setPromotionState(PromotionStateEnum.ENABLE.getState());
        this.promotionRepository.updatePromotion(promotionBO);
        promotionDTO.setPromotionState(PromotionStateEnum.ENABLE.getState());
        this.promotionProducer.sendMsg(promotionDTO);
    }

    private void checkPromotionBeforeEnable(PromotionDTO promotionDTO) {
        if (!PromotionTypeEnum.SINGLE.getState().equals(promotionDTO.getPromotionType())) {
            NrosPreconditions.getInstance().notNull(promotionDTO.getRuleId(), "NROS-SBC-PROMOTION-RULE-0001");
        }
        if (PromotionTypeEnum.SINGLE.getState().equals(promotionDTO.getPromotionType())) {
            Integer singleGoodsCount = this.promotionRepository.getSingleGoodsCountByPromotionId(promotionDTO.getId());
            NrosPreconditions.getInstance().hasPositiveNumber(singleGoodsCount, "NROS-SBC-PROMOTION-0024");
        } else if (PromotionTypeEnum.ORDER.getState().equals(promotionDTO.getPromotionType()) && !GoodsRangeTypeEnum.ALL_GOODS.getState().equals(promotionDTO.getGoodsRangeType())) {
            Integer goodsRangeCount = this.promotionRepository.getGoodsRangeCountByPromotionId(promotionDTO.getId());
            NrosPreconditions.getInstance().hasPositiveNumber(goodsRangeCount, "NROS-SBC-PROMOTION-0025");
        }
    }

    public void disablePromotion(PromotionParam promotionParam) {
        Long promotionId = promotionParam.getId();
        PromotionDTO promotionDTO = this.checkPromotionById(promotionId);
        if (PromotionStateEnum.IN_DESIGN.getState().equals(promotionDTO.getPromotionState())) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-0019");
        }
        PromotionBO promotionBO = (PromotionBO)PromotionConvertor.INSTANCE.paramToBO(promotionParam);
        promotionBO.setPromotionState(PromotionStateEnum.DISABLE.getState());
        this.promotionRepository.updatePromotion(promotionBO);
        promotionDTO.setPromotionState(PromotionStateEnum.DISABLE.getState());
        this.promotionProducer.sendMsg(promotionDTO);
    }

    public PromotionDTO checkPromotionById(Long promotionId) {
        PromotionDTO promotionDTO;
        if (promotionId == null) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-0002");
        }
        if ((promotionDTO = this.promotionRepository.selectByPrimaryKey(promotionId)) == null) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-0003");
        }
        return promotionDTO;
    }

    public List<PromotionDTO> listPromotion(PromotionQuery promotionQuery) {
        return this.promotionRepository.listPromotion(promotionQuery);
    }

    public Integer deleteGoodsRange(GoodsRangeDeleteParam goodsRangeDeleteParam) {
        this.checkBeforeModify(goodsRangeDeleteParam.getPromotionId());
        if (goodsRangeDeleteParam.getId() == null) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-0023");
        }
        this.promotionRepository.deleteSingleGoods(goodsRangeDeleteParam);
        return 1;
    }

    public Integer getPromotionCountByRuleId(Long ruleId) {
        return this.promotionRepository.getPromotionCountByRuleId(ruleId);
    }

    public Integer getSingleGoodsCountByRuleId(Long ruleId) {
        return this.promotionRepository.getSingleGoodsCountByRuleId(ruleId);
    }

    public void saveGoodsRangeType(PromotionParam promotionParam) {
        PromotionDTO promotionDTO = this.checkBeforeModify(promotionParam.getId());
        NrosPreconditions.getInstance().hasText(promotionParam.getGoodsRangeType(), "NROS-SBC-PROMOTION-0026");
        if (PromotionTypeEnum.ORDER.getState().equals(promotionDTO.getPromotionType())) {
            Integer goodsRangeCount = this.getGoodsRangeCountByPromotionId(promotionDTO.getId());
            if (goodsRangeCount != null && goodsRangeCount > 0) {
                ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-0026");
            }
        } else {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-0005");
        }
        PromotionBO promotionBO = (PromotionBO)PromotionConvertor.INSTANCE.paramToBO(promotionParam);
        this.promotionRepository.saveGoodsRangeType(promotionBO);
    }

    public Integer getSingleGoodsCountByPromotionId(Long promotionId) {
        return this.promotionRepository.getSingleGoodsCountByPromotionId(promotionId);
    }

    public Integer getGoodsRangeCountByPromotionId(Long promotionId) {
        return this.promotionRepository.getGoodsRangeCountByPromotionId(promotionId);
    }

    public List<PromotionBO> getPromotionList() {
        Object promotionObjectList = this.cacheUtils.get("PMS_PROMOTION_CACHE_KEY");
        List promotionList = promotionObjectList == null ? this.refreshPromotionCache() : (List)promotionObjectList;
        return promotionList;
    }

    public AllGoodsDTO listAllGoods(PromotionQuery promotionQuery) {
        return this.promotionRepository.listAllGoods(promotionQuery);
    }

    private PromotionDTO checkBeforeModify(Long promotionId) {
        PromotionDTO promotionDTO;
        if (promotionId == null) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-0002");
        }
        if ((promotionDTO = this.promotionRepository.selectByPrimaryKey(promotionId)) == null) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-0003");
        }
        if (!PromotionStateEnum.IN_DESIGN.getState().equals(promotionDTO.getPromotionState())) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-0006");
        }
        return promotionDTO;
    }

    private void checkBeforeDelete(Long promotionId) {
        if (promotionId == null) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-0002");
        }
        PromotionQuery promotionQuery = new PromotionQuery();
        promotionQuery.setId(promotionId);
        PromotionDTO promotionDTO = this.promotionRepository.selectByPrimaryKey(promotionId);
        if (PromotionStateEnum.ENABLE.getState().equals(promotionDTO.getPromotionState())) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-0007");
        }
    }

    public void clearPromotionCache() {
        this.cacheUtils.remove("PMS_PROMOTION_CACHE_KEY");
    }

    public List<PromotionBO> refreshPromotionCache() {
        List<PromotionBO> promotionList = new ArrayList<PromotionBO>();
        List<PromotionDTO> promotionDTOList = this.promotionRepository.listAll();
        if (!CollectionUtils.isEmpty(promotionDTOList)) {
            promotionList = PromotionConvertor.INSTANCE.dtoListToBO(promotionDTOList);
            this.cacheUtils.set("PMS_PROMOTION_CACHE_KEY", promotionList);
        }
        return promotionList;
    }

    public int disableExpiredPromotion() {
        return this.promotionRepository.disableExpiredPromotion();
    }
}

