/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.promotion.server.domain.coupon;

import com.alibaba.ans.shaded.com.google.common.collect.Lists;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.ztesoft.zsmart.nros.base.annotation.DistributedLock;
import com.ztesoft.zsmart.nros.base.exception.BusiException;
import com.ztesoft.zsmart.nros.base.exception.ExceptionHandler;
import com.ztesoft.zsmart.nros.base.util.DateUtil;
import com.ztesoft.zsmart.nros.base.util.SnowflakeIdWorker;
import com.ztesoft.zsmart.nros.base.util.paas.CacheUtils;
import com.ztesoft.zsmart.nros.base.zmq.entity.NrosMQMessage;
import com.ztesoft.zsmart.nros.base.zmq.producer.DefaultZMQProducer;
import com.ztesoft.zsmart.nros.common.model.enums.StatusEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.ConditionDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.CouponCodeStatusDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.CouponDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.CouponGoodsRangeDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.CouponInstanceDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.CouponReceiveRecordsDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.CouponReservedAndCheckedDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.RuleDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.CancelReceiveCouponParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.ConditionParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.CouponBatchSendParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.CouponConsumeParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.CouponDeleteParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.CouponGoodsRangeDeleteParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.CouponGoodsRangeParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.CouponSaveParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.DiscountParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.GiftParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.InvalidCouponParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.MemberIdNameParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.PurchaseParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.ReceiveCouponParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.param.RuleSaveParam;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.CouponCodeQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.CouponGoodsRangeQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.CouponInstanceQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.CouponQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.query.CouponReceiveListQuery;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.CouponDeleteConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.CouponGoodsRangeConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.CouponReceiveRecordsConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.convertor.CouponSaveConvertor;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.CouponInstanceStatusEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.CouponReceiveTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.CouponStatusEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.CouponTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.DiscountTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.GoodsRangeTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.OperActionEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.OperTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.ValidTimeTypeEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.enums.YesOrNoEnum;
import com.ztesoft.zsmart.nros.sbc.promotion.server.common.util.NrosPreconditions;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.coupon.model.CouponBO;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.coupon.model.CouponGoodsRangeBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.domain.coupon.model.CouponReceiveRecordsBean;
import com.ztesoft.zsmart.nros.sbc.promotion.server.repository.CouponRepository;
import com.ztesoft.zsmart.nros.sbc.promotion.server.repository.OperLogRepository;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CouponDomain {
    private static final Logger logger = LoggerFactory.getLogger(CouponDomain.class);
    @Autowired
    private CouponRepository couponRepository;
    @Autowired
    private DefaultZMQProducer defaultZMQProducer;
    @Autowired
    private CacheUtils cacheUtils;
    @Autowired
    private OperLogRepository operLogRepository;
    @Value(value="${zmq.produce.event.topic}")
    private String topic;

    public String addCoupon(CouponSaveParam couponSaveParam) {
        String couponType;
        if (StringUtils.isBlank((CharSequence)couponSaveParam.getCouponName())) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0001");
        }
        if (StringUtils.isBlank((CharSequence)(couponType = couponSaveParam.getCouponType()))) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0002");
        }
        if ((null == couponSaveParam.getQuantity() || couponSaveParam.getQuantity() <= 0) && YesOrNoEnum.YES.getValue().equals(couponSaveParam.getIsLimitQuantity())) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0003");
        }
        if (null == couponSaveParam.getGetLimit() || couponSaveParam.getGetLimit() <= 0) {
            ExceptionHandler.publish((String)"NROS-SBCPROMOTION-COUPON-0004");
        }
        CouponBO couponBO = (CouponBO)CouponSaveConvertor.INSTANCE.paramToBO(couponSaveParam);
        if (CouponTypeEnum.DISCOUNT.getState().equals(couponType)) {
            couponBO.setCouponCode(SnowflakeIdWorker.getIdWithPrefix((String)"DD"));
        } else if (CouponTypeEnum.REDUCE.getState().equals(couponType)) {
            couponBO.setCouponCode(SnowflakeIdWorker.getIdWithPrefix((String)"DR"));
        } else if (CouponTypeEnum.GIFT.getState().equals(couponType)) {
            couponBO.setCouponCode(SnowflakeIdWorker.getIdWithPrefix((String)"DG"));
        } else if (CouponTypeEnum.PURCHASE.getState().equals(couponType)) {
            couponBO.setCouponCode(SnowflakeIdWorker.getIdWithPrefix((String)"DP"));
        } else if (CouponTypeEnum.FREIGHT.getState().equals(couponType)) {
            couponBO.setCouponCode(SnowflakeIdWorker.getIdWithPrefix((String)"DF"));
        }
        couponBO.setCouponStatus(CouponStatusEnum.DESIGNING.getState());
        return this.couponRepository.addCoupon(couponBO);
    }

    public void saveGoodsRangeType(CouponSaveParam couponSaveParam) {
        CouponDTO couponDTO = this.checkBeforeModify(couponSaveParam.getCouponCode());
        NrosPreconditions.getInstance().hasText(couponSaveParam.getGoodsRangeLimitType(), "NROS-SBC-PROMOTION-COUPON-0035");
        if (!CouponTypeEnum.FREIGHT.getState().equals(couponDTO.getCouponType())) {
            List<CouponGoodsRangeDTO> couponGoodsRangeDTOList = this.couponRepository.listCouponGoodsRangeByCouponCode(couponSaveParam.getCouponCode());
            if (CollectionUtils.isNotEmpty(couponGoodsRangeDTOList)) {
                ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0035");
            }
        } else {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0002");
        }
        CouponBO couponBO = new CouponBO();
        couponBO.setId(couponDTO.getId());
        couponBO.setCouponCode(couponSaveParam.getCouponCode());
        couponBO.setGoodsRangeLimitType(couponSaveParam.getGoodsRangeLimitType());
        this.couponRepository.modifyCoupon(couponBO);
    }

    public Long saveCouponGoodsRange(CouponGoodsRangeParam couponGoodsRangeParam) {
        this.checkBeforeModify(couponGoodsRangeParam.getCouponCode());
        CouponGoodsRangeQuery couponGoodsRangeQuery = new CouponGoodsRangeQuery();
        couponGoodsRangeQuery.setCouponCode(couponGoodsRangeParam.getCouponCode());
        couponGoodsRangeQuery.setRangeCode(couponGoodsRangeParam.getRangeCode());
        couponGoodsRangeQuery.setStatus(StatusEnum.ENABLE.getState());
        List<CouponGoodsRangeDTO> couponGoodsRangeDTOList = this.couponRepository.listCouponGoodsRange(couponGoodsRangeQuery);
        if (CollectionUtils.isNotEmpty(couponGoodsRangeDTOList)) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-0022");
        }
        CouponGoodsRangeBean couponGoodsRangeBean = (CouponGoodsRangeBean)CouponGoodsRangeConvertor.INSTANCE.paramToBO(couponGoodsRangeParam);
        this.couponRepository.saveCouponGoodsRange(couponGoodsRangeBean);
        return 1L;
    }

    public void incrementSaveGoodsRanges(List<CouponGoodsRangeParam> goodsRangeParams) {
        if (CollectionUtils.isNotEmpty(goodsRangeParams)) {
            List<Object> incrementRanges;
            List<String> deleteRanges = new ArrayList<String>();
            String couponCode = goodsRangeParams.get(0).getCouponCode();
            this.checkBeforeModify(couponCode);
            CouponGoodsRangeQuery couponGoodsRangeQuery = new CouponGoodsRangeQuery();
            couponGoodsRangeQuery.setCouponCode(couponCode);
            couponGoodsRangeQuery.setStatus(StatusEnum.ENABLE.getState());
            List<CouponGoodsRangeDTO> existRanges = this.couponRepository.listCouponGoodsRange(couponGoodsRangeQuery);
            if (CollectionUtils.isNotEmpty(existRanges)) {
                List newRangeCodes = goodsRangeParams.stream().map(CouponGoodsRangeParam::getRangeCode).collect(Collectors.toList());
                List existRangeCodes = existRanges.stream().map(CouponGoodsRangeDTO::getRangeCode).collect(Collectors.toList());
                deleteRanges = ListUtils.removeAll(existRangeCodes, newRangeCodes);
                List incrementCodes = ListUtils.removeAll(newRangeCodes, existRangeCodes);
                incrementRanges = goodsRangeParams.stream().filter(o -> incrementCodes.contains(o.getRangeCode())).collect(Collectors.toList());
            } else {
                incrementRanges = Lists.newArrayList(goodsRangeParams);
            }
            if (CollectionUtils.isNotEmpty(deleteRanges)) {
                this.couponRepository.deletedByCouponCodeAndRangeCodes(couponCode, deleteRanges);
            }
            if (CollectionUtils.isNotEmpty((Collection)incrementRanges)) {
                this.couponRepository.batchInsertGoodsRanges(CouponGoodsRangeConvertor.INSTANCE.paramListToBeanList(incrementRanges));
            }
        }
    }

    public void batchSaveGoodsRanges(List<CouponGoodsRangeParam> goodsRangeParams) {
        if (CollectionUtils.isNotEmpty(goodsRangeParams)) {
            List<Object> addRanges;
            String couponCode = goodsRangeParams.get(0).getCouponCode();
            this.checkBeforeModify(couponCode);
            CouponGoodsRangeQuery couponGoodsRangeQuery = new CouponGoodsRangeQuery();
            couponGoodsRangeQuery.setCouponCode(couponCode);
            couponGoodsRangeQuery.setStatus(StatusEnum.ENABLE.getState());
            List<CouponGoodsRangeDTO> existRanges = this.couponRepository.listCouponGoodsRange(couponGoodsRangeQuery);
            if (CollectionUtils.isNotEmpty(existRanges)) {
                List newRangeCodes = goodsRangeParams.stream().map(CouponGoodsRangeParam::getRangeCode).collect(Collectors.toList());
                List existRangeCodes = existRanges.stream().map(CouponGoodsRangeDTO::getRangeCode).collect(Collectors.toList());
                List addCodes = ListUtils.removeAll(newRangeCodes, existRangeCodes);
                addRanges = goodsRangeParams.stream().filter(o -> addCodes.contains(o.getRangeCode())).collect(Collectors.toList());
            } else {
                addRanges = Lists.newArrayList(goodsRangeParams);
            }
            if (CollectionUtils.isNotEmpty((Collection)addRanges)) {
                this.couponRepository.batchInsertGoodsRanges(CouponGoodsRangeConvertor.INSTANCE.paramListToBeanList(addRanges));
            }
        }
    }

    public List<CouponGoodsRangeDTO> listCouponGoodsRangeByCouponCode(String couponCode) {
        List<CouponGoodsRangeDTO> couponGoodsRangeDTOS = this.couponRepository.listCouponGoodsRangeByCouponCode(couponCode);
        return couponGoodsRangeDTOS;
    }

    public void saveCouponRuleRelationship(Long ruleId, String ruleName, String couponCode, Long couponAmt) {
        this.checkBeforeModify(couponCode);
        NrosPreconditions.getInstance().notNull(ruleId, "NROS-SBC-PROMOTION-RULE-0001");
        this.couponRepository.saveCouponRuleRelationship(couponCode, ruleId, ruleName, couponAmt);
    }

    public void modifyCoupon(CouponSaveParam couponSaveParam) {
        CouponDTO couponDTO = this.checkBeforeModify(couponSaveParam.getCouponCode());
        if (StringUtils.isBlank((CharSequence)couponSaveParam.getCouponName())) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0001");
        }
        if (!StringUtils.equals((CharSequence)couponSaveParam.getCouponType(), (CharSequence)couponDTO.getCouponType())) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0034");
        }
        CouponBO couponBO = (CouponBO)CouponSaveConvertor.INSTANCE.paramToBO(couponSaveParam);
        couponBO.setId(couponDTO.getId());
        this.couponRepository.modifyCoupon(couponBO);
    }

    public CouponDTO findByCouponCode(String couponCode) {
        return this.couponRepository.selectCouponByCode(couponCode);
    }

    public PageInfo<CouponDTO> listAllCoupon(CouponQuery couponQuery) {
        return this.couponRepository.pageCoupon(couponQuery);
    }

    public CouponDTO details(String couponCode) {
        CouponDTO couponDTO = this.couponRepository.selectCouponByCode(couponCode);
        if (null == couponDTO) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0009");
        }
        Long receivedNumber = couponDTO.getReceivedCount() == null ? 0L : couponDTO.getReceivedCount().longValue();
        if (YesOrNoEnum.YES.getValue().equals(couponDTO.getIsLimitQuantity())) {
            Long unreceivedNumber = (long)couponDTO.getQuantity().intValue() - receivedNumber;
            couponDTO.setUnreceivedNumber(unreceivedNumber);
        }
        Long usedNumber = this.couponRepository.countCouponReceiveRecordsUsedByCouponCode(couponCode);
        Long unusedNumber = receivedNumber - usedNumber;
        couponDTO.setReceivedNumber(receivedNumber);
        couponDTO.setUsedNumber(usedNumber);
        couponDTO.setUnusedNumber(unusedNumber);
        List<CouponGoodsRangeDTO> couponGoodsRangeDTOS = this.couponRepository.listCouponGoodsRangeByCouponCode(couponCode);
        couponDTO.setCouponGoodsRangeList(couponGoodsRangeDTOS);
        return couponDTO;
    }

    public List<CouponReceiveRecordsDTO> receiveCoupon(ReceiveCouponParam receiveCouponParam) {
        List couponCodeList = receiveCouponParam.getCouponCodeList();
        if (CollectionUtils.isEmpty((Collection)couponCodeList)) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0008");
        }
        Long memberId = receiveCouponParam.getMemberId();
        String memberName = receiveCouponParam.getMemberName();
        Date nowTime = new Date();
        ArrayList<CouponReceiveRecordsDTO> list = new ArrayList<CouponReceiveRecordsDTO>();
        for (String couponCode : couponCodeList) {
            try {
                CouponDTO couponDTO = this.checkAndReduceReceivedCount(couponCode, memberId, 1);
                CouponReceiveRecordsDTO couponReceiveRecordsDTO = this.addCouponReceiveRecords(couponDTO, memberId, memberName, nowTime, CouponReceiveTypeEnum.SELF_HELP.getType(), receiveCouponParam.getReceiveChannel(), receiveCouponParam.getActiveCode(), null, null);
                list.add(couponReceiveRecordsDTO);
                this.sendEventTraceMessage("E0002", memberId, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(nowTime), couponCode, couponDTO.getCouponName(), receiveCouponParam.getActiveCode(), null);
            }
            catch (BusiException e) {
                logger.error("activeCdoe:{},memberId:{} receive coupon:{} fail, errCode:{}, errMsg:{}", new Object[]{receiveCouponParam.getActiveCode(), memberId, couponCode, e.getErrorCode(), e.getErrorMsg()});
            }
        }
        return list;
    }

    public PageInfo<CouponReceiveRecordsDTO> pageReceive(CouponReceiveListQuery couponReceiveListQuery) {
        return this.couponRepository.pageReceiveRecords(couponReceiveListQuery);
    }

    public void cancelReceiveCoupon(CancelReceiveCouponParam cancelReceiveCouponParam) {
        List instanceCodeList = cancelReceiveCouponParam.getInstanceCodeList();
        for (String instanceCode : instanceCodeList) {
            CouponReceiveRecordsDTO couponReceiveRecordsDTO = this.couponRepository.selectByInstanceCode(instanceCode);
            if (null == couponReceiveRecordsDTO) {
                ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0013");
                continue;
            }
            CouponReceiveRecordsBean couponReceiveRecords = new CouponReceiveRecordsBean();
            couponReceiveRecords.setId(couponReceiveRecordsDTO.getId());
            couponReceiveRecords.setStatus(StatusEnum.DISABLE.getState());
            this.couponRepository.modifyCouponReceiveRecords(couponReceiveRecords);
            this.operLogRepository.sendOperLogMsg(OperTypeEnum.COUPON_INSTANCE.getState(), OperActionEnum.CANCEL_RECEIVE.getState(), instanceCode, null, com.alibaba.fastjson.JSONObject.parseObject((String)JSON.toJSONString((Object)couponReceiveRecordsDTO)), null, null);
        }
    }

    public void activateCoupon(String couponCode, RuleDTO ruleDTO) {
        List conditionList;
        List<CouponGoodsRangeDTO> couponGoodsRangeDTOS;
        CouponDTO couponDTO = this.couponRepository.selectCouponByCode(couponCode);
        if (null == couponDTO) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0009");
        }
        if (!StringUtils.equals((CharSequence)CouponStatusEnum.DESIGNING.getState(), (CharSequence)couponDTO.getCouponStatus())) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0033");
        }
        if (!GoodsRangeTypeEnum.ALL_GOODS.getState().equals(couponDTO.getGoodsRangeLimitType()) && CollectionUtils.isEmpty(couponGoodsRangeDTOS = this.couponRepository.listCouponGoodsRangeByCouponCode(couponCode))) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0032");
        }
        if (null == ruleDTO) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0027");
        }
        if (CollectionUtils.isEmpty((Collection)(conditionList = ruleDTO.getRuleConditions()))) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0028");
        }
        ConditionDTO conditionDTO = (ConditionDTO)conditionList.get(0);
        String discountType = ruleDTO.getDiscountType();
        if (CouponTypeEnum.DISCOUNT.getState().equals(discountType) || CouponTypeEnum.REDUCE.getState().equals(discountType) || CouponTypeEnum.FREIGHT.getState().equals(discountType)) {
            if (conditionDTO.getDiscount() == null) {
                ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0029");
            }
        } else if (CouponTypeEnum.GIFT.getState().equals(discountType)) {
            if (CollectionUtils.isEmpty((Collection)conditionDTO.getGiftList())) {
                ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0030");
            }
        } else if (CouponTypeEnum.PURCHASE.getState().equals(discountType) && CollectionUtils.isEmpty((Collection)conditionDTO.getPurchaseList())) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0031");
        }
        CouponBO coupon = new CouponBO();
        coupon.setId(couponDTO.getId());
        coupon.setCouponStatus(CouponStatusEnum.ACTIVATED.getState());
        this.couponRepository.modifyCoupon(coupon);
    }

    public void invalidCoupon(InvalidCouponParam invalidCouponParam) {
        String couponCode = invalidCouponParam.getCouponCode();
        CouponDTO couponDTO = this.couponRepository.selectCouponByCode(couponCode);
        if (null == couponDTO) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0009");
        } else {
            CouponBO coupon = new CouponBO();
            coupon.setId(couponDTO.getId());
            coupon.setCouponStatus(CouponStatusEnum.INVALID.getState());
            coupon.setInvalidRemark(invalidCouponParam.getInvalidRemark());
            this.couponRepository.modifyCoupon(coupon);
        }
    }

    public CouponCodeStatusDTO getCouponCodeByInstanceCode(String instanceCode) {
        CouponReceiveRecordsDTO couponInstance = this.couponRepository.selectByInstanceCode(instanceCode);
        if (null == couponInstance) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0013");
        }
        String couponCode = couponInstance.getCouponCode();
        CouponDTO coupon = this.couponRepository.selectCouponByCode(couponCode);
        CouponCodeStatusDTO couponInstanceDTO = new CouponCodeStatusDTO();
        if (null == coupon) {
            couponInstanceDTO.setStatus(CouponInstanceStatusEnum.INVALID.getState());
        } else {
            Date nowTime = new Date();
            String status = this.getCouponInstanceStatus(couponInstance.getIsUse(), couponInstance.getIsLock(), couponInstance.getUseEndTime(), couponInstance.getUseStartTime(), nowTime);
            couponInstanceDTO.setStatus(status);
        }
        couponInstanceDTO.setInstanceId(couponInstance.getId());
        couponInstanceDTO.setCouponCode(couponCode);
        couponInstanceDTO.setCouponName(coupon.getCouponName());
        couponInstanceDTO.setUseTime(couponInstance.getUseTime());
        couponInstanceDTO.setResult(1);
        couponInstanceDTO.setMemberId(couponInstance.getMemberId());
        couponInstanceDTO.setUseStartTime(couponInstance.getUseStartTime());
        couponInstanceDTO.setUseEndTime(couponInstance.getUseEndTime());
        return couponInstanceDTO;
    }

    @DistributedLock(value="NROS-SBC-PROMOTION-COUPON-0016", key="#instanceCode", lockName="")
    public void lockCouponInstance(String instanceCode, int action) {
        CouponDTO couponDTO;
        CouponReceiveRecordsDTO instance = this.couponRepository.selectByInstanceCode(instanceCode);
        if (null == instance) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0013");
        }
        if ((couponDTO = this.couponRepository.selectCouponByCode(instance.getCouponCode())) == null || !CouponStatusEnum.ACTIVATED.getState().equals(couponDTO.getCouponStatus())) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0019");
        }
        String isLock = instance.getIsLock();
        if (action == 0 && YesOrNoEnum.NO.getValue().equals(isLock) || action == 1 && YesOrNoEnum.YES.getValue().equals(isLock)) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0015");
        }
        if (YesOrNoEnum.YES.getValue().equals(instance.getIsUse())) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0016");
        }
        CouponReceiveRecordsBean couponReceiveRecords = new CouponReceiveRecordsBean();
        String logAction = "";
        if (action == 0) {
            couponReceiveRecords.setIsLock(YesOrNoEnum.NO.getValue());
            logAction = OperActionEnum.UNLOCK.getState();
        } else if (action == 1) {
            String instanceStatus = this.getCouponInstanceStatus(instance.getIsUse(), instance.getIsLock(), instance.getUseEndTime(), instance.getUseStartTime(), DateUtil.getNow());
            if (!CouponInstanceStatusEnum.VALID.getState().equals(instanceStatus)) {
                ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0016");
            }
            couponReceiveRecords.setIsLock(YesOrNoEnum.YES.getValue());
            logAction = OperActionEnum.LOCK.getState();
        } else {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0017");
        }
        couponReceiveRecords.setId(instance.getId());
        this.couponRepository.modifyCouponReceiveRecords(couponReceiveRecords);
        this.operLogRepository.sendOperLogMsg(OperTypeEnum.COUPON_INSTANCE.getState(), logAction, instanceCode, null, com.alibaba.fastjson.JSONObject.parseObject((String)JSON.toJSONString((Object)instance)), null, null);
    }

    public String consumeCouponInstance(CouponConsumeParam consumeParam) {
        CouponReceiveRecordsDTO couponInstance = this.couponRepository.selectByInstanceCode(consumeParam.getInstanceCode());
        CouponCodeStatusDTO couponCodeStatus = this.getCouponCodeByInstanceCode(consumeParam.getInstanceCode());
        String status = couponCodeStatus.getStatus();
        if (CouponInstanceStatusEnum.LOCKED.getState().equals(status)) {
            Date nowTime = new Date();
            if (nowTime.compareTo(couponCodeStatus.getUseEndTime()) > 0 || nowTime.compareTo(couponCodeStatus.getUseStartTime()) < 0) {
                ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0019");
            }
            String orderCode = consumeParam.getOrderCode();
            CouponReceiveRecordsBean updateCouponInstance = new CouponReceiveRecordsBean();
            updateCouponInstance.setId(couponCodeStatus.getInstanceId());
            updateCouponInstance.setIsUse(YesOrNoEnum.YES.getValue());
            updateCouponInstance.setIsLock(CouponInstanceStatusEnum.VALID.getState());
            updateCouponInstance.setUseTime(nowTime);
            updateCouponInstance.setOrderCode(orderCode);
            updateCouponInstance.setExternalOrderNum(consumeParam.getExternalOrderNum());
            updateCouponInstance.setConsumeChannel(consumeParam.getConsumeChannel());
            updateCouponInstance.setMemberId(couponCodeStatus.getMemberId());
            updateCouponInstance.setExtInfo(consumeParam.getExtInfo());
            updateCouponInstance.setUseStoreCode(consumeParam.getUseStoreCode());
            updateCouponInstance.setStoreName(consumeParam.getStoreName());
            updateCouponInstance.setSendUserId(consumeParam.getSendUserId());
            updateCouponInstance.setSendUserName(consumeParam.getSendUserName());
            updateCouponInstance.setConsumeUserId(consumeParam.getConsumeUserId());
            updateCouponInstance.setVerifyCode(consumeParam.getVerifyCode());
            this.couponRepository.modifyCouponReceiveRecords(updateCouponInstance);
            this.operLogRepository.sendOperLogMsg(OperTypeEnum.COUPON_INSTANCE.getState(), OperActionEnum.CHECK.getState(), consumeParam.getInstanceCode(), null, com.alibaba.fastjson.JSONObject.parseObject((String)JSON.toJSONString((Object)couponInstance)), null, null);
            this.sendEventTraceMessage("E0001", updateCouponInstance.getMemberId(), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()), couponCodeStatus.getCouponCode(), couponCodeStatus.getCouponName(), null, orderCode == null ? consumeParam.getExternalOrderNum() : orderCode);
        } else if (CouponInstanceStatusEnum.INVALID.getState().equals(status)) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0019");
        } else if (CouponInstanceStatusEnum.USED.getState().equals(status)) {
            String useTime = DateUtil.dateToStr((Date)couponCodeStatus.getUseTime(), (String)"yyyy-MM-dd HH:mm:ss");
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0018", null, (String[])new String[]{useTime});
        } else if (CouponInstanceStatusEnum.VALID.getState().equals(status)) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0036");
        } else if (CouponInstanceStatusEnum.NOT_FORCE.getState().equals(status)) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0037");
        }
        return couponCodeStatus.getCouponCode();
    }

    public String cancelConsumeCouponInstance(String instanceCode) {
        CouponReceiveRecordsDTO instanceDTO = this.couponRepository.selectByInstanceCode(instanceCode);
        if (null == instanceDTO) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0013");
        }
        if (YesOrNoEnum.NO.getValue().equals(instanceDTO.getIsUse())) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0022");
        }
        CouponReceiveRecordsBean recordsBean = CouponReceiveRecordsConvertor.INSTANCE.dtoToBean(instanceDTO);
        recordsBean.setIsUse(YesOrNoEnum.NO.getValue());
        recordsBean.setUseTime(null);
        recordsBean.setUseStoreCode(null);
        recordsBean.setStoreName(null);
        recordsBean.setOrderCode(null);
        recordsBean.setStoreName(null);
        recordsBean.setSendUserId(null);
        recordsBean.setSendUserName(null);
        recordsBean.setConsumeUserId(null);
        recordsBean.setVerifyCode(null);
        this.couponRepository.updateReceiveRecordsById(recordsBean);
        this.operLogRepository.sendOperLogMsg(OperTypeEnum.COUPON_INSTANCE.getState(), OperActionEnum.CANCEL_CHECK.getState(), instanceDTO.getInstanceCode(), null, com.alibaba.fastjson.JSONObject.parseObject((String)JSON.toJSONString((Object)instanceDTO)), null, null);
        return instanceDTO.getCouponCode();
    }

    public List<CouponDTO> listCouponByCodeList(CouponCodeQuery couponCodeQuery) {
        if (null == couponCodeQuery || null == couponCodeQuery.getCouponCodeList()) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0026");
        }
        return this.couponRepository.listCouponByCodeList(couponCodeQuery.getCouponCodeList());
    }

    public List<CouponReceiveRecordsDTO> batchSend(CouponBatchSendParam couponBatchSendParam) {
        String couponCode = couponBatchSendParam.getCouponCode();
        if (StringUtils.isEmpty((CharSequence)couponCode)) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0008");
        }
        Date nowTime = new Date();
        List memberIdNameList = couponBatchSendParam.getMemberIdNameList();
        ArrayList<CouponReceiveRecordsDTO> list = new ArrayList<CouponReceiveRecordsDTO>();
        for (MemberIdNameParam memberIdNameParam : memberIdNameList) {
            CouponReceiveRecordsDTO couponReceiveRecordsDTO;
            Long memberId = memberIdNameParam.getMemberId();
            String memberName = memberIdNameParam.getMemberName();
            try {
                CouponDTO couponDTO = this.checkAndReduceReceivedCount(couponCode, memberId, 1);
                couponReceiveRecordsDTO = this.addCouponReceiveRecords(couponDTO, memberId, memberName, nowTime, couponBatchSendParam.getReceiveType(), couponBatchSendParam.getReceiveChannel(), couponBatchSendParam.getActiveCode(), couponBatchSendParam.getActiveInstanceCode(), couponBatchSendParam.getActiveNodeCode());
                couponReceiveRecordsDTO.setSendSuccess(YesOrNoEnum.YES.getValue());
                list.add(couponReceiveRecordsDTO);
                if (StringUtils.equals((CharSequence)couponDTO.getCouponType(), (CharSequence)CouponTypeEnum.GIFT.getState())) {
                    CouponReceiveRecordsBean couponReceiveRecords = new CouponReceiveRecordsBean();
                    couponReceiveRecords.setId(couponReceiveRecordsDTO.getId());
                    couponReceiveRecords.setIsLock(YesOrNoEnum.YES.getValue());
                    this.couponRepository.modifyCouponReceiveRecords(couponReceiveRecords);
                }
                this.sendEventTraceMessage("E0002", memberId, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(nowTime), couponCode, couponDTO.getCouponName(), couponBatchSendParam.getActiveCode(), null);
            }
            catch (BusiException e) {
                logger.error("activeCode:{},memberId:{} receive coupon:{} fail, errCode:{}, errMsg:{}", new Object[]{couponBatchSendParam.getActiveCode(), memberId, couponCode, e.getErrorCode(), e.getErrorMsg()});
                couponReceiveRecordsDTO = new CouponReceiveRecordsDTO();
                couponReceiveRecordsDTO.setActiveCode(couponBatchSendParam.getActiveCode());
                couponReceiveRecordsDTO.setCouponCode(couponCode);
                couponReceiveRecordsDTO.setMemberId(memberId);
                couponReceiveRecordsDTO.setSendSuccess(YesOrNoEnum.NO.getValue());
                couponReceiveRecordsDTO.setErrorCode(e.getErrorCode());
                couponReceiveRecordsDTO.setErrorMsg(e.getErrorMsg());
                list.add(couponReceiveRecordsDTO);
            }
        }
        return list;
    }

    public PageInfo<CouponInstanceDTO> pageCouponInstance(CouponInstanceQuery couponMemberIdQuery) {
        PageInfo<CouponInstanceDTO> couponInstanceDTOPageInfo = this.couponRepository.pageCouponInstance(couponMemberIdQuery);
        List list = couponInstanceDTOPageInfo.getList();
        Date nowTime = new Date();
        list.forEach(dto -> {
            String instanceStatus = this.getCouponInstanceStatusByCouponStatus(dto.getIsUse(), dto.getIsLock(), dto.getUseEndTime(), dto.getUseStartTime(), nowTime, dto.getCouponStatus());
            dto.setInstanceStatus(instanceStatus);
        });
        return couponInstanceDTOPageInfo;
    }

    public CouponInstanceDTO selectCouponInstanceByInstanceCode(String instanceCode) {
        CouponInstanceDTO dto = this.couponRepository.selectCouponInstanceByInstanceCode(instanceCode);
        if (null == dto) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0038");
        }
        Date nowTime = new Date();
        String instanceStatus = this.getCouponInstanceStatus(dto.getIsUse(), dto.getIsLock(), dto.getUseEndTime(), dto.getUseStartTime(), nowTime);
        dto.setInstanceStatus(instanceStatus);
        dto.setCouponGoodsRangeList(this.couponRepository.listCouponGoodsRangeByCouponCode(dto.getCouponCode()));
        return dto;
    }

    public Integer getCouponCountByRuleId(Long ruleId) {
        return this.couponRepository.getCouponCountByRuleId(ruleId);
    }

    public Integer deleteCouponGoodsRange(CouponGoodsRangeDeleteParam couponGoodsRangeDeleteParam) {
        this.checkBeforeModify(couponGoodsRangeDeleteParam.getCouponCode());
        this.couponRepository.deleteCouponGoodsRange(couponGoodsRangeDeleteParam);
        return 1;
    }

    public List<CouponBO> getCouponList() {
        Object couponObjectList = this.cacheUtils.get("PMS_COUPON_CACHE_KEY");
        List couponList = couponObjectList == null ? this.refreshCouponCache() : (List)couponObjectList;
        return couponList;
    }

    public List<CouponReceiveRecordsBean> listCouponReceiveRecordsByMemberId(Long memberId, String isUse) {
        List<CouponReceiveRecordsDTO> couponReceiveRecordsDTOList = this.couponRepository.listCouponReceiveRecordsByMemberId(memberId, isUse);
        return CouponReceiveRecordsConvertor.INSTANCE.dtoListToBean(couponReceiveRecordsDTOList);
    }

    public void clearCouponCache() {
        this.cacheUtils.remove("PMS_COUPON_CACHE_KEY");
    }

    public List<CouponBO> refreshCouponCache() {
        List<CouponBO> couponList = new ArrayList<CouponBO>();
        List<CouponDTO> couponDTOList = this.couponRepository.listAll();
        if (CollectionUtils.isNotEmpty(couponDTOList)) {
            couponList = CouponSaveConvertor.INSTANCE.dtoListToBO(couponDTOList);
            this.cacheUtils.set("PMS_COUPON_CACHE_KEY", couponList);
        }
        return couponList;
    }

    private String getCouponInstanceStatus(String isUse, String isLock, Date useEndTime, Date useStartTime, Date nowTime) {
        String instanceStatus = CouponInstanceStatusEnum.VALID.getState();
        if (YesOrNoEnum.YES.getValue().equals(isUse)) {
            instanceStatus = CouponInstanceStatusEnum.USED.getState();
        } else if (YesOrNoEnum.YES.getValue().equals(isLock)) {
            instanceStatus = CouponInstanceStatusEnum.LOCKED.getState();
        } else if (nowTime.compareTo(useEndTime) > 0) {
            instanceStatus = CouponInstanceStatusEnum.INVALID.getState();
        } else if (nowTime.compareTo(useStartTime) < 0) {
            instanceStatus = CouponInstanceStatusEnum.NOT_FORCE.getState();
        }
        return instanceStatus;
    }

    private String getCouponInstanceStatusByCouponStatus(String isUse, String isLock, Date useEndTime, Date useStartTime, Date nowTime, String couponStatus) {
        String instanceStatus = CouponInstanceStatusEnum.VALID.getState();
        if (CouponStatusEnum.ACTIVATED.getState().equals(couponStatus)) {
            if (YesOrNoEnum.YES.getValue().equals(isUse)) {
                instanceStatus = CouponInstanceStatusEnum.USED.getState();
            } else if (YesOrNoEnum.YES.getValue().equals(isLock)) {
                instanceStatus = CouponInstanceStatusEnum.LOCKED.getState();
            } else if (nowTime.compareTo(useEndTime) > 0) {
                instanceStatus = CouponInstanceStatusEnum.INVALID.getState();
            } else if (nowTime.compareTo(useStartTime) < 0) {
                instanceStatus = CouponInstanceStatusEnum.NOT_FORCE.getState();
            }
        } else {
            instanceStatus = CouponInstanceStatusEnum.INVALID.getState();
        }
        return instanceStatus;
    }

    public List<CouponReservedAndCheckedDTO> statisticsOfReservedAndChecked(String activeInstanceCode, String activeCode, String startDate, String endDate) {
        return this.couponRepository.statisticsOfReservedAndChecked(activeInstanceCode, activeCode, startDate, endDate);
    }

    public List<CouponReceiveRecordsDTO> queryRecordsByMemberAndCouponCodes(Long memberId, List<String> couponCodes) {
        return this.couponRepository.queryRecordsByMemberAndCouponCodes(memberId, couponCodes);
    }

    public CouponDTO deleteCoupon(CouponDeleteParam couponDeleteParam) {
        CouponDTO couponDTO = this.checkBeforeDelete(couponDeleteParam.getCouponCode());
        CouponBO couponBO = CouponDeleteConvertor.INSTANCE.paramToBO(couponDeleteParam);
        this.couponRepository.deleteCoupon(couponBO);
        return couponDTO;
    }

    private String generatePrefixCode(String couponType) {
        if (CouponTypeEnum.DISCOUNT.getState().equals(couponType)) {
            return SnowflakeIdWorker.getIdWithPrefix((String)"ID");
        }
        if (CouponTypeEnum.REDUCE.getState().equals(couponType)) {
            return SnowflakeIdWorker.getIdWithPrefix((String)"IR");
        }
        if (CouponTypeEnum.GIFT.getState().equals(couponType)) {
            return SnowflakeIdWorker.getIdWithPrefix((String)"IG");
        }
        if (CouponTypeEnum.PURCHASE.getState().equals(couponType)) {
            return SnowflakeIdWorker.getIdWithPrefix((String)"IP");
        }
        if (CouponTypeEnum.FREIGHT.getState().equals(couponType)) {
            return SnowflakeIdWorker.getIdWithPrefix((String)"IF");
        }
        return null;
    }

    private CouponDTO checkAndReduceReceivedCount(String couponCode, Long memberId, int receivedCount) {
        Long number;
        Date nowTime;
        CouponDTO couponDTO = this.couponRepository.selectCouponByCode(couponCode);
        if (null == couponDTO) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0009");
        }
        if (!CouponStatusEnum.ACTIVATED.getState().equals(couponDTO.getCouponStatus())) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0011");
        }
        if ((nowTime = new Date()).compareTo(couponDTO.getStartTime()) < 0 || nowTime.compareTo(couponDTO.getReceiveEndTime()) > 0) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0019");
        }
        if (YesOrNoEnum.YES.getValue().equals(couponDTO.getIsLimitQuantity()) && couponDTO.getReceivedCount() + receivedCount > couponDTO.getQuantity()) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0010");
        }
        if ((number = this.couponRepository.countCouponReceiveRecordsByFromUserIdAndCouponCode(memberId, couponCode)) >= (long)couponDTO.getGetLimit().intValue()) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0012");
        }
        if (this.couponRepository.updateCouponByVersion(couponDTO.getId(), couponDTO.getVersion(), receivedCount) <= 0) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0010");
        }
        return couponDTO;
    }

    private CouponReceiveRecordsDTO addCouponReceiveRecords(CouponDTO couponDTO, Long memberId, String memberName, Date receiveTime, String receiveType, String receiveChannel, String activeCode, String activeInstanceCode, String activeNodeCode) {
        CouponReceiveRecordsBean couponReceiveRecords = new CouponReceiveRecordsBean();
        couponReceiveRecords.setInstanceCode(this.generatePrefixCode(couponDTO.getCouponType()));
        couponReceiveRecords.setCouponCode(couponDTO.getCouponCode());
        couponReceiveRecords.setCouponType(couponDTO.getCouponType());
        couponReceiveRecords.setMemberId(memberId);
        couponReceiveRecords.setMemberName(memberName);
        couponReceiveRecords.setIsUse(YesOrNoEnum.NO.getValue());
        couponReceiveRecords.setIsLock(YesOrNoEnum.NO.getValue());
        couponReceiveRecords.setReceiveType(receiveType);
        couponReceiveRecords.setReceiveTime(receiveTime);
        couponReceiveRecords.setReceiveChannel(receiveChannel);
        couponReceiveRecords.setRuleId(couponDTO.getRuleId());
        couponReceiveRecords.setActiveCode(activeCode);
        couponReceiveRecords.setUseStartTime(couponDTO.getStartTime());
        couponReceiveRecords.setActiveInstanceCode(activeInstanceCode);
        couponReceiveRecords.setActiveNodeCode(activeNodeCode);
        String validTimeType = couponDTO.getValidTimeType();
        if (StringUtils.equals((CharSequence)ValidTimeTypeEnum.END_DATE.getState(), (CharSequence)validTimeType)) {
            couponReceiveRecords.setUseEndTime(couponDTO.getUseEndTime());
        } else if (StringUtils.equals((CharSequence)ValidTimeTypeEnum.DAYS_AFTER_RECEIVE.getState(), (CharSequence)validTimeType)) {
            couponReceiveRecords.setUseEndTime(DateUtils.addDays((Date)receiveTime, (int)couponDTO.getFixedTerm()));
        }
        this.operLogRepository.sendOperLogMsg(OperTypeEnum.COUPON_INSTANCE.getState(), OperActionEnum.RECEIVE.getState(), couponReceiveRecords.getInstanceCode(), null, null, null, null);
        return this.couponRepository.addCouponReceiveRecords(couponReceiveRecords);
    }

    private CouponDTO checkBeforeModify(String couponCode) {
        NrosPreconditions.getInstance().hasText(couponCode, "NROS-SBC-PROMOTION-COUPON-0008");
        CouponDTO couponDTO = this.couponRepository.selectCouponByCode(couponCode);
        if (couponDTO == null) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0009");
        }
        if (!CouponStatusEnum.DESIGNING.getState().equals(couponDTO.getCouponStatus())) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0033");
        }
        return couponDTO;
    }

    private void sendEventTraceMessage(String eventCode, Long memberId, String nowTime, String couponCode, String couponName, String activeCode, String orderCode) {
        JSONObject message = new JSONObject();
        message.put((Object)"eventCode", (Object)eventCode);
        message.put((Object)"memberId", (Object)memberId);
        message.put((Object)"gmtCreate", (Object)nowTime);
        JSONArray attributeList = new JSONArray();
        JSONObject attribute = new JSONObject();
        attribute.put((Object)"fieldCode", (Object)"couponCode");
        attribute.put((Object)"fieldValue", (Object)couponCode);
        attributeList.add((Object)attribute);
        attribute = new JSONObject();
        attribute.put((Object)"fieldCode", (Object)"couponName");
        attribute.put((Object)"fieldValue", (Object)couponName);
        attributeList.add((Object)attribute);
        if (StringUtils.isNotBlank((CharSequence)activeCode)) {
            attribute = new JSONObject();
            attribute.put((Object)"fieldCode", (Object)"promotionId");
            attribute.put((Object)"fieldValue", (Object)activeCode);
            attributeList.add((Object)attribute);
        }
        if (StringUtils.isNotEmpty((CharSequence)orderCode)) {
            attribute = new JSONObject();
            attribute.put((Object)"fieldCode", (Object)"orderNo");
            attribute.put((Object)"fieldValue", (Object)orderCode);
            attributeList.add((Object)attribute);
        }
        message.put((Object)"attributeList", (Object)attributeList);
        try {
            NrosMQMessage msg = NrosMQMessage.buildNrosMQMessage((JSONObject)message, (String)this.topic);
            this.defaultZMQProducer.sendMessage(this.defaultZMQProducer.getProducer(), msg);
        }
        catch (Exception e) {
            logger.error("eventCode:{},couponCode:{},memberId:{},orderNo:{}, send MQ fail.", new Object[]{eventCode, couponCode, memberId, orderCode});
        }
    }

    private CouponDTO checkBeforeDelete(String couponCode) {
        CouponDTO couponDTO = this.couponRepository.selectCouponByCode(couponCode);
        if (couponDTO == null) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0038");
        }
        if (StatusEnum.DISABLE.getState().equals(couponDTO.getStatus())) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0039");
        }
        if (!CouponStatusEnum.DESIGNING.getState().equals(couponDTO.getCouponStatus())) {
            ExceptionHandler.publish((String)"NROS-SBC-PROMOTION-COUPON-0040");
        }
        return couponDTO;
    }

    public Long couponAmtCompute(RuleSaveParam ruleSaveParam) {
        List ruleConditions = ruleSaveParam.getRuleConditions();
        if (CollectionUtils.isEmpty((Collection)ruleConditions)) {
            return 0L;
        }
        ConditionParam condition = (ConditionParam)ruleConditions.get(0);
        if (StringUtils.equals((CharSequence)ruleSaveParam.getDiscountType(), (CharSequence)DiscountTypeEnum.FULL_DISCOUNT.getState())) {
            return 0L;
        }
        if (StringUtils.equals((CharSequence)ruleSaveParam.getDiscountType(), (CharSequence)DiscountTypeEnum.FULL_REDUCTION.getState())) {
            DiscountParam discount = condition.getDiscount();
            return discount.getReducePrice();
        }
        if (StringUtils.equals((CharSequence)ruleSaveParam.getDiscountType(), (CharSequence)DiscountTypeEnum.FULL_GIFT.getState())) {
            List giftList = condition.getGiftList();
            BigDecimal totalDiscountAmt = BigDecimal.ZERO;
            for (GiftParam gift : giftList) {
                BigDecimal originalPrice = new BigDecimal(gift.getOriginalPrice());
                BigDecimal giftQuantity = new BigDecimal(gift.getQuantity());
                BigDecimal giftAmt = originalPrice.multiply(giftQuantity);
                totalDiscountAmt = totalDiscountAmt.add(giftAmt);
            }
            return totalDiscountAmt.longValue();
        }
        if (StringUtils.equals((CharSequence)ruleSaveParam.getDiscountType(), (CharSequence)DiscountTypeEnum.FULL_PURCHASE.getState())) {
            List purchaseList = condition.getPurchaseList();
            BigDecimal totalDiscountAmt = BigDecimal.ZERO;
            for (PurchaseParam purchase : purchaseList) {
                BigDecimal originalPrice = new BigDecimal(purchase.getOriginalPrice());
                BigDecimal price = new BigDecimal(purchase.getPrice());
                BigDecimal orderQuantityLimit = new BigDecimal(purchase.getOrderQuantityLimit());
                BigDecimal purchaseDiscountAmt = originalPrice.subtract(price).multiply(orderQuantityLimit);
                totalDiscountAmt = totalDiscountAmt.add(purchaseDiscountAmt);
            }
            return totalDiscountAmt.longValue();
        }
        if (StringUtils.equals((CharSequence)ruleSaveParam.getDiscountType(), (CharSequence)DiscountTypeEnum.FULL_FREIGHT.getState())) {
            DiscountParam discount = condition.getDiscount();
            return discount.getReducePrice();
        }
        return 0L;
    }
}

