/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.promotion.server.common.util;

import com.ztesoft.zsmart.nros.base.exception.ExceptionHandler;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;

public final class NrosPreconditions {
    private static NrosPreconditions instance = new NrosPreconditions();

    private NrosPreconditions() {
    }

    public static NrosPreconditions getInstance() {
        return instance;
    }

    public void notNull(Object object, String errorCode) {
        if (object == null) {
            NrosPreconditions.throwException(errorCode);
        }
    }

    public void notEmpty(Collection<?> collection, String errorCode) {
        if (collection == null || collection.isEmpty()) {
            NrosPreconditions.throwException(errorCode);
        }
    }

    public void notEmpty(Map<?, ?> map, String errorCode) {
        if (map == null || map.isEmpty()) {
            NrosPreconditions.throwException(errorCode);
        }
    }

    public void hasText(String text, String errorCode) {
        if (text == null || text.isEmpty()) {
            NrosPreconditions.throwException(errorCode);
        }
    }

    public void hasPositiveNumber(Integer number, String errorCode) {
        if (number == null || number <= 0) {
            NrosPreconditions.throwException(errorCode);
        }
    }

    public void hasPositiveNumber(Long number, String errorCode) {
        if (number == null || number <= 0L) {
            NrosPreconditions.throwException(errorCode);
        }
    }

    public void hasPositiveNumber(Double number, String errorCode) {
        if (number == null || number <= 0.0) {
            NrosPreconditions.throwException(errorCode);
        }
    }

    public void hasPositiveNumber(BigDecimal number, String errorCode) {
        if (number == null || number.doubleValue() <= 0.0) {
            NrosPreconditions.throwException(errorCode);
        }
    }

    private static void throwException(String errorCode) {
        ExceptionHandler.publish((String)errorCode);
    }
}

