/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.admin.promotion.controller;

import com.ztesoft.zsmart.nros.base.annotation.SessionController;
import com.ztesoft.zsmart.nros.base.model.ResponseMsg;
import com.ztesoft.zsmart.nros.base.util.CommonFunctions;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.common.convertor.RuleConvertor;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.dto.RuleDTO;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.param.RuleDeleteParam;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.param.RuleSaveParam;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.query.RuleQuery;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.vo.RuleVO;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.service.RuleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@SessionController
@RequestMapping(value={"/rule"})
@Api(value="\u89c4\u5219\u7ba1\u7406", tags={"\u89c4\u5219\u7ba1\u7406"})
public class RuleController {
    @Autowired
    private RuleService ruleService;
    @Autowired
    private RuleConvertor ruleConvertor;

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u4fdd\u5b58\u89c4\u5219")
    public ResponseMsg saveRule(@RequestBody RuleSaveParam ruleSaveParam) {
        this.ruleService.saveRule(ruleSaveParam);
        return new ResponseMsg().success();
    }

    @DeleteMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u89c4\u5219")
    public ResponseMsg deleteRule(@RequestBody RuleDeleteParam ruleDeleteParam) {
        this.ruleService.deleteRule(ruleDeleteParam);
        return new ResponseMsg().success();
    }

    @PostMapping(value={"/page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u89c4\u5219\u5217\u8868")
    public ResponseMsg<List<RuleVO>> pageRule(@RequestBody RuleQuery ruleQuery) {
        ResponseMsg<List<RuleDTO>> listResponseMsg = this.ruleService.pageRule(ruleQuery);
        return CommonFunctions.runTranslateByList(listResponseMsg, () -> {
            List<RuleVO> ruleVOS = this.ruleConvertor.dtosToVOS((List)listResponseMsg.getData());
            return ruleVOS;
        });
    }

    @PostMapping(value={"/detail"})
    @ApiOperation(value="\u67e5\u8be2\u89c4\u5219\u8be6\u60c5")
    public ResponseMsg<RuleVO> detailRule(@RequestBody RuleQuery ruleQuery) {
        ResponseMsg<RuleDTO> ruleDTOResponseMsg = this.ruleService.detailRule(ruleQuery);
        return CommonFunctions.runSupplier(() -> this.ruleConvertor.dtoToDetailVO((RuleDTO)ruleDTOResponseMsg.getData()), (String)"\u67e5\u8be2\u89c4\u5219\u8be6\u60c5\u5f02\u5e38");
    }
}

