/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.admin.promotion.controller;

import com.alibaba.fastjson.JSONArray;
import com.ztesoft.zsmart.nros.base.annotation.SessionController;
import com.ztesoft.zsmart.nros.base.model.ResponseMsg;
import com.ztesoft.zsmart.nros.base.util.CommonFunctions;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.common.convertor.CouponConvertor;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.dto.CouponDTO;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.dto.CouponGoodsRangeDTO;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.dto.CouponInstanceDTO;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.dto.CouponReceiveRecordsDTO;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.dto.StoreDTO;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.param.AssociationRuleSaveParam;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.param.CancelConsumeCouponParam;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.param.CancelReceiveCouponParam;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.param.CouponConsumeParam;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.param.CouponDeleteParam;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.param.CouponGoodsRangeDeleteParam;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.param.CouponGoodsRangeParam;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.param.CouponSaveParam;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.param.InvalidCouponParam;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.param.LockCouponParam;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.query.CouponCodeQuery;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.query.CouponInstanceQuery;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.query.CouponQuery;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.query.CouponReceiveListQuery;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.query.StoreQuery;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.vo.CouponVO;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.service.BasedataToPromotionService;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.service.CouponService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@SessionController
@RequestMapping(value={"/coupon"})
@Api(value="\u4f18\u60e0\u5238\u7ba1\u7406", tags={"\u4f18\u60e0\u5238\u7ba1\u7406"})
public class CouponController {
    @Autowired
    private CouponService couponService;
    @Autowired
    private CouponConvertor couponConvertor;
    @Autowired
    private BasedataToPromotionService basedataService;

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u4fdd\u5b58\u4f18\u60e0\u5238")
    public ResponseMsg save(@RequestBody CouponSaveParam couponSaveParam) {
        return this.couponService.save(couponSaveParam);
    }

    @GetMapping(value={"/{couponCode}"})
    @ApiOperation(value="\u67e5\u8be2\u4f18\u60e0\u5238")
    public ResponseMsg<CouponVO> findByCouponCode(@PathVariable(value="couponCode") String couponCode) {
        ResponseMsg<CouponDTO> byCouponCode = this.couponService.findByCouponCode(couponCode);
        return CommonFunctions.runSupplier(() -> this.couponConvertor.dtoToVO((CouponDTO)byCouponCode.getData()), (String)"\u67e5\u8be2\u4f18\u60e0\u5238\u5f02\u5e38");
    }

    @PostMapping(value={"/save-goods-range-type"})
    @ApiOperation(value="\u4f18\u60e0\u5238\u6dfb\u52a0\u6216\u4fee\u6539\u5546\u54c1\u8303\u56f4\u7c7b\u578b")
    public ResponseMsg saveGoodsRangeType(@RequestBody CouponSaveParam couponSaveParam) {
        this.couponService.saveGoodsRangeType(couponSaveParam);
        return new ResponseMsg().success();
    }

    @PostMapping(value={"/save-coupon-goods-range"})
    @ApiOperation(value="\u4f18\u60e0\u5238\u6dfb\u52a0\u5546\u54c1\u8303\u56f4\u4fe1\u606f")
    public ResponseMsg saveCouponGoodsRange(@RequestBody CouponGoodsRangeParam couponGoodsRangeParam) {
        return this.couponService.saveCouponGoodsRange(couponGoodsRangeParam);
    }

    @PostMapping(value={"goods-ranges/batch-save"})
    @ApiOperation(value="\u6279\u91cf\u65b0\u589e\u4f18\u60e0\u5238\u5546\u54c1\u8303\u56f4")
    public ResponseMsg batchSaveGoodsRanges(@RequestBody List<CouponGoodsRangeParam> goodsRangeParams) {
        return this.couponService.batchSaveGoodsRanges(goodsRangeParams);
    }

    @GetMapping(value={"/list-coupon-goods-range/{couponCode}"})
    @ApiOperation(value="\u6839\u636e\u4f18\u60e0\u5238code\u67e5\u8be2\u5546\u54c1\u8303\u56f4\u5217\u8868")
    public ResponseMsg<List<CouponGoodsRangeDTO>> listCouponGoodsRangeByCouponCode(@PathVariable(value="couponCode") String couponCode) {
        return this.couponService.listCouponGoodsRangeByCouponCode(couponCode);
    }

    @DeleteMapping(value={"/delete-coupon-goods-range"})
    @ApiOperation(value="\u4f18\u60e0\u5238\u5220\u9664\u5546\u54c1\u8303\u56f4\u4fe1\u606f")
    public ResponseMsg deleteCouponGoodsRange(@RequestBody CouponGoodsRangeDeleteParam couponGoodsRangeDeleteParam) {
        return this.couponService.deleteCouponGoodsRange(couponGoodsRangeDeleteParam);
    }

    @PostMapping(value={"/save-coupon-rule"})
    @ApiOperation(value="\u4fdd\u5b58\u4f18\u60e0\u5238\u89c4\u5219")
    public ResponseMsg saveCouponRule(@RequestBody AssociationRuleSaveParam couponRuleSaveParam) {
        this.couponService.saveCouponRule(couponRuleSaveParam);
        return new ResponseMsg().success();
    }

    @PutMapping(value={"/modify"})
    @ApiOperation(value="\u4fee\u6539\u4f18\u60e0\u5238")
    public ResponseMsg modify(@RequestBody CouponSaveParam couponSaveParam) {
        this.couponService.modify(couponSaveParam);
        return new ResponseMsg().success();
    }

    @PostMapping(value={"/list-all"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u4f18\u60e0\u5238\u5217\u8868")
    public ResponseMsg<List<CouponVO>> list(@RequestBody CouponQuery couponQuery) {
        ResponseMsg<List<CouponDTO>> listResponseMsg = this.couponService.listAllCoupon(couponQuery);
        return CommonFunctions.runTranslateByList(listResponseMsg, () -> this.couponConvertor.dtosToVOS((List)listResponseMsg.getData()));
    }

    @GetMapping(value={"/details/{couponCode}"})
    @ApiOperation(value="\u67e5\u8be2\u4f18\u60e0\u5238\u8be6\u60c5")
    public ResponseMsg<CouponVO> details(@ApiParam(value="\u4f18\u60e0\u5238Code", required=true) @PathVariable(value="couponCode") String couponCode) {
        ResponseMsg<CouponDTO> details = this.couponService.details(couponCode);
        CouponVO couponVO = this.couponConvertor.dtoToVO((CouponDTO)details.getData());
        if (couponVO != null) {
            if (CollectionUtils.isNotEmpty((Collection)couponVO.getChannel())) {
                List<String> channelNames = this.basedataService.getChannelNameByFieldCodes(JSONArray.parseArray((String)couponVO.getChannel().toJSONString(), String.class));
                couponVO.setChannelNames(channelNames);
            }
            if (CollectionUtils.isNotEmpty((Collection)couponVO.getStoreCode())) {
                StoreQuery storeQuery = new StoreQuery();
                storeQuery.setOrgCodes(JSONArray.parseArray((String)couponVO.getStoreCode().toJSONString(), String.class));
                List<StoreDTO> storeDTOS = this.basedataService.queryStoreList(storeQuery);
                if (CollectionUtils.isNotEmpty(storeDTOS)) {
                    couponVO.setStoreNames(storeDTOS.stream().map(StoreDTO::getName).collect(Collectors.toList()));
                }
            }
        }
        return CommonFunctions.runSupplier(() -> couponVO, (String)"\u67e5\u8be2\u4f18\u60e0\u5238\u8be6\u60c5\u5f02\u5e38");
    }

    @GetMapping(value={"/list-receive"})
    @ApiOperation(value="\u67e5\u8be2\u4f18\u60e0\u5238\u9886\u53d6\u5217\u8868")
    public ResponseMsg<List<CouponReceiveRecordsDTO>> listReceive(CouponReceiveListQuery couponReceiveListQuery) {
        return this.couponService.pageReceive(couponReceiveListQuery);
    }

    @PutMapping(value={"/cancel-receive"})
    @ApiOperation(value="\u53d6\u6d88\u9886\u53d6\u4f18\u60e0\u5238")
    public ResponseMsg cancelReceiveCoupon(@RequestBody CancelReceiveCouponParam cancelReceiveCouponParam) {
        this.couponService.cancelReceiveCoupon(cancelReceiveCouponParam);
        return new ResponseMsg().success();
    }

    @PutMapping(value={"/activate"})
    @ApiOperation(value="\u6fc0\u6d3b\u4f18\u60e0\u5238")
    public ResponseMsg activateCoupon(@RequestParam(value="couponCode") String couponCode) {
        this.couponService.activateCoupon(couponCode);
        return new ResponseMsg().success();
    }

    @PutMapping(value={"/invalid"})
    @ApiOperation(value="\u4f5c\u5e9f\u4f18\u60e0\u5238")
    public ResponseMsg invalidCoupon(@RequestBody InvalidCouponParam invalidCouponParam) {
        this.couponService.invalidCoupon(invalidCouponParam);
        return new ResponseMsg().success();
    }

    @GetMapping(value={"/validation"})
    @ApiOperation(value="\u4f18\u60e0\u5238\u6709\u6548\u6027\u9a8c\u8bc1")
    public ResponseMsg validation(@RequestParam(value="instanceCode") String instanceCode) {
        return this.couponService.validation(instanceCode);
    }

    @PostMapping(value={"/list-coupon-by-code-list"})
    @ApiOperation(value="\u6839\u636e\u4f18\u60e0\u5238code\u5217\u8868\u67e5\u8be2\u4f18\u60e0\u5238\u5217\u8868")
    public ResponseMsg<List<CouponDTO>> listCouponByCodeList(@RequestBody CouponCodeQuery couponCodeQuery) {
        return this.couponService.listCouponByCodeList(couponCodeQuery);
    }

    @PostMapping(value={"/list-coupon-instance-by-member-id"})
    @ApiOperation(value="\u67e5\u8be2\u4f1a\u5458\u4f18\u60e0\u5238\u5b9e\u4f8b\u5217\u8868")
    public ResponseMsg<List<CouponInstanceDTO>> listCouponInstanceByMemberId(@RequestBody CouponInstanceQuery couponMemberIdQuery) {
        return this.couponService.pageCouponInstance(couponMemberIdQuery);
    }

    @GetMapping(value={"/get-coupon-instance-by-instance-code"})
    @ApiOperation(value="\u6839\u636e\u5b9e\u4f8b\u7f16\u7801\u67e5\u8be2\u5b9e\u4f8b\u8be6\u60c5")
    public ResponseMsg<CouponInstanceDTO> getCouponInstanceByinstanceCode(@ApiParam(value="\u4f18\u60e0\u5238\u5b9e\u4f8b\u7f16\u7801", required=true) @RequestParam(value="instanceCode") String instanceCode) {
        return this.couponService.selectCouponInstanceByInstanceCode(instanceCode);
    }

    @PutMapping(value={"/lock"})
    @ApiOperation(value="\u9501\u5b9a/\u89e3\u9501\u4f18\u60e0\u5238")
    public ResponseMsg lockCouponInstance(@RequestBody LockCouponParam lockCouponParam) {
        this.couponService.lockCouponInstance(lockCouponParam);
        return new ResponseMsg().success();
    }

    @PutMapping(value={"/batch-lock"})
    @ApiOperation(value="\u6279\u91cf\u9501\u5b9a/\u89e3\u9501\u4f18\u60e0\u5238")
    public ResponseMsg batchLockCouponInstance(@RequestBody LockCouponParam lockCouponParam) {
        this.couponService.batchLockCouponInstance(lockCouponParam);
        return new ResponseMsg().success();
    }

    @PostMapping(value={"/consume"})
    @ApiOperation(value="\u6838\u9500\u4f18\u60e0\u5238")
    public ResponseMsg consumeCouponInstance(@RequestBody CouponConsumeParam consumeParam) {
        this.couponService.consumeCouponInstance(consumeParam);
        return new ResponseMsg().success();
    }

    @PutMapping(value={"/cancel-consume"})
    @ApiOperation(value="\u53d6\u6d88\u6838\u9500\u4f18\u60e0\u5238")
    public ResponseMsg cancelConsumeCouponInstance(@RequestBody CancelConsumeCouponParam cancelConsumeCouponParam) {
        this.couponService.cancelConsumeCouponInstance(cancelConsumeCouponParam);
        return new ResponseMsg().success();
    }

    @DeleteMapping(value={"/delete-coupon"})
    @ApiOperation(value="\u5220\u9664\u4f18\u60e0\u5238")
    public ResponseMsg deleteCoupon(@RequestBody CouponDeleteParam couponDeleteParam) {
        return this.couponService.deleteCoupon(couponDeleteParam);
    }
}

