/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.admin.promotion.common.convertor;

import com.ztesoft.zsmart.nros.sbc.admin.promotion.common.convertor.ConditionConvertor;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.common.enums.CouponTypeEnum;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.dto.RuleDTO;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.vo.ConditionVO;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.vo.DiscountVO;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.vo.RuleVO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.mapstruct.Mapper;

@Mapper(componentModel="spring", uses={ConditionConvertor.class})
public abstract class RuleConvertor {
    public abstract RuleVO dtoToVO(RuleDTO var1);

    public List<RuleVO> dtosToVOS(List<RuleDTO> ruleDTOS) {
        if (ruleDTOS == null) {
            return null;
        }
        ArrayList<RuleVO> ruleVOS = new ArrayList<RuleVO>(ruleDTOS.size());
        for (RuleDTO ruleDTO : ruleDTOS) {
            ruleVOS.add(this.dtoToVO(ruleDTO));
        }
        return ruleVOS;
    }

    public RuleVO dtoToDetailVO(RuleDTO ruleDTO) {
        RuleVO ruleVO = this.dtoToVO(ruleDTO);
        if (ruleVO != null && CollectionUtils.isNotEmpty(ruleVO.getRuleConditions())) {
            for (ConditionVO ruleCondition : ruleVO.getRuleConditions()) {
                DiscountVO discount = ruleCondition.getDiscount();
                if (discount == null) continue;
                if (CouponTypeEnum.DISCOUNT.getState().equals(ruleVO.getDiscountType())) {
                    discount.setValue(discount.getDiscount().toPlainString());
                    continue;
                }
                if (!CouponTypeEnum.FREIGHT.getState().equals(ruleVO.getDiscountType()) && !CouponTypeEnum.REDUCE.getState().equals(ruleVO.getDiscountType())) continue;
                discount.setValue(discount.getReducePriceStr());
            }
        }
        return ruleVO;
    }
}

