/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.comsumer.service;

import com.alibaba.druid.util.LRUCache;
import com.alibaba.fastjson.JSON;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.comsumer.config.KafkaConsumerClient;
import com.bizvane.comsumer.config.TopicNames;
import com.bizvane.comsumer.service.dao.SkuDetailDao;
import com.bizvane.comsumer.service.dao.StorePriceStockDao;
import com.bizvane.comsumer.service.entities.CacheEntry;
import com.bizvane.comsumer.service.entities.SkuDetail;
import com.bizvane.comsumer.service.entities.StorePriceStock;
import com.bizvane.comsumer.service.entities.StoreStockPriceVO;
import com.bizvane.comsumer.service.feign.StoreFeignService;
import com.bizvane.utils.responseinfo.ResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class MqListenerService
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(MqListenerService.class);
    @Autowired
    private KafkaConsumerClient<String> kafkaConsumerClient;
    @Autowired
    private StorePriceStockDao storePriceStockDao;
    @Autowired
    private SkuDetailDao skuDetailDao;
    @Autowired
    private TopicNames topicNames;
    @Autowired
    private StoreFeignService storeFeignService;
    private LRUCache<String, CacheEntry> cache = new LRUCache(4096);

    public void run(ApplicationArguments args) {
        log.info("MqListenerService_init");
        new Thread(() -> this.kafkaConsumerClient.receive(this.topicNames.getBusinessNameList(), 10000L, x -> x.forEach(y -> this.messageListen((String)y.key(), (String)y.value())))).start();
    }

    public void messageListen(String key, String value) {
        log.info("messageListen_key:{},value:{}", (Object)key, (Object)value);
        try {
            StoreStockPriceVO consumerVO = (StoreStockPriceVO)JSON.parseObject((String)value, StoreStockPriceVO.class);
            StorePriceStock storePriceStock = this.storePriceStockDao.selectBySkuCode(consumerVO.getOfflineStoreCode(), consumerVO.getSkuCode(), consumerVO.getMerchantId());
            log.info("MqListenerService_consumerVO:{}", (Object)JSON.toJSONString((Object)consumerVO));
            if (storePriceStock == null) {
                this.insert(consumerVO);
            } else {
                log.info("MqListenerService_storePriceStock:{}", (Object)JSON.toJSONString((Object)storePriceStock));
                this.update(storePriceStock, consumerVO);
            }
        }
        catch (Exception e) {
            log.error("messageListen_error:" + e.getMessage(), (Throwable)e);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void insert(StoreStockPriceVO consumerVO) {
        StorePriceStock storePriceStock = new StorePriceStock();
        BeanUtils.copyProperties((Object)consumerVO, (Object)storePriceStock);
        SkuDetail skuDetail = this.skuDetailDao.selectByMerchantSku(storePriceStock.getGoodsCode(), storePriceStock.getSkuCode(), storePriceStock.getMerchantId());
        String cacheKey = storePriceStock.getMerchantId() + ":" + storePriceStock.getOfflineStoreCode();
        if (this.cache.containsKey((Object)cacheKey)) {
            CacheEntry cacheEntry = (CacheEntry)this.cache.get((Object)cacheKey);
            storePriceStock.setOfflineStoreId(cacheEntry.getOfflineStoreId());
            storePriceStock.setStoreId(cacheEntry.getSysStoreId());
            storePriceStock.setPlatformStoreId(cacheEntry.getSysStoreId());
        } else {
            ResponseData response = this.storeFeignService.getStoreInfoByCodeAndBrandId(storePriceStock.getOfflineStoreCode(), storePriceStock.getMerchantId());
            log.info("storeFeignService_result:{}", (Object)JSON.toJSONString((Object)response));
            if (response != null && response.getCode() == 0) {
                storePriceStock.setOfflineStoreId(((SysStorePo)response.getData()).getStoreId());
                storePriceStock.setStoreId(((SysStorePo)response.getData()).getSysStoreId());
                storePriceStock.setPlatformStoreId(((SysStorePo)response.getData()).getSysStoreId());
                CacheEntry cacheEntry = new CacheEntry(((SysStorePo)response.getData()).getStoreId(), ((SysStorePo)response.getData()).getSysStoreId());
                this.cache.put((Object)cacheKey, (Object)cacheEntry);
            }
        }
        storePriceStock.setSkuId(skuDetail != null ? skuDetail.getId() : null);
        storePriceStock.setGoodsId(skuDetail != null ? skuDetail.getGoodsId() : null);
        int insert = this.storePriceStockDao.insert((Object)storePriceStock);
        log.info("MqListenerService_insert_result:{} ,count:{}", (Object)JSON.toJSONString((Object)storePriceStock), (Object)insert);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(StorePriceStock storePriceStock, StoreStockPriceVO consumerVO) {
        SkuDetail skuDetail;
        Boolean flag = false;
        if ((storePriceStock.getSkuId() == null || storePriceStock.getGoodsId() == null) && (skuDetail = this.skuDetailDao.selectByMerchantSku(storePriceStock.getGoodsCode(), storePriceStock.getSkuCode(), storePriceStock.getMerchantId())) != null) {
            storePriceStock.setSkuId(skuDetail.getId());
            storePriceStock.setGoodsId(skuDetail.getGoodsId());
            flag = true;
        }
        if (consumerVO.getStorePrice() != null && storePriceStock.getStorePrice().compareTo(consumerVO.getStorePrice()) != 0) {
            storePriceStock.setStorePrice(consumerVO.getStorePrice());
            flag = true;
        }
        if (consumerVO.getStoreStock() != null && !storePriceStock.getStoreStock().equals(consumerVO.getStoreStock())) {
            storePriceStock.setStoreStock(consumerVO.getStoreStock());
            flag = true;
        }
        if (flag.booleanValue()) {
            this.storePriceStockDao.updateByPrimaryKeySelective((Object)storePriceStock);
        }
        log.info("MqListenerService_update_result:{}", (Object)flag);
    }
}

