/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.ProcessBarUtil;
import com.wmeimob.fastboot.bizvane.builder.OrdersBuilder;
import com.wmeimob.fastboot.bizvane.dto.FriendsReduceDto;
import com.wmeimob.fastboot.bizvane.dto.MyReducePriceDto;
import com.wmeimob.fastboot.bizvane.entity.BargainPlayers;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.MarketActivity;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityGoods;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityOrders;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.mapper.BargainPlayersMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityOrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrderItemsMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.service.AssembleService;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.bizvane.service.GoodsService;
import com.wmeimob.fastboot.bizvane.service.MarketActivityOrdersService;
import com.wmeimob.fastboot.bizvane.service.MarketActivityService;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.util.InputValidator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;

@Service(value="marketActivityOrdersService")
public class MarketActivityOrdersServiceImpl
implements MarketActivityOrdersService {
    private static final Logger log = LoggerFactory.getLogger(MarketActivityOrdersServiceImpl.class);
    @Autowired
    private MarketActivityGoodsMapper marketActivityGoodsMapper;
    @Autowired
    private MarketActivityOrdersMapper marketActivityOrdersMapper;
    @Autowired
    private BargainPlayersMapper bargainPlayersMapper;
    @Autowired
    private MarketActivityMapper marketActivityMapper;
    @Autowired
    private MarketActivityService marketActivityService;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private OrdersMapper ordersMapper;
    @Autowired
    private GoodsSkuDetailMapper goodsSkuDetailMapper;
    @Autowired
    private OrderItemsMapper orderItemsMapper;
    @Autowired
    private GoodsService goodsService;
    @Resource
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Autowired
    private ConfigService configService;
    @Autowired
    private OrdersService ordersService;
    private static final String ORDER_CLOSE_KEY = "market_orders:%s:close_handler";
    public static String REDIS_FREEZE_STOCK_KEY = "wx_reducePrice_freeze_stock_";
    public static String REDIS_PRECALULATE_PRICE_ARRAY_KEY = "wx_reducePrice_preCal_";
    private static final String USER_ADD_ORDER_KEY = "user:%s:add_order";
    @Autowired
    private AssembleService assembleService;

    public PageInfo<MyReducePriceDto> queryMyReduce(Date currentTime, MarketActivityOrders mao, Integer merchantId, int pageNum, int pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List marketActivityGoods = this.marketActivityOrdersMapper.selectAvailbleOrdersByRule(mao.getLaunchUserNo(), merchantId);
        PageInfo pageInfo = new PageInfo(marketActivityGoods);
        return this.chooseMyReduceByRule(currentTime, pageInfo);
    }

    public List<MyReducePriceDto> queryMyReduce1(Date currentTime, MarketActivityOrders mao, Integer merchantId, int pageNum, int pageSize) {
        log.info("\u6211\u7684\u780d\u4ef7  \u53c2\u6570\u4e3a===>{},{}", (Object)mao.getUserNo(), (Object)merchantId);
        List orders = this.marketActivityOrdersMapper.getReducePriceListByMe(mao.getUserNo(), merchantId);
        Date current = new Date();
        List<MyReducePriceDto> collect = orders.stream().map(e -> {
            Example hdGoodExa = new Example(MarketActivityGoods.class);
            hdGoodExa.createCriteria().andEqualTo("marketActivityNo", (Object)e.getMarketActivityNo()).andEqualTo("goodsNo", (Object)e.getGoodsNo());
            List marketActivityGoods = this.marketActivityGoodsMapper.selectByExample((Object)hdGoodExa);
            MyReducePriceDto result = new MyReducePriceDto();
            Integer goodsId = null;
            for (MarketActivityGoods activityGoods : marketActivityGoods) {
                Example goodsExa = new Example(Goods.class);
                goodsExa.createCriteria().andEqualTo("goodsNo", (Object)activityGoods.getGoodsNo()).andEqualTo("isDel", (Object)Boolean.FALSE);
                Goods goods = (Goods)this.goodsMapper.selectOneByExample((Object)goodsExa);
                GoodsSkuDetail goodsSkuDetail = new GoodsSkuDetail();
                goodsSkuDetail.setGoodsId(goods.getId());
                List select = this.goodsSkuDetailMapper.select((Object)goodsSkuDetail);
                goodsId = goods.getId();
                BeanUtils.copyProperties((Object)e, (Object)result);
                if (goods != null) {
                    this.getSkockNum(activityGoods.getSkuNo(), goods.getId());
                    activityGoods.setGoodsPrice(goods.getSalePrice());
                    activityGoods.setGoodsAssembleNum(goods.getAssembleNum());
                    activityGoods.setGoodsName(goods.getGoodsName());
                    activityGoods.setGoodsPicUrl(goods.getCoverImg());
                    activityGoods.setActivityPersonNum(e.getActivityPersonNum());
                    activityGoods.setOrdersStatus(e.getOrdersStatus());
                    activityGoods.setActivityOrdersId(e.getId());
                }
                result.setGoodsSku(e.getSkuNo());
                result.setGoodsPicUrl(goods.getCoverImg());
                result.setGoodsSkuName(goodsSkuDetail.getSpecNames());
                result.setMarketActivityOrdersNo(e.getActivityOrderNo());
                result.setSalePrice(goodsSkuDetail.getSalesPrice());
                result.setShowSkuNo(goodsSkuDetail.getSkuNo());
            }
            MarketActivityGoods marketActivityGoods1 = this.chooseSkuByRule(marketActivityGoods, goodsId + "");
            if (marketActivityGoods1 == null) {
                result.setShowSkuNo(e.getSkuNo());
            } else {
                result.setShowSkuNo(marketActivityGoods1.getSkuNo());
            }
            BigDecimal reduceTotalAmount = BigDecimal.ZERO;
            if (!StringUtils.isEmpty((Object)e.getActivityOrderNo())) {
                BargainPlayers bp = new BargainPlayers();
                bp.setActivityOrdersNo(e.getActivityOrderNo());
                List select = this.bargainPlayersMapper.select((Object)bp);
                reduceTotalAmount = select.stream().map(f -> f.getAmount()).reduce(BigDecimal.ZERO, (x, y) -> y.add((BigDecimal)x));
            }
            result.setAlreadyReduce(reduceTotalAmount + "");
            int step = this.getActivitySign(e, current);
            result.setActivitySign(Integer.valueOf(step));
            Date date = DateUtils.addHours((Date)e.getGmtCreate(), (int)e.getActivityTermValidity());
            long remianTimeMills = date.getTime() - currentTime.getTime();
            if (step == 1) {
                result.setRemainingTime(remianTimeMills + "");
                result.setActivitySign(Integer.valueOf(1));
            } else if (step == 2) {
                result.setRemainingTime(null);
                result.setRemainingTime("\u780d\u4ef7\u5df2\u8fc7\u671f");
                result.setActivitySign(Integer.valueOf(2));
            } else {
                result.setRemainingTime(remianTimeMills + "");
                result.setAlreadyReduce("\u5df2\u780d" + reduceTotalAmount + "\u5143\u606d\u559c\u5df2\u780d\u5230\u6700\u4f4e\u4ef7");
                result.setActivitySign(Integer.valueOf(3));
            }
            return result;
        }).collect(Collectors.toList());
        return collect;
    }

    private int getActivitySign(MarketActivityGoods activityGoods, Date current) {
        Integer activityTermValidity;
        Date gmtCreate = activityGoods.getGmtCreate();
        if (DateUtils.addHours((Date)gmtCreate, (int)(activityTermValidity = activityGoods.getActivityTermValidity())).before(current)) {
            return 2;
        }
        if (!StringUtils.isEmpty((Object)activityGoods.getActivityOrderNo())) {
            BargainPlayers bp = new BargainPlayers();
            bp.setActivityOrdersNo(activityGoods.getActivityOrderNo());
            List select = this.bargainPlayersMapper.select((Object)bp);
            if (!CollectionUtils.isEmpty((Collection)select) && select.size() == activityGoods.getActivityPersonNum().intValue()) {
                return 3;
            }
        }
        return 1;
    }

    public FriendsReduceDto queryHelpFriends(String userNo, String activityOrdersNo, String goodsId, String showSkuNo, String openId) {
        FriendsReduceDto result = new FriendsReduceDto();
        MarketActivityOrders mao = new MarketActivityOrders();
        mao.setActivityOrdersNo(activityOrdersNo);
        MarketActivityOrders marketActivityOrders = (MarketActivityOrders)this.marketActivityOrdersMapper.selectOne((Object)mao);
        if (marketActivityOrders == null) {
            log.info("\u8425\u9500\u8ba2\u5355\u672a\u627e\u5230\uff0c\u8425\u9500\u8ba2\u5355\u53f7:[{}]" + mao.getActivityOrdersNo());
            throw new CustomException("\u8425\u9500\u8ba2\u5355\u672a\u627e\u5230");
        }
        if (!StringUtils.isEmpty((Object)marketActivityOrders.getOrdersNo())) {
            log.info("\u8be5\u8425\u9500\u8ba2\u5355\u5df2\u7ecf\u652f\u4ed8\u8fc7:[{}]", (Object)activityOrdersNo);
            result.setStatus(Integer.valueOf(5));
            return result;
        }
        MarketActivity marketActivity = new MarketActivity();
        marketActivity.setActivityNo(marketActivityOrders.getActivityNo());
        marketActivity.setActivityStatus(Boolean.valueOf(true));
        marketActivity = (MarketActivity)this.marketActivityMapper.selectOne((Object)marketActivity);
        MarketActivityGoods marketActivityGoods = new MarketActivityGoods();
        marketActivityGoods.setMarketActivityNo(marketActivity.getActivityNo());
        marketActivityGoods.setSkuNo(marketActivityOrders.getGoodsSkuNo());
        marketActivityGoods = (MarketActivityGoods)this.marketActivityGoodsMapper.selectOne((Object)marketActivityGoods);
        GoodsSkuDetail show = new GoodsSkuDetail();
        show.setGoodsId(Integer.valueOf(Integer.parseInt(goodsId)));
        show.setSkuNo(showSkuNo);
        show = (GoodsSkuDetail)this.goodsSkuDetailMapper.selectOne((Object)show);
        GoodsSkuDetail realSku = new GoodsSkuDetail();
        realSku.setSkuNo(marketActivityGoods.getSkuNo());
        realSku.setGoodsId(show.getGoodsId());
        realSku = (GoodsSkuDetail)this.goodsSkuDetailMapper.selectOne((Object)realSku);
        marketActivityGoods.setPrice(realSku.getSalesPrice());
        BeanUtils.copyProperties((Object)show, (Object)result);
        result.setSalePrice(show.getSalesPrice());
        Goods goods = this.goodsMapper.selectById(Integer.valueOf(Integer.parseInt(goodsId)));
        result.setGoodsPicUrl(goods.getCoverImg());
        result.setGoodsId(goodsId);
        result.setIsReduced(Integer.valueOf(0));
        long remainTime = this.getRemainTime(marketActivityOrders, marketActivity);
        result.setRemainingTime(remainTime + "");
        result.setStatus(Integer.valueOf(0));
        if (marketActivity == null) {
            log.info("\u6d3b\u52a8\u672a\u627e\u5230(\u6216\u6d3b\u52a8\u72b6\u6001\u4e3a\u5173\u95ed)_\u6d3b\u52a8\u7f16\u7801:[{}]", (Object)mao.getActivityNo());
            throw new CustomException("\u6d3b\u52a8\u672a\u627e\u5230(\u6216\u5df2\u5173\u95ed)");
        }
        List friendsAssistList = this.getFriendsAssistList(marketActivityOrders);
        if (!CollectionUtils.isEmpty((Collection)friendsAssistList) && friendsAssistList.stream().anyMatch(e -> e.getOpenId().equals(openId))) {
            result.setActivityStatusDesc("\u5df2\u5e2e\u52a9\u597d\u53cb\u780d\u4ef7\uff0c\u4f60\u4e5f\u53bb\u53c2\u4e0e\u780d\u4ef7\u5427");
            result.setIsReduced(Integer.valueOf(1));
            result.setRemainingTime(null);
            return result;
        }
        if (DateUtils.addHours((Date)marketActivityOrders.getGmtCreate(), (int)marketActivity.getActivityTermValidity()).before(new Date())) {
            result.setActivityStatusDesc("\u672a\u572824\u5c0f\u65f6\u5185\u652f\u4ed8\uff0c\u780d\u4ef7\u5df2\u8fc7\u671f");
            result.setStatus(Integer.valueOf(1));
            result.setRemainingTime(null);
            return result;
        }
        if ("2".equals(marketActivityOrders.getOrdersStatus())) {
            result.setStatus(Integer.valueOf(2));
            return result;
        }
        return this.getFriendsReduceDto(result, goods, marketActivity, friendsAssistList, marketActivityGoods);
    }

    public FriendsReduceDto queryWithFriendsInfo(String userNo, String activityOrdersNo, String showGoodsId, String showSkuNo, Integer merchantId, String openId) {
        FriendsReduceDto result = new FriendsReduceDto();
        MarketActivityOrders mao = new MarketActivityOrders();
        mao.setActivityOrdersNo(activityOrdersNo);
        mao = (MarketActivityOrders)this.marketActivityOrdersMapper.selectOne((Object)mao);
        result.setReducedStatus(Integer.valueOf(0));
        if (mao == null) {
            log.info("\u672a\u627e\u5230\u8be5\u8425\u9500\u8ba2\u5355\uff0c\u5165\u53c2\u8425\u9500\u8ba2\u5355\u53f7:[{}]", (Object)activityOrdersNo);
            throw new CustomException("\u672a\u627e\u5230\u8be5\u8425\u9500\u8ba2\u5355");
        }
        MarketActivity marketActivity = new MarketActivity();
        marketActivity.setActivityNo(mao.getActivityNo());
        marketActivity.setActivityStatus(Boolean.valueOf(true));
        marketActivity = (MarketActivity)this.marketActivityMapper.selectOne((Object)marketActivity);
        Goods goods = this.goodsMapper.selectById(Integer.valueOf(Integer.parseInt(showGoodsId)));
        List desc = this.marketActivityOrdersMapper.selectAvailbleOrdersByRule(userNo, merchantId);
        result.setStatus(Integer.valueOf(0));
        desc = desc.stream().filter(e -> e.getActivityOrderNo().equals(activityOrdersNo) && e.getGoodsId().equals(showGoodsId)).collect(Collectors.toList());
        MarketActivityGoods real = this.marketActivityOrdersMapper.selectOrdersAndSkuInfo(activityOrdersNo, showGoodsId);
        if (desc == null || CollectionUtils.isEmpty(desc)) {
            log.info("\u672a\u627e\u5230\u8425\u9500\u5546\u54c1\u8bb0\u5f55\uff0c\u8425\u9500\u8ba2\u5355\u53f7:[{}]", (Object)mao.getActivityOrdersNo());
            return null;
        }
        BeanUtils.copyProperties(desc.get(0), (Object)result);
        result.setSalePrice(real.getPrice());
        if (marketActivity.getActivityEndTime().before(new Date())) {
            result.setActivityStatusDesc("\u6d3b\u52a8\u5df2\u8fc7\u671f\uff0c\u7acb\u5373\u67e5\u770b\u5176\u4ed6\u6d3b\u52a8");
            return result;
        }
        List friendsAssistList = this.getFriendsAssistList(mao);
        if (DateUtils.addHours((Date)mao.getGmtCreate(), (int)marketActivity.getActivityTermValidity()).before(new Date())) {
            result.setActivityStatusDesc("\u672a\u572824\u5c0f\u65f6\u5185\u652f\u4ed8\uff0c\u780d\u4ef7\u5df2\u8fc7\u671f");
            result.setStatus(Integer.valueOf(2));
            return result;
        }
        FriendsReduceDto friendsReduceDto = this.getFriendsReduceDto(result, goods, marketActivity, friendsAssistList, real);
        long remainTime = this.getRemainTime(mao, marketActivity);
        result.setRemainingTime(remainTime + "");
        if (remainTime < 0L) {
            result.setStatus(Integer.valueOf(2));
            result.setRemainingTime(null);
        }
        if (this.verifyCanPay((MarketActivityGoods)desc.get(0), friendsAssistList, real)) {
            result.setActivityStatusDesc("\u5df2\u780d" + friendsReduceDto.getAlreadyReduce() + "\u5143\uff0c\u4e0d\u80fd\u518d\u780d\u4e86\u54e6\uff0c\u8bf7\u652f\u4ed8\u5269\u4f59\u91d1\u989d\u8fd8\u9700\u652f\u4ed8" + friendsReduceDto.getSalePrice().subtract(BigDecimal.valueOf(Double.parseDouble(friendsReduceDto.getAlreadyReduce()))) + "\u5143");
            result.setStatus(Integer.valueOf(3));
            return result;
        }
        result.setActivityStatusDesc("\u5df2\u780d" + friendsReduceDto.getAlreadyReduce() + "\u5143\uff0c\u8fd8\u53ef\u780d" + friendsReduceDto.getCanReducePrice() + "\u5143");
        result.setGoodsSku(mao.getGoodsSkuNo());
        result.setGoodsId(showGoodsId);
        result.setMerchantId(((MarketActivityGoods)desc.get(0)).getMerchantId());
        if (!StringUtils.isEmpty((Object)mao.getOrdersNo())) {
            log.info("\u8be5\u8425\u9500\u8ba2\u5355\u5df2\u7ecf\u652f\u4ed8\u8fc7:[{}]", (Object)activityOrdersNo);
            result.setStatus(Integer.valueOf(5));
        }
        return friendsReduceDto;
    }

    private long getRemainTime(MarketActivityOrders mao, MarketActivity marketActivity) {
        long time = DateUtils.addHours((Date)mao.getGmtCreate(), (int)marketActivity.getActivityTermValidity()).getTime();
        return time - new Date().getTime();
    }

    @Transactional
    public String addMarketActivityOrders(String userNo, String skuNo, String activityNo, Integer goodsId) {
        Date current = new Date();
        MarketActivity ma = this.getMarketActivity(activityNo);
        if (!this.checkActivityTimeValid(ma, current)) {
            log.info("\u6d3b\u52a8\u4e0d\u5728\u6709\u6548\u671f\u5185\u6216\u6d3b\u52a8\u4e0d\u5b58\u5728_\u6d3b\u52a8\u7f16\u53f7:[{}]", (Object)activityNo);
            return "0";
        }
        Goods goods = this.goodsMapper.selectById(goodsId);
        GoodsSkuDetail goodsSkuDetail = new GoodsSkuDetail();
        goodsSkuDetail.setGoodsId(goodsId);
        goodsSkuDetail.setSkuNo(skuNo);
        goodsSkuDetail = (GoodsSkuDetail)this.goodsSkuDetailMapper.selectOne((Object)goodsSkuDetail);
        if (goodsSkuDetail == null) {
            throw new CustomException("\u5546\u54c1sku\u6570\u636e\u672a\u627e\u5230,skuNo:" + skuNo + ",goodsId:" + goodsId);
        }
        MarketActivityOrders mao = new MarketActivityOrders();
        mao.setLaunchUserNo(userNo);
        mao.setActivityNo(activityNo);
        mao.setGoodsNo(goods.getGoodsNo());
        mao.setOrdersStatus("0");
        mao.setTradeStatus("0");
        List select = this.marketActivityOrdersMapper.select((Object)mao);
        if (!CollectionUtils.isEmpty((Collection)select)) {
            log.info("\u53d1\u8d77\u4eba:[{}],\u5df2\u7ecf\u53c2\u52a0\u8fc7\u6d3b\u52a8:[{}]", (Object)userNo, (Object)activityNo);
            return "0";
        }
        if (!this.checkActivityStockValid(goods, goodsSkuDetail)) {
            log.info("\u6d3b\u52a8\u5e93\u5b58\u4e0d\u8db3_skuNo:[{}]_\u6d3b\u52a8\u7f16\u53f7:[{}]", (Object)skuNo, (Object)activityNo);
            return "0";
        }
        List goodsDetail = this.marketActivityGoodsMapper.getGoodsDetail(null, skuNo, goods.getGoodsNo(), null, null);
        if (CollectionUtils.isEmpty((Collection)goodsDetail)) {
            log.info("\u67e5\u8be2\u4e0d\u5230\u6d3b\u52a8\u5546\u54c1\u4fe1\u606f_skuNO:[{}]", (Object)skuNo);
            return "0";
        }
        UUID uuid = UUID.randomUUID();
        String s = uuid.toString();
        List list = this.calcPreHandlePriceArray(activityNo, goodsDetail);
        if (!this.prePriceSetInRedis(list, s)) {
            return "0";
        }
        this.getSkockNumSetInRedis(skuNo, goodsId, activityNo);
        this.saveActivityOrders(userNo, (MarketActivityGoods)goodsDetail.get(0), activityNo, list, uuid);
        this.scheduledThreadPoolExecutor.schedule(() -> {
            log.info("close order {} schedule start ...", (Object)s);
            this.cancelReducePrice(userNo, activityNo, s, goodsId);
        }, (long)ma.getActivityTermValidity().intValue(), TimeUnit.HOURS);
        return s;
    }

    private void cancelReducePrice(String userNo, String activityNo, String activityOrdersNo, Integer goodsId) {
        StopWatch sw = new StopWatch("\u780d\u4ef7\u6d3b\u52a8\u8ba2\u5355:" + activityOrdersNo);
        sw.start();
        MarketActivityOrders mao = new MarketActivityOrders();
        mao.setActivityOrdersNo(activityOrdersNo);
        mao.setActivityNo(activityNo);
        mao.setLaunchUserNo(userNo);
        mao.setTradeStatus("0");
        mao = (MarketActivityOrders)this.marketActivityOrdersMapper.selectOne((Object)mao);
        if (mao == null) {
            return;
        }
        mao.setOrdersStatus("2");
        mao.setGmtModified(new Date());
        int i = this.marketActivityOrdersMapper.updateByPrimaryKeySelective((Object)mao);
        this.reverseFreezeStock(goodsId, mao.getGoodsSkuNo(), mao.getActivityOrdersNo());
        sw.stop();
        log.info("\u5b9a\u65f6\u4efb\u52a1:-------->" + sw.getId() + ",\u6301\u7eed\u65f6\u95f4:" + sw.getTotalTimeMillis());
    }

    private boolean checkActivityOrdersInProcessing(String userNo, String activityNo, String goodsNo, String activityOrdersNo) {
        MarketActivityOrders mao = new MarketActivityOrders();
        mao.setLaunchUserNo(userNo);
        mao.setGoodsNo(goodsNo);
        mao.setOrdersStatus("0");
        mao.setTradeStatus("0");
        mao.setActivityNo(activityNo);
        mao.setActivityOrdersNo(activityOrdersNo);
        List select = this.marketActivityOrdersMapper.select((Object)mao);
        if (CollectionUtils.isEmpty((Collection)select)) {
            throw new CustomException("\u672a\u627e\u5230\u8be5\u8425\u9500\u8ba2\u5355" + activityOrdersNo);
        }
        log.info("confirm ==\u300b \u67e5\u8be2\u6d3b\u52a8\u8ba2\u5355\u8868\u7ed3\u679c:[{}]", JSON.toJSON((Object)select));
        return StringUtils.isEmpty((Object)((MarketActivityOrders)select.get(0)).getOrdersNo());
    }

    public int addOrders(String userNo, String skuNo, String activityNo, String goodsNo) {
        MarketActivityOrders mao = new MarketActivityOrders();
        mao.setActivityNo(activityNo);
        mao.setGoodsSkuNo(skuNo);
        mao.setLaunchUserNo(userNo);
        mao.setOrdersStatus("0");
        mao = (MarketActivityOrders)this.marketActivityOrdersMapper.selectOne((Object)mao);
        if (mao == null) {
            log.error("\u8ba2\u5355\u4e0d\u5b58\u5728_\u6d3b\u52a8\u7f16\u53f7:[{}],skuNo:[{}],\u53d1\u8d77\u4eba:[{}]", new Object[]{activityNo, skuNo, userNo});
            throw new CustomException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        MarketActivityGoods mag = new MarketActivityGoods();
        mag.setSkuNo(skuNo);
        mag = (MarketActivityGoods)this.marketActivityGoodsMapper.selectOne((Object)mag);
        BargainPlayers bp = new BargainPlayers();
        bp.setActivityOrdersNo(mao.getActivityOrdersNo());
        List select = this.bargainPlayersMapper.select((Object)bp);
        BigDecimal reduce = select.stream().map(e -> e.getAmount()).reduce(BigDecimal.ZERO, (x, y) -> y.add((BigDecimal)x));
        return this.saveInOrders(mag, reduce);
    }

    public Orders confirm(Orders orders) {
        this.checkUserInfo(orders);
        this.checkActivityOrdersNo(orders);
        this.checkActivityNo(orders.getActivityNo());
        this.checkGoodsItem(orders.getItems());
        orders.getItems().stream().forEach(e -> e.setMerchantId(orders.getMerchantId()));
        if (!this.checkActivityOrdersInProcessing(orders.getUserNo(), orders.getActivityNo(), ((OrderItems)orders.getItems().get(0)).getGoodsNo(), orders.getActivityOrdersNo())) {
            throw new CustomException("\u4e0d\u80fd\u91cd\u590d\u53d1\u8d77");
        }
        Goods customGood = this.convertOrderItemsToGoods(orders.getItems());
        List customSkuInfo = this.convertOrderItemsToSkuInfo(orders.getItems(), orders.getActivityOrdersNo());
        Goods dbGoods = this.checkAndGetGoodsInfo(customGood);
        List readyCheckGoods = customSkuInfo.stream().map(e -> {
            Goods goods = new Goods();
            BeanUtils.copyProperties((Object)e, (Object)goods);
            goods.setId(e.getGoodsId());
            return goods;
        }).collect(Collectors.toList());
        BargainPlayers bp = new BargainPlayers();
        bp.setActivityOrdersNo(orders.getActivityOrdersNo());
        List select = this.bargainPlayersMapper.select((Object)bp);
        BigDecimal lastPay = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)select)) {
            BigDecimal reduce = select.stream().map(e -> e.getAmount()).reduce(BigDecimal.ZERO, (x, y) -> y.add((BigDecimal)x));
            lastPay = reduce == null ? BigDecimal.ZERO : reduce;
            lastPay = ((GoodsSkuDetail)customSkuInfo.get(0)).getSalesPrice().subtract(lastPay);
            if (reduce.compareTo(BigDecimal.ZERO) < 0) {
                log.info("\u521b\u5efa\u8ba2\u5355\u5931\u8d25:REASON_\u652f\u4ed8\u4ef7\u683c\u5c0f\u4e8e0,\u5f53\u524d\u8ba1\u7b97\u4ef7\u683c\u4e3a:[{}]", (Object)lastPay);
                throw new CustomException("\u521b\u5efa\u8ba2\u5355\u5931\u8d25:REASON_\u652f\u4ed8\u4ef7\u683c\u5c0f\u4e8e0");
            }
            orders.setPayAmount(lastPay);
        } else {
            orders.setPayAmount(((GoodsSkuDetail)customSkuInfo.get(0)).getSalesPrice());
        }
        log.info("\u652f\u4ed8\u4ef7\u683c:[{}]", (Object)orders.getPayAmount());
        for (Goods readyCheckGood : readyCheckGoods) {
            GoodsSkuDetail goodsSkuDetail = new GoodsSkuDetail();
            goodsSkuDetail.setGoodsId(readyCheckGood.getId());
            goodsSkuDetail.setSkuNo(readyCheckGood.getSkuNo());
            if (this.checkActivityStockValid(readyCheckGood, goodsSkuDetail = (GoodsSkuDetail)this.goodsSkuDetailMapper.selectOne((Object)goodsSkuDetail))) continue;
            throw new CustomException("\u5e93\u5b58\u4e0d\u8db3_SKU:" + readyCheckGood.getSkuNo());
        }
        MarketActivityGoods mag = new MarketActivityGoods();
        mag.setGoodsNo(((GoodsSkuDetail)customSkuInfo.get(0)).getGoodsNo());
        mag.setMarketActivityNo(orders.getActivityNo());
        mag.setSkuNo(((GoodsSkuDetail)customSkuInfo.get(0)).getSkuNo() == null ? ((GoodsSkuDetail)customSkuInfo.get(0)).getGoodsNo() : ((GoodsSkuDetail)customSkuInfo.get(0)).getSkuNo());
        mag = (MarketActivityGoods)this.marketActivityGoodsMapper.selectOne((Object)mag);
        BigDecimal lowPrice = mag.getAmount();
        if (orders.getPayAmount().compareTo(lowPrice) < 0) {
            log.info("\u521b\u5efa\u8ba2\u5355\u5931\u8d25:REASON_\u652f\u4ed8\u4ef7\u683c\u5c0f\u4e8e\u4f4e\u4ef7,\u5f53\u524d\u8ba1\u7b97\u4ef7\u683c\u4e3a:[{}]", (Object)((GoodsSkuDetail)customSkuInfo.get(0)).getPayAmount());
            throw new CustomException("\u521b\u5efa\u8ba2\u5355\u5931\u8d25:REASON_\u652f\u4ed8\u4ef7\u683c\u5c0f\u4e8e\u4f4e\u4ef7");
        }
        log.info("\u521b\u5efa\u8ba2\u5355\u7684\u5546\u54c1sku\u4ef7\u683c:[{}],\u5546\u54c1\u5e95\u4ef7:[{}],\u652f\u4ed8\u91d1\u989d:[{}]", (Object)((GoodsSkuDetail)customSkuInfo.get(0)).getSalesPrice(), (Object)mag.getAmount());
        log.info("\u780d\u4ef7 confirm orders => {}", (Object)JSONObject.toJSONString((Object)orders));
        customSkuInfo.forEach(sku -> {
            sku.setGoodsName(dbGoods.getGoodsName());
            sku.setGoodsNo(dbGoods.getGoodsNo());
            orders.getItems().forEach(orderItems -> {
                if (orderItems.getGoodsSkuNo().equals(sku.getSkuNo())) {
                    orderItems.setGoodsImg(sku.getSkuImg());
                    orderItems.setGoodsNo(sku.getGoodsNo());
                    orderItems.setMarketPrice(sku.getMarketPrice());
                    orderItems.setSalePrice(sku.getSalesPrice());
                    orderItems.setItemsAmount(((GoodsSkuDetail)customSkuInfo.get(0)).getPayAmount());
                    orderItems.setItemsPayAmount(((GoodsSkuDetail)customSkuInfo.get(0)).getPayAmount());
                    orderItems.setWepayAmount(((GoodsSkuDetail)customSkuInfo.get(0)).getPayAmount());
                    orderItems.setItemsActiveDeduction(BigDecimal.ZERO);
                    orderItems.setItemsPointDeduction(BigDecimal.ZERO);
                }
            });
        });
        return orders;
    }

    private void checkActivityOrdersNo(Orders orders) {
        if (StringUtils.isEmpty((Object)orders.getActivityOrdersNo())) {
            throw new IllegalArgumentException("\u6d3b\u52a8\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a");
        }
    }

    @Transactional
    public Integer addOrder(Orders orders) {
        log.info("\u8ba2\u5355\u5165\u5e93\u7684\u53c2\u6570======> {}", (Object)JSONObject.toJSONString((Object)orders));
        String key = String.format(USER_ADD_ORDER_KEY, orders.getUserId());
        if (!this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)"").booleanValue()) {
            log.info("\u7528\u6237ID {} \u4e0b\u5355\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41", (Object)orders.getUserId());
            throw new CustomException("\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41");
        }
        this.stringRedisTemplate.expire((Object)key, 10L, TimeUnit.SECONDS);
        this.checkOrdersShippingInfo(orders);
        BigDecimal payAmount = orders.getPayAmount();
        Orders newOrder = this.confirm(orders);
        log.info("\u521b\u5efa\u652f\u4ed8\u4ef7\u683c:[{}]", JSONObject.toJSON((Object)orders));
        newOrder = OrdersBuilder.getBuilder((Orders)newOrder).build();
        log.info("\u521b\u5efa\u652f\u4ed8\u4ef7\u683c1:[{}]", JSONObject.toJSON((Object)newOrder));
        for (OrderItems items : newOrder.getItems()) {
            Example example = new Example(MarketActivityGoods.class);
            example.createCriteria().andEqualTo("marketActivityNo", (Object)newOrder.getActivityNo()).andEqualTo("goodsNo", (Object)items.getGoodsNo());
            List marketActivityGoods = this.marketActivityGoodsMapper.selectByExample((Object)example);
            marketActivityGoods = marketActivityGoods.stream().filter(e -> e.getSkuNo().equals(((OrderItems)orders.getItems().get(0)).getGoodsSkuNo()) && e.getGoodsNo().equals(items.getGoodsNo())).collect(Collectors.toList());
            if (marketActivityGoods == null) {
                throw new CustomException("\u6b64\u5546\u54c1\u4e0d\u5b58\u5728\u4e8e\u6d3b\u52a8");
            }
            items.setItemsPayAmount(payAmount);
            items.setItemsAmount(payAmount);
        }
        orders.setPayAmount(payAmount);
        newOrder.setOrdersActivityType("1");
        log.info("insert order info...{}", (Object)JSONObject.toJSONString((Object)newOrder));
        this.ordersMapper.insertSelective((Object)newOrder);
        for (OrderItems orderItems : newOrder.getItems()) {
            orderItems.setOrderId(newOrder.getId());
            orderItems.setOrderNo(newOrder.getOrderNo());
        }
        this.orderItemsMapper.insertList(newOrder.getItems());
        String launchUserNo = "";
        if (StringUtils.isEmpty((Object)newOrder.getLaunchUserNo())) {
            launchUserNo = newOrder.getUserNo();
        }
        String activityOrdersNo = "";
        MarketActivityOrders mao = new MarketActivityOrders();
        mao.setActivityOrdersNo(newOrder.getActivityOrdersNo());
        mao.setActivityOrdersType("0");
        mao.setOrdersStatus("0");
        mao = (MarketActivityOrders)this.marketActivityOrdersMapper.selectOne((Object)mao);
        mao.setOrdersNo(newOrder.getOrderNo());
        this.marketActivityOrdersMapper.updateByPrimaryKeySelective((Object)mao);
        String activityOrderNo = activityOrdersNo;
        log.info("insert order successfully ! ");
        Config config = new Config();
        config.setMerchantId(newOrder.getMerchantId());
        Config oneByCondition = (Config)this.configService.findOneByCondition((Serializable)config);
        String appid = newOrder.getAppid();
        Integer userId = newOrder.getUserId();
        Integer orderId = newOrder.getId();
        Integer goodsId = ((OrderItems)newOrder.getItems().get(0)).getGoodsId();
        String goodsSkuNo = ((OrderItems)newOrder.getItems().get(0)).getGoodsSkuNo();
        this.scheduledThreadPoolExecutor.schedule(() -> {
            log.info("close order {} schedule start ...", (Object)orders.getOrderNo());
            this.reverseFreezeStock(goodsId, goodsSkuNo, activityOrderNo);
            this.ordersService.cancel(appid, userId, orderId);
        }, (long)oneByCondition.getAwaitOrderPayMinute().intValue(), TimeUnit.MINUTES);
        return newOrder.getId();
    }

    private void reverseFreezeStock(Integer goodsId, String goodsSkuNo, String activityOrdersNo) {
        log.info("\u780d\u4ef7\u53d6\u6d88\u8425\u9500\u8ba2\u5355\u63a5\u53e3\u8fdb\u5165\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
        String key = String.format(ORDER_CLOSE_KEY, activityOrdersNo);
        ValueOperations ops = this.stringRedisTemplate.opsForValue();
        if (!ops.setIfAbsent((Object)key, (Object)"").booleanValue()) {
            log.warn("\u53d6\u6d88\u8425\u9500\u8ba2\u5355{},\u91cd\u590d\u7684\u8bf7\u6c42", (Object)activityOrdersNo);
            return;
        }
        this.stringRedisTemplate.expire((Object)key, 7L, TimeUnit.DAYS);
        String freezeStock = REDIS_FREEZE_STOCK_KEY + goodsId + "-" + goodsSkuNo;
        if (this.stringRedisTemplate.opsForValue().getOperations().hasKey((Object)freezeStock).booleanValue()) {
            String s = (String)this.stringRedisTemplate.opsForValue().get((Object)freezeStock);
            if (Integer.parseInt(s) <= 0) {
                throw new CustomException("\u51bb\u7ed3\u5e93\u5b58\u4e0d\u8db3:goodsId" + goodsId + ",goodsSkuNo:" + goodsSkuNo);
            }
            ops.increment((Object)freezeStock, -1L);
        }
    }

    private Goods convertOrderItemsToGoods(List<OrderItems> orderItems) {
        Goods goods = new Goods();
        for (OrderItems orderItem : orderItems) {
            goods.setId(orderItem.getGoodsId());
            goods.setMerchantId(orderItem.getMerchantId());
            goods.setGoodsName(orderItem.getGoodsName());
            goods.setSpecNames(orderItem.getGoodsName());
            goods.setId(orderItem.getGoodsId());
            Integer quantity = orderItem.getSaleQuantity();
            goods.setCount(quantity);
            goods.setSkuNo(orderItem.getGoodsSkuNo());
        }
        return goods;
    }

    private int saveInOrders(MarketActivityGoods select, BigDecimal reduceDPrice) {
        Orders orders = new Orders();
        if (reduceDPrice == null) {
            orders.setPayAmount(select.getPrice());
        } else {
            orders.setPayAmount(select.getPrice().subtract(reduceDPrice).setScale(2, 4));
        }
        int useGeneratedKeys = this.ordersMapper.insertUseGeneratedKeys((Object)orders);
        return useGeneratedKeys;
    }

    private Goods checkAndGetGoodsInfo(Goods customGoodsList) {
        Integer merchantId = null;
        ArrayList<Integer> goodsIdList = new ArrayList<Integer>();
        goodsIdList.add(customGoodsList.getId());
        merchantId = customGoodsList.getMerchantId();
        Goods queryCondition = new Goods();
        queryCondition.setIdList(goodsIdList);
        queryCondition.setMerchantId(merchantId);
        List dbGoodsInfo = this.goodsService.findByCondition((Serializable)queryCondition);
        if (dbGoodsInfo == null) {
            throw new CustomException("\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        Goods extract = this.extractSkuInfoFromSkuList(customGoodsList, dbGoodsInfo);
        if (extract == null) {
            throw new CustomException("\u5546\u54c1[" + customGoodsList.getGoodsName() + "]\u4e0d\u5b58\u5728");
        }
        if (!extract.getIsShelved().booleanValue()) {
            throw new CustomException("\u5546\u54c1[" + customGoodsList.getGoodsName() + "]\u5df2\u4e0b\u67b6");
        }
        if (!extract.getLimitation().equals(0) && extract.getLimitation().compareTo(customGoodsList.getCount()) < 0) {
            throw new CustomException("\u5546\u54c1[" + customGoodsList.getGoodsName() + "]\u6bcf\u5355\u9650\u8d2d" + extract.getLimitation() + "\u4ef6");
        }
        return (Goods)dbGoodsInfo.get(0);
    }

    private Goods extractSkuInfoFromSkuList(Goods qg, List<Goods> queryResultGoods) {
        for (Goods goods : queryResultGoods) {
            if (!goods.getId().equals(qg.getId())) continue;
            return goods;
        }
        return null;
    }

    private boolean checkExistInOrders(String userNo, String skuNo, List<MarketActivityGoods> activityNos, MarketActivity ma) {
        Date current = new Date();
        MarketActivityGoods selected = null;
        for (MarketActivityGoods activityNo : activityNos) {
            if (!skuNo.equals(activityNo.getSkuNo())) continue;
            selected = activityNo;
            break;
        }
        String goodsNo = selected.getGoodsNo();
        if (ma.getActivityBeginTime().before(current) && ma.getActivityEndTime().after(current)) {
            MarketActivityOrders mao = new MarketActivityOrders();
            mao.setGoodsNo(goodsNo);
            mao.setActivityNo(ma.getActivityNo());
            mao.setLaunchUserNo(userNo);
            mao.setOrdersStatus("0");
            List select = this.marketActivityOrdersMapper.select((Object)mao);
            return CollectionUtils.isEmpty((Collection)select);
        }
        return false;
    }

    @Transactional
    public int saveActivityOrders(String userNo, MarketActivityGoods goodsDetail, String activityNo, List<String> list, UUID uuid) {
        MarketActivityOrders mao = new MarketActivityOrders();
        mao.setOrdersStatus("0");
        mao.setLaunchUserNo(userNo);
        mao.setActivityNo(activityNo);
        mao.setActivityOrdersType("0");
        mao.setGmtCreate(new Date());
        mao.setGmtModified(mao.getGmtCreate());
        mao.setGoodsName(goodsDetail.getGoodsName());
        mao.setGoodsNo(goodsDetail.getGoodsNo());
        mao.setGoodsSkuNo(goodsDetail.getSkuNo());
        mao.setGoodsSkuName(goodsDetail.getGoodSkuName());
        mao.setActivityOrdersNo(uuid.toString());
        mao.setUserNo(userNo);
        mao.setOrdersStatus("0");
        mao.setBargainBudgetAmount(list.toString());
        int i = 0;
        try {
            i = this.marketActivityOrdersMapper.insertSelective((Object)mao);
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
        return i;
    }

    private void getSkockNumSetInRedis(String skuNo, Integer goodsId, String activityNo) {
        String key = REDIS_FREEZE_STOCK_KEY + goodsId + "-" + skuNo;
        ValueOperations ops = this.stringRedisTemplate.opsForValue();
        if (ops.getOperations().hasKey((Object)key).booleanValue()) {
            ops.increment((Object)key, 1L);
        } else {
            ops.set((Object)key, (Object)"1");
        }
    }

    private boolean prePriceSetInRedis(List<String> list, String uuid) {
        String key = REDIS_PRECALULATE_PRICE_ARRAY_KEY + uuid;
        ListOperations ops = this.stringRedisTemplate.opsForList();
        if (ops.getOperations().hasKey((Object)key).booleanValue()) {
            log.info("redis\u4e2d\u5df2\u7ecf\u5b58\u5728\u8be5key_\u7684\u6d3b\u52a8\u7f16\u53f7:[{}]", (Object)uuid);
            return false;
        }
        ops.leftPushAll((Object)key, list);
        return true;
    }

    private List<String> calcPreHandlePriceArray(String activityNo, List<MarketActivityGoods> goodsDetail) {
        MarketActivityGoods marketActivityGoods = goodsDetail.get(0);
        BigDecimal canReducePrice = marketActivityGoods.getPrice().subtract(marketActivityGoods.getAmount()).setScale(2, 4);
        MarketActivity marketActivity = this.getMarketActivity(activityNo);
        return this.doCalHandler(canReducePrice, marketActivity);
    }

    private List<String> doCalHandler(BigDecimal canReducePrice, MarketActivity marketActivity) {
        ArrayList<String> result;
        double v = canReducePrice.doubleValue() / (double)marketActivity.getActivityPersonNum().intValue();
        if ("1".equals(marketActivity.getBargainAmoutType())) {
            result = new ArrayList(marketActivity.getActivityPersonNum());
            if (marketActivity.getActivityPersonNum() <= 1) {
                result.add(canReducePrice.toString());
                return result;
            }
            double renshu = (double)marketActivity.getActivityPersonNum().intValue() - 1.0;
            BigDecimal frontManPrice = BigDecimal.valueOf(v).setScale(2, 4).multiply(BigDecimal.valueOf(renshu));
            BigDecimal lastManPrice = canReducePrice.subtract(frontManPrice);
            for (int i = 0; i < marketActivity.getActivityPersonNum() - 1; ++i) {
                result.add(BigDecimal.valueOf(v).setScale(2, 4).toString());
            }
            result.add(lastManPrice.toString());
        } else {
            result = this.getReduceList(canReducePrice, marketActivity.getActivityPersonNum().intValue(), BigDecimal.ZERO, BigDecimal.valueOf(v * 2.0));
        }
        return result;
    }

    public List<String> getReduceList(BigDecimal totalReduce, int totalReduceTimes, BigDecimal minReduce, BigDecimal maxReduce) {
        ArrayList<String> ret = new ArrayList<String>();
        Random rand = new Random();
        double[] vs = new double[totalReduceTimes];
        double total = 0.0;
        for (int i = 0; i < totalReduceTimes; ++i) {
            double v;
            do {
                v = rand.nextDouble() * totalReduce.doubleValue();
            } while (!(maxReduce.doubleValue() > v) || !(v > minReduce.doubleValue()));
            vs[i] = v;
            total += v;
        }
        double minReduceVal = minReduce.doubleValue();
        BigDecimal t = BigDecimal.valueOf(0.0);
        for (int i = 0; i < totalReduceTimes - 1; ++i) {
            double vss = vs[i] / total * (totalReduce.doubleValue() - minReduceVal * (double)totalReduceTimes) + minReduceVal;
            BigDecimal reduce = BigDecimal.valueOf(vss).setScale(2, RoundingMode.HALF_EVEN);
            t = t.add(reduce);
            ret.add(reduce.toString());
        }
        ret.add(totalReduce.subtract(t).setScale(2, RoundingMode.HALF_EVEN).toString());
        return ret;
    }

    private boolean checkActivityStockValid(Goods goods, GoodsSkuDetail skuNo) {
        String key = REDIS_FREEZE_STOCK_KEY + goods.getId() + "-" + skuNo.getSkuNo();
        try {
            ValueOperations ops = this.stringRedisTemplate.opsForValue();
            if (ops.getOperations().hasKey((Object)key).booleanValue()) {
                String s = (String)ops.get((Object)key);
                return skuNo != null && skuNo.getStock() - Integer.parseInt(s) >= 0;
            }
            log.error("\u521b\u5efa\u8425\u9500\u8ba2\u5355\u5931\u8d25:REASON:redis\u65e0\u5bf9\u5e94key:goodsId[{}],skuNo:[{}]", (Object)goods.getId(), (Object)skuNo.getSkuNo());
        }
        catch (NumberFormatException e) {
            log.error(e.getMessage());
        }
        return true;
    }

    private boolean checkActivityTimeValid(MarketActivity ma, Date current) {
        return ma != null && !ma.getActivityBeginTime().after(current) && !ma.getActivityEndTime().before(current);
    }

    private MarketActivity getMarketActivity(String activityNo) {
        MarketActivity ma = new MarketActivity();
        ma.setActivityStatus(Boolean.valueOf(true));
        ma.setActivityNo(activityNo);
        ma.setActivityType("0");
        ma = (MarketActivity)this.marketActivityMapper.selectOne((Object)ma);
        return ma;
    }

    private FriendsReduceDto getFriendsReduceDto(FriendsReduceDto result, Goods goods, MarketActivity marketActivity, List<BargainPlayers> friendsAssistList, MarketActivityGoods real) {
        if (CollectionUtils.isEmpty(friendsAssistList)) {
            result.setAssistsLists(null);
            result.setProgressBar("0");
            result.setAlreadyReduce("0");
            result.setCanReducePrice(real.getPrice().subtract(real.getAmount()).setScale(2));
            result.setPayAmount(real.getPrice());
            return result;
        }
        result.setReducedStatus(Integer.valueOf(1));
        BigDecimal reduced = friendsAssistList.stream().map(e -> e.getAmount()).reduce(BigDecimal.ZERO, (x, y) -> y.add((BigDecimal)x));
        result.setAssistsLists(friendsAssistList);
        result.setProgressBar(ProcessBarUtil.getProcess((int)marketActivity.getActivityPersonNum(), (int)friendsAssistList.size()));
        result.setCanReducePrice(goods.getSalePrice().subtract(real.getAmount()).subtract(reduced).setScale(2));
        result.setAlreadyReduce(reduced.toString());
        result.setStock(real.getStock());
        result.setGoodsSkuName(real.getGoodSkuName());
        result.setGoodsName(real.getGoodsName());
        result.setPayAmount(result.getSalePrice().subtract(reduced));
        result.setRemainingTime("");
        return result;
    }

    private List<BargainPlayers> getFriendsAssistList(MarketActivityOrders marketActivityOrders) {
        BargainPlayers bp = new BargainPlayers();
        bp.setActivityOrdersNo(marketActivityOrders.getActivityOrdersNo());
        return this.bargainPlayersMapper.select((Object)bp);
    }

    public MarketActivityGoods chooseSkuByRule(List<MarketActivityGoods> select, String goodsId) {
        List collect = select.stream().map(e -> this.getGoodsSku(e, goodsId)).filter(e -> e != null).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return null;
        }
        GoodsSkuDetail goodsSkuDetail = collect.stream().min(Comparator.comparing(GoodsSkuDetail::getSalesPrice)).get();
        List collect1 = collect.stream().filter(e -> e.getSalesPrice().equals(goodsSkuDetail.getSalesPrice())).collect(Collectors.toList());
        if (collect1.size() > 1) {
            return this.compareLowprice(collect1, select);
        }
        return select.get(0);
    }

    private GoodsSkuDetail getGoodsSku(MarketActivityGoods selectedOne, String goodsId) {
        return this.goodsSkuDetailMapper.findByGoodsIdAndSkuNo(Integer.valueOf(Integer.parseInt(goodsId)), selectedOne.getSkuNo());
    }

    private MarketActivityGoods compareLowprice(List<GoodsSkuDetail> collect, List<MarketActivityGoods> select) {
        ArrayList<MarketActivityGoods> result = new ArrayList<MarketActivityGoods>();
        for (GoodsSkuDetail goodsSkuDetail : collect) {
            for (MarketActivityGoods marketActivityGoods : select) {
                if (!goodsSkuDetail.getSkuNo().equals(marketActivityGoods.getSkuNo())) continue;
                result.add(marketActivityGoods);
            }
        }
        MarketActivityGoods marketActivityGoods = result.stream().min(Comparator.comparing(MarketActivityGoods::getAmount)).get();
        List collect1 = result.stream().filter(e -> e.getAmount().equals(marketActivityGoods.getAmount())).collect(Collectors.toList());
        if (collect1.size() > 1) {
            return (MarketActivityGoods)collect1.get(0);
        }
        return marketActivityGoods;
    }

    private PageInfo<MyReducePriceDto> chooseMyReduceByRule(Date currentTime, PageInfo<MarketActivityGoods> pageInfo) {
        if (pageInfo == null && CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return null;
        }
        List list = pageInfo.getList();
        Date current = new Date();
        list = list.stream().filter(e -> !DateUtils.addHours((Date)e.getGmtCreate(), (int)e.getActivityTermValidity()).before(current) || !e.getActivityEndTime().before(current)).collect(Collectors.toList());
        List<Object> result = new ArrayList<MyReducePriceDto>();
        for (MarketActivityGoods mao : list) {
            result.add(this.chooseStepGetResult(currentTime, mao));
        }
        result = result.stream().distinct().collect(Collectors.toList());
        PageInfo pageResult = new PageInfo();
        BeanUtils.copyProperties(pageInfo, (Object)pageResult);
        pageResult.setList(result);
        return pageResult;
    }

    private MyReducePriceDto getMyReduceResult(MarketActivityGoods mao, int step, Date currentTime, List<BargainPlayers> select, MarketActivityGoods marketActivityGoods) {
        MyReducePriceDto result = new MyReducePriceDto();
        BigDecimal reduceTotalAmount = select.stream().map(e -> e.getAmount()).reduce(BigDecimal.ZERO, (x, y) -> y.add((BigDecimal)x));
        result.setAlreadyReduce("\u5df2\u780d" + reduceTotalAmount + "\u5143");
        Date date = DateUtils.addHours((Date)mao.getGmtCreate(), (int)mao.getActivityTermValidity());
        long remianTimeMills = date.getTime() - currentTime.getTime();
        List select1 = this.marketActivityGoodsMapper.getGoodsDetail(mao.getMarketActivityNo(), null, mao.getGoodsNo(), null, null);
        MarketActivityGoods show = this.chooseSkuByRule(select1, mao.getGoodsId());
        if (show == null) {
            result.setSalePrice(marketActivityGoods.getPrice());
            result.setShowSkuNo(marketActivityGoods.getSkuNo());
            result.setGoodsName(marketActivityGoods.getGoodsName());
        } else {
            result.setSalePrice(show.getPrice());
            result.setShowSkuNo(show.getSkuNo());
            result.setGoodsName(show.getGoodsName());
        }
        result.setGoodsSku(marketActivityGoods.getSkuNo());
        result.setMarketActivityNo(mao.getMarketActivityNo());
        result.setGoodsId(mao.getGoodsId());
        result.setStock(marketActivityGoods.getStock());
        result.setGoodsSkuName(mao.getGoodSkuName());
        result.setGoodsName(mao.getGoodsName());
        result.setMarketActivityOrdersNo(mao.getActivityOrderNo());
        result.setMerchantId(mao.getMerchantId());
        result.setGoodsPicUrl(mao.getGoodsPicUrl());
        if (step == 1) {
            result.setRemainingTime(remianTimeMills + "");
            result.setActivitySign(Integer.valueOf(1));
        } else if (step == 2) {
            result.setRemainingTime(null);
            result.setRemainingTime("\u780d\u4ef7\u5df2\u8fc7\u671f");
            result.setActivitySign(Integer.valueOf(2));
        } else {
            result.setRemainingTime(remianTimeMills + "");
            result.setAlreadyReduce("\u5df2\u780d" + reduceTotalAmount + "\u5143\u606d\u559c\u5df2\u780d\u5230\u6700\u4f4e\u4ef7");
            result.setActivitySign(Integer.valueOf(3));
        }
        return result;
    }

    private MyReducePriceDto chooseStepGetResult(Date currentTime, MarketActivityGoods mao) {
        BargainPlayers bp = new BargainPlayers();
        bp.setActivityOrdersNo(mao.getActivityOrderNo());
        MarketActivityGoods marketActivityGoods = this.marketActivityOrdersMapper.selectOrdersAndSkuInfo(mao.getActivityOrderNo(), mao.getGoodsId());
        List select = this.bargainPlayersMapper.select((Object)bp);
        int flag = 1;
        if (!"2".equals(mao.getOrdersStatus())) {
            if (!this.verifyTime(mao, currentTime)) {
                flag = 2;
            } else if (this.verifyCanPay(mao, select, marketActivityGoods)) {
                flag = 3;
            }
        } else {
            flag = 2;
        }
        return this.getMyReduceResult(mao, flag, currentTime, select, marketActivityGoods);
    }

    private boolean verifyCanPay(MarketActivityGoods mao, List<BargainPlayers> select, MarketActivityGoods marketActivityGoods) {
        if (CollectionUtils.isEmpty(select)) {
            return false;
        }
        if (select.size() >= mao.getActivityPersonNum()) {
            BigDecimal canRedeced;
            BigDecimal reduceTotalAmount = select.stream().map(e -> e.getAmount()).reduce(BigDecimal.ZERO, (x, y) -> y.add((BigDecimal)x));
            if (reduceTotalAmount.equals(canRedeced = marketActivityGoods.getPrice().subtract(marketActivityGoods.getAmount()))) {
                return true;
            }
            log.info("\u6821\u9a8c\u4ef7\u683c\u5f02\u5e38:\u603b\u5e2e\u780d\u4ef7\u989d:[{}],\u53ef\u780d\u91d1\u989d:[{}],\u8425\u9500\u8ba2\u5355\u7f16\u53f7:[{}]", new Object[]{reduceTotalAmount, canRedeced, mao.getActivityOrderNo()});
            throw new RuntimeException("\u5f85\u652f\u4ed8\uff1a\u780d\u4ef7\u4eba\u6570\u5df2\u6ee1\uff0c\u4ef7\u683c\u5f02\u5e38");
        }
        return false;
    }

    private boolean verifyTime(MarketActivityGoods mao, Date currentTime) {
        return !DateUtils.addHours((Date)mao.getGmtCreate(), (int)mao.getActivityTermValidity()).before(currentTime);
    }

    private List<GoodsSkuDetail> convertOrderItemsToSkuInfo(List<OrderItems> orderItems, String activityOrdersNo) {
        ArrayList<GoodsSkuDetail> skuInfoList = new ArrayList<GoodsSkuDetail>();
        for (OrderItems item : orderItems) {
            GoodsSkuDetail skuInfo = new GoodsSkuDetail();
            skuInfo.setGoodsId(item.getGoodsId());
            skuInfo.setSkuNo(item.getGoodsSkuNo());
            skuInfo = (GoodsSkuDetail)this.goodsSkuDetailMapper.selectOne((Object)skuInfo);
            int freezeSkockNum = this.getSkockNum(item.getGoodsSkuNo(), item.getGoodsId());
            skuInfo.setStock(Integer.valueOf(skuInfo.getStock() - freezeSkockNum));
            skuInfoList.add(skuInfo);
        }
        return skuInfoList;
    }

    private int getSkockNum(String goodsSkuNo, Integer goodsId) {
        String key = REDIS_FREEZE_STOCK_KEY + goodsId + "-" + goodsSkuNo;
        try {
            ValueOperations ops = this.stringRedisTemplate.opsForValue();
            if (ops.getOperations().hasKey((Object)key).booleanValue()) {
                String s = (String)ops.get((Object)key);
                return Integer.parseInt(s);
            }
            return 0;
        }
        catch (NumberFormatException e) {
            log.error(e.getMessage());
            throw new CustomException("redis\u5f02\u5e38");
        }
    }

    private void checkUserInfo(Orders orders) {
        if (orders.getUserId() == null && StringUtils.isEmpty((Object)orders.getUserNo())) {
            throw new IllegalArgumentException("\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
    }

    private void checkActivityNo(String activityNo) {
        if (StringUtils.isEmpty((Object)activityNo)) {
            throw new IllegalArgumentException("\u6d3b\u52a8\u7f16\u53f7\u4e3a\u7a7a");
        }
    }

    private void checkGoodsItem(List<OrderItems> items) {
        if (items == null || items.isEmpty()) {
            throw new CustomException("\u672a\u9009\u62e9\u5546\u54c1");
        }
        if (items.size() > 1) {
            throw new CustomException("\u62fc\u56e2\u5546\u54c1\u53ea\u80fd\u9009\u62e91\u4ef6");
        }
        for (OrderItems item : items) {
            if (item.getSaleQuantity() > 0) continue;
            throw new CustomException("\u5546\u54c1" + item.getGoodsName() + "[" + item.getGoodsSkuName() + "]\u6570\u91cf\u6709\u8bef");
        }
    }

    private void checkOrdersShippingInfo(Orders orders) {
        InputValidator.checkEmpty((Object)orders.getShippingName(), (String)"\u6536\u8d27\u4eba\u59d3\u540d");
        InputValidator.checkEmpty((Object)orders.getShippingMobile(), (String)"\u624b\u673a\u53f7\u7801");
        InputValidator.checkEmpty((Object)orders.getShippingProvince(), (String)"\u7701\u4efd");
        InputValidator.checkEmpty((Object)orders.getShippingCity(), (String)"\u57ce\u5e02");
        InputValidator.checkEmpty((Object)orders.getShippingDistrict(), (String)"\u5730\u533a");
        InputValidator.checkEmpty((Object)orders.getShippingAddress(), (String)"\u8be6\u7ec6\u5730\u5740");
    }

    public void initScheduleByMarketOrders() {
        log.info("\u521d\u59cb\u5316\u3002\u3002\u3002\u53d6\u6d88\u8425\u9500\u8ba2\u5355\u8868\u4e2d\u7684\u8fc7\u671f\u8ba2\u5355\u6216\u4e3a\u672a\u8fc7\u671f\u8ba2\u5355\u6dfb\u52a0\u5b9a\u65f6\u5668\u3002\u3002\u3002\u3002");
        List reduce = this.marketActivityOrdersMapper.selectActivityInfo(Integer.valueOf(0));
        List assemble = this.marketActivityOrdersMapper.selectActivityInfo(Integer.valueOf(1));
        Date current = new Date();
        if (!CollectionUtils.isEmpty((Collection)reduce)) {
            this.initToCancleReduce(reduce, current);
            List reduceCollect = reduce.stream().map(e -> e.getActivityOrdersNo()).collect(Collectors.toList());
            log.info("\u521d\u59cb\u5316initToCancle\u5904\u7406\u7684\u780d\u4ef7\u8ba2\u5355\u53f7\u96c6\u5408:[{}]", (Object)reduceCollect.toString());
        }
        if (!CollectionUtils.isEmpty((Collection)assemble)) {
            this.initToCancelAssemble(assemble, current);
            List assembleCollect = assemble.stream().map(e -> e.getActivityOrdersNo()).collect(Collectors.toList());
            log.info("\u521d\u59cb\u5316initToCancle\u5904\u7406\u7684\u62fc\u56e2\u8ba2\u5355\u53f7\u96c6\u5408:[{}]", (Object)assembleCollect.toString());
        }
    }

    private void initToCancelAssemble(List<MarketActivityOrders> assemble, Date current) {
        if (CollectionUtils.isEmpty(assemble)) {
            return;
        }
        for (MarketActivityOrders mao : assemble) {
            Date date = DateUtils.addHours((Date)mao.getGmtCreate(), (int)mao.getActivityTermValidity());
            if (date.after(current)) {
                long time = date.getTime() - current.getTime();
                this.scheduledThreadPoolExecutor.schedule(() -> {
                    log.error("initService\u53d6\u6d88\u62fc\u56e2\u6d3b\u52a8\u8ba2\u5355:[{}]", (Object)mao.getActivityOrdersNo());
                    this.assembleService.cancel(mao.getActivityOrdersNo());
                }, time, TimeUnit.HOURS);
                continue;
            }
            try {
                this.assembleService.cancel(mao.getActivityOrdersNo());
            }
            catch (Exception e) {
                log.error("initService\u53d6\u6d88\u62fc\u56e2\u6d3b\u52a8\u8ba2\u5355\u5f02\u5e38:[{}]", (Object)e.getMessage());
            }
        }
    }

    private void initToCancleReduce(List<MarketActivityOrders> reduce, Date current) {
        if (CollectionUtils.isEmpty(reduce)) {
            return;
        }
        for (MarketActivityOrders mao : reduce) {
            Date date = DateUtils.addHours((Date)mao.getGmtCreate(), (int)mao.getActivityTermValidity());
            if (date.after(current)) {
                long time = date.getTime() - current.getTime();
                this.scheduledThreadPoolExecutor.schedule(() -> {
                    log.error("initService\u53d6\u6d88\u780d\u4ef7\u6d3b\u52a8\u8ba2\u5355:[{}]", (Object)mao.getActivityOrdersNo());
                    this.cancelReducePrice(mao.getLaunchUserNo(), mao.getActivityNo(), mao.getActivityOrdersNo(), mao.getGoodsId());
                }, time, TimeUnit.HOURS);
                continue;
            }
            try {
                this.cancelReducePrice(mao.getLaunchUserNo(), mao.getActivityNo(), mao.getActivityOrdersNo(), mao.getGoodsId());
            }
            catch (Exception e) {
                log.error("initService\u53d6\u6d88\u780d\u4ef7\u6d3b\u52a8\u8ba2\u5355\u5f02\u5e38:[{}]", (Object)e.getMessage());
            }
        }
    }
}

