/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.wmeimob.fastboot.bizvane.entity.CompanyBrandRelation;
import com.wmeimob.fastboot.bizvane.entity.KafkaTrack;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.UserServiceImpl;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import com.wmeimob.fastboot.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class kafkaTrackController {
    private static final Logger log = LoggerFactory.getLogger(kafkaTrackController.class);
    @Resource
    private BizvaneInterface bizvaneInterface;
    @Resource
    private UserServiceImpl userServiceImpl;

    @PostMapping(value={"/kafkaTrack"})
    public RestResult kafkaTrack(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody KafkaTrack kafkaTrack) {
        log.info("\u884c\u4e3a\u5206\u6790\u63a5\u53e3\u3002\u3002\u3002");
        CompanyBrandRelation companyBrandRelation = this.userServiceImpl.getCompany(merchantId);
        if (companyBrandRelation == null) {
            throw new CustomException("\u54c1\u724c\u4e0e\u4f01\u4e1a\u4e3a\u5173\u8054\uff0c\u8bf7\u767b\u9646\u5fae\u5546\u57ce\u540e\u53f0\u7ba1\u7406\u7cfb\u7edf\uff01");
        }
        kafkaTrack.setBrandId(companyBrandRelation.getMerchantCode());
        kafkaTrack.setBrandName(companyBrandRelation.getMerchantName());
        kafkaTrack.setCorpId(companyBrandRelation.getCompanyCode());
        kafkaTrack.setCorpName(companyBrandRelation.getCompanyName());
        kafkaTrack.setAppType("0");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        kafkaTrack.setCreateTime(sdf.format(new Date()));
        if (StringUtils.isEmpty((Object)kafkaTrack.getVipCode())) {
            User user = (User)SecurityContext.getUser();
            kafkaTrack.setVipCode(user != null ? user.getUserNo() : null);
        }
        return this.bizvaneInterface.kafkaTrack(kafkaTrack);
    }
}

