/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.tunnel.server.cluster;

import com.alibaba.arthas.tunnel.server.AgentClusterInfo;
import com.alibaba.arthas.tunnel.server.cluster.TunnelClusterStore;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.caffeine.CaffeineCache;

public class InMemoryClusterStore
implements TunnelClusterStore {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryClusterStore.class);
    private Cache cache;

    @Override
    public AgentClusterInfo findAgent(String agentId) {
        Cache.ValueWrapper valueWrapper = this.cache.get((Object)agentId);
        if (valueWrapper == null) {
            return null;
        }
        AgentClusterInfo info = (AgentClusterInfo)valueWrapper.get();
        return info;
    }

    @Override
    public void removeAgent(String agentId) {
        this.cache.evict((Object)agentId);
    }

    @Override
    public void addAgent(String agentId, AgentClusterInfo info, long timeout, TimeUnit timeUnit) {
        this.cache.put((Object)agentId, (Object)info);
    }

    @Override
    public Collection<String> allAgentIds() {
        CaffeineCache caffeineCache = (CaffeineCache)this.cache;
        com.github.benmanes.caffeine.cache.Cache nativeCache = caffeineCache.getNativeCache();
        return nativeCache.asMap().keySet();
    }

    @Override
    public Map<String, AgentClusterInfo> agentInfo(String appName) {
        CaffeineCache caffeineCache = (CaffeineCache)this.cache;
        com.github.benmanes.caffeine.cache.Cache nativeCache = caffeineCache.getNativeCache();
        ConcurrentMap map = nativeCache.asMap();
        HashMap<String, AgentClusterInfo> result = new HashMap<String, AgentClusterInfo>();
        String prefix = appName + "_";
        for (Map.Entry entry : map.entrySet()) {
            String agentId = (String)entry.getKey();
            if (!agentId.startsWith(prefix)) continue;
            result.put(agentId, (AgentClusterInfo)entry.getValue());
        }
        return result;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }
}

