/*
 * Decompiled with CFR 0.152.
 */
package com.manon.member.util;

import cn.hutool.core.util.StrUtil;
import com.nimbusds.jwt.JWTParser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TokenUtil {
    private static final Pattern authorizationPattern = Pattern.compile("^Bearer (?<token>[a-zA-Z0-9-._~+/]+)=*$");

    public static String getAuthorizationToken(String authorization) {
        Matcher matcher;
        if (StrUtil.isNotBlank((CharSequence)authorization) && (matcher = authorizationPattern.matcher(authorization)).matches()) {
            return matcher.group("token");
        }
        return null;
    }

    public static String resolveJwtToken(String token, String key) {
        try {
            return JWTParser.parse((String)token).getJWTClaimsSet().getClaim(key).toString();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

