/*
 * Decompiled with CFR 0.152.
 */
package com.manon.member.util;

import com.alibaba.fastjson.JSONObject;
import com.manon.member.context.SpringContextHolder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class RedisUtil {
    private static RedisTemplate<String, Object> redisTemplate = SpringContextHolder.getBean(RedisTemplate.class);

    private RedisUtil() {
    }

    public static boolean expire(String key, long timeout) {
        return RedisUtil.expire(key, timeout, TimeUnit.SECONDS);
    }

    public static boolean expire(String key, long timeout, TimeUnit unit) {
        Boolean ret = redisTemplate.expire((Object)key, timeout, unit);
        return ret != null && ret != false;
    }

    public static boolean del(String ... keys) {
        Boolean ret = false;
        if (keys != null && keys.length > 0) {
            if (keys.length == 1) {
                ret = redisTemplate.delete((Object)keys[0]);
            } else {
                Long l = RedisUtil.del(CollectionUtils.arrayToList((Object)keys));
                if (l != 0L) {
                    ret = true;
                }
            }
        }
        return ret != null && ret != false;
    }

    public static long del(Collection<String> keys) {
        Long ret = redisTemplate.delete(keys);
        return ret == null ? 0L : ret;
    }

    public static void set(String key, Object value) {
        redisTemplate.opsForValue().set((Object)key, value);
    }

    public static void set(String key, Object value, long timeout) {
        redisTemplate.opsForValue().set((Object)key, value, timeout, TimeUnit.SECONDS);
    }

    public static void set(String key, Object value, long timeout, TimeUnit unit) {
        redisTemplate.opsForValue().set((Object)key, value, timeout, unit);
    }

    public Object get(String key) {
        return key == null ? null : redisTemplate.opsForValue().get((Object)key);
    }

    public long incr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return redisTemplate.opsForValue().increment((Object)key, delta);
    }

    public long decr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    public static void hPut(String key, String hKey, Object value) {
        redisTemplate.opsForHash().put((Object)key, (Object)hKey, value);
    }

    public static void hPutAll(String key, Map<String, Object> values) {
        redisTemplate.opsForHash().putAll((Object)key, values);
    }

    public static Object hGet(String key, String hKey) {
        return redisTemplate.opsForHash().get((Object)key, (Object)hKey);
    }

    public static List<Object> hMultiGet(String key, Collection<Object> hKeys) {
        return redisTemplate.opsForHash().multiGet((Object)key, hKeys);
    }

    public static long sSet(String key, Object ... values) {
        Long count = redisTemplate.opsForSet().add((Object)key, values);
        return count == null ? 0L : count;
    }

    public static long sDel(String key, Object ... values) {
        Long count = redisTemplate.opsForSet().remove((Object)key, values);
        return count == null ? 0L : count;
    }

    public static long lPush(String key, Object value) {
        Long count = redisTemplate.opsForList().rightPush((Object)key, value);
        return count == null ? 0L : count;
    }

    public static long lPushAll(String key, Collection<String> values) {
        Long count = redisTemplate.opsForList().rightPushAll((Object)key, new Object[]{values});
        return count == null ? 0L : count;
    }

    public static long lPushAll(String key, Object ... values) {
        Long count = redisTemplate.opsForList().rightPushAll((Object)key, values);
        return count == null ? 0L : count;
    }

    public static List<Object> lGet(String key, int start, int end) {
        return redisTemplate.opsForList().range((Object)key, (long)start, (long)end);
    }

    public long lGetListSize(String key) {
        return redisTemplate.opsForList().size((Object)key);
    }

    public void setForTimeMS(String key, String value, long time) {
        redisTemplate.opsForValue().set((Object)key, (Object)value, time, TimeUnit.MILLISECONDS);
    }

    public void setForTimeMIN(String key, String value, long time) {
        redisTemplate.opsForValue().set((Object)key, (Object)value, time, TimeUnit.MINUTES);
    }

    public void setForTimeCustom(String key, String value, long time, TimeUnit type) {
        redisTemplate.opsForValue().set((Object)key, (Object)value, time, type);
    }

    public <T> void setForTimeCustom(String key, T obj, long time, TimeUnit type) {
        String value = RedisUtil.toJson(obj);
        this.setForTimeCustom(key, value, time, type);
    }

    public String getAndSet(String key, String value) {
        return (String)redisTemplate.opsForValue().getAndSet((Object)key, (Object)value);
    }

    public void batchSet(Map<String, String> keyAndValue) {
        redisTemplate.opsForValue().multiSet(keyAndValue);
    }

    public void batchSetIfAbsent(Map<String, String> keyAndValue) {
        redisTemplate.opsForValue().multiSetIfAbsent(keyAndValue);
    }

    public Long increment(String key, long number) {
        return redisTemplate.opsForValue().increment((Object)key, number);
    }

    public Double increment(String key, double number) {
        return redisTemplate.opsForValue().increment((Object)key, number);
    }

    public boolean persist(String key) {
        return redisTemplate.boundValueOps((Object)key).persist();
    }

    public Long getExpire(String key) {
        return redisTemplate.boundValueOps((Object)key).getExpire();
    }

    public void rename(String key, String newKey) {
        redisTemplate.boundValueOps((Object)key).rename((Object)newKey);
    }

    public boolean delete(String key) {
        return redisTemplate.delete((Object)key);
    }

    public void put(String key, String hashKey, String value) {
        redisTemplate.opsForHash().put((Object)key, (Object)hashKey, (Object)value);
    }

    public void putAll(String key, Map<String, String> map) {
        redisTemplate.opsForHash().putAll((Object)key, map);
    }

    public boolean putIfAbsent(String key, String hashKey, String value) {
        return redisTemplate.opsForHash().putIfAbsent((Object)key, (Object)hashKey, (Object)value);
    }

    public Long delete(String key, String ... hashKeys) {
        return redisTemplate.opsForHash().delete((Object)key, (Object[])hashKeys);
    }

    public Long increment(String key, String hashKey, long number) {
        return redisTemplate.opsForHash().increment((Object)key, (Object)hashKey, number);
    }

    public Double increment(String key, String hashKey, Double number) {
        return redisTemplate.opsForHash().increment((Object)key, (Object)hashKey, number.doubleValue());
    }

    public Object getHashKey(String key, String hashKey) {
        return redisTemplate.opsForHash().get((Object)key, (Object)hashKey);
    }

    public Map<Object, Object> getHashEntries(String key) {
        return redisTemplate.opsForHash().entries((Object)key);
    }

    public boolean hashKey(String key, String hashKey) {
        return redisTemplate.opsForHash().hasKey((Object)key, (Object)hashKey);
    }

    public Set<Object> hashKeys(String key) {
        return redisTemplate.opsForHash().keys((Object)key);
    }

    public Long hashSize(String key) {
        return redisTemplate.opsForHash().size((Object)key);
    }

    public Long leftPush(String key, Object value) {
        return redisTemplate.opsForList().leftPush((Object)key, value);
    }

    public Object leftPop(String key) {
        return redisTemplate.opsForList().leftPop((Object)key);
    }

    public Long leftPushAll(String key, Collection<String> values) {
        return redisTemplate.opsForList().leftPushAll((Object)key, new Object[]{values});
    }

    public Long rightPush(String key, Object value) {
        return redisTemplate.opsForList().rightPush((Object)key, value);
    }

    public Object rightPop(String key) {
        return redisTemplate.opsForList().rightPop((Object)key);
    }

    public Long rightPushAll(String key, Collection<String> values) {
        return redisTemplate.opsForList().rightPushAll((Object)key, new Object[]{values});
    }

    public Object popIndex(String key, long index) {
        return redisTemplate.opsForList().index((Object)key, index);
    }

    public Long listSize(String key, long index) {
        return redisTemplate.opsForList().size((Object)key);
    }

    public List<Object> listRange(String key, long start, long end) {
        return redisTemplate.opsForList().range((Object)key, start, end);
    }

    public Long listRemove(String key, long count, Object value) {
        return redisTemplate.opsForList().remove((Object)key, count, value);
    }

    public void listTrim(String key, long start, long end) {
        redisTemplate.opsForList().trim((Object)key, start, end);
    }

    public Object rightPopAndLeftPush(String key, String key2) {
        return redisTemplate.opsForList().rightPopAndLeftPush((Object)key, (Object)key2);
    }

    public Long add(String key, String ... values) {
        return redisTemplate.opsForSet().add((Object)key, (Object[])values);
    }

    public Set<Object> difference(String key, String otherkey) {
        return redisTemplate.opsForSet().difference((Object)key, (Object)otherkey);
    }

    public Set<Object> difference(String key, Collection<String> otherKeys) {
        return redisTemplate.opsForSet().difference((Object)key, otherKeys);
    }

    public Long differenceAndStore(String key, String otherkey, String newKey) {
        return redisTemplate.opsForSet().differenceAndStore((Object)key, (Object)otherkey, (Object)newKey);
    }

    public Long differenceAndStore(String key, Collection<String> otherKeys, String newKey) {
        return redisTemplate.opsForSet().differenceAndStore((Object)newKey, otherKeys, (Object)newKey);
    }

    public Long remove(String key, Object ... values) {
        return redisTemplate.opsForSet().remove((Object)key, values);
    }

    public Object randomSetPop(String key) {
        return redisTemplate.opsForSet().pop((Object)key);
    }

    public Object randomSet(String key) {
        return redisTemplate.opsForSet().randomMember((Object)key);
    }

    public List<Object> randomSet(String key, long count) {
        return redisTemplate.opsForSet().randomMembers((Object)key, count);
    }

    public Set<Object> randomSetDistinct(String key, long count) {
        return redisTemplate.opsForSet().distinctRandomMembers((Object)key, count);
    }

    public boolean moveSet(String key, Object value, String destKey) {
        return redisTemplate.opsForSet().move((Object)key, value, (Object)destKey);
    }

    public Long setSize(String key) {
        return redisTemplate.opsForSet().size((Object)key);
    }

    public boolean isMember(String key, Object value) {
        return redisTemplate.opsForSet().isMember((Object)key, value);
    }

    public Set<Object> unionSet(String key, String otherKey) {
        return redisTemplate.opsForSet().union((Object)key, (Object)otherKey);
    }

    public Set<Object> unionSet(String key, Collection<String> otherKeys) {
        return redisTemplate.opsForSet().union((Object)key, otherKeys);
    }

    public Long unionAndStoreSet(String key, String otherKey, String destKey) {
        return redisTemplate.opsForSet().unionAndStore((Object)key, (Object)otherKey, (Object)destKey);
    }

    public Long unionAndStoreSet(String key, Collection<String> otherKeys, String destKey) {
        return redisTemplate.opsForSet().unionAndStore((Object)key, otherKeys, (Object)destKey);
    }

    public Set<Object> members(String key) {
        return redisTemplate.opsForSet().members((Object)key);
    }

    public boolean add(String key, Object value, double score) {
        return redisTemplate.opsForZSet().add((Object)key, value, score);
    }

    public Long batchAddZset(String key, Set<ZSetOperations.TypedTuple<Object>> tuples) {
        return redisTemplate.opsForZSet().add((Object)key, tuples);
    }

    public Long removeZset(String key, String ... values) {
        return redisTemplate.opsForZSet().remove((Object)key, (Object[])values);
    }

    public Double incrementScore(String key, Object value, double score) {
        return redisTemplate.opsForZSet().incrementScore((Object)key, value, score);
    }

    public Long rank(String key, Object value) {
        return redisTemplate.opsForZSet().rank((Object)key, value);
    }

    public Long reverseRank(String key, Object value) {
        return redisTemplate.opsForZSet().reverseRank((Object)key, value);
    }

    public Set<ZSetOperations.TypedTuple<Object>> rangeWithScores(String key, long start, long end) {
        return redisTemplate.opsForZSet().rangeWithScores((Object)key, start, end);
    }

    public Set<Object> range(String key, long start, long end) {
        return redisTemplate.opsForZSet().range((Object)key, start, end);
    }

    public Set<Object> rangeByScore(String key, double min, double max) {
        return redisTemplate.opsForZSet().rangeByScore((Object)key, min, max);
    }

    public Set<ZSetOperations.TypedTuple<Object>> rangeByScoreWithScores(String key, double min, double max) {
        return redisTemplate.opsForZSet().rangeByScoreWithScores((Object)key, min, max);
    }

    public Set<Object> rangeByScore(String key, double min, double max, long offset, long count) {
        return redisTemplate.opsForZSet().rangeByScore((Object)key, min, max, offset, count);
    }

    public Set<ZSetOperations.TypedTuple<Object>> rangeByScoreWithScores(String key, double min, double max, long offset, long count) {
        return redisTemplate.opsForZSet().rangeByScoreWithScores((Object)key, min, max, offset, count);
    }

    public Set<Object> reverseRange(String key, long start, long end) {
        return redisTemplate.opsForZSet().reverseRange((Object)key, start, end);
    }

    public Set<ZSetOperations.TypedTuple<Object>> reverseRangeWithScores(String key, long start, long end) {
        return redisTemplate.opsForZSet().reverseRangeWithScores((Object)key, start, end);
    }

    public Set<Object> reverseRangeByScore(String key, double min, double max) {
        return redisTemplate.opsForZSet().reverseRangeByScore((Object)key, min, max);
    }

    public Set<ZSetOperations.TypedTuple<Object>> reverseRangeByScoreWithScores(String key, double min, double max) {
        return redisTemplate.opsForZSet().reverseRangeByScoreWithScores((Object)key, min, max);
    }

    public Set<Object> reverseRangeByScore(String key, double min, double max, long offset, long count) {
        return redisTemplate.opsForZSet().reverseRangeByScore((Object)key, min, max, offset, count);
    }

    public Set<ZSetOperations.TypedTuple<Object>> reverseRangeByScoreWithScores(String key, double min, double max, long offset, long count) {
        return redisTemplate.opsForZSet().reverseRangeByScoreWithScores((Object)key, min, max, offset, count);
    }

    public long countZSet(String key, double min, double max) {
        return redisTemplate.opsForZSet().count((Object)key, min, max);
    }

    public long sizeZset(String key) {
        return redisTemplate.opsForZSet().size((Object)key);
    }

    public Double score(String key, Object value) {
        return redisTemplate.opsForZSet().score((Object)key, value);
    }

    public Long removeRange(String key, long start, long end) {
        return redisTemplate.opsForZSet().removeRange((Object)key, start, end);
    }

    public Long removeRangeByScore(String key, double min, double max) {
        return redisTemplate.opsForZSet().removeRangeByScore((Object)key, min, max);
    }

    public Long unionAndStoreZset(String key, String otherKey, String destKey) {
        return redisTemplate.opsForZSet().unionAndStore((Object)key, (Object)otherKey, (Object)destKey);
    }

    public Long unionAndStoreZset(String key, Collection<String> otherKeys, String destKey) {
        return redisTemplate.opsForZSet().unionAndStore((Object)key, otherKeys, (Object)destKey);
    }

    public Long intersectAndStore(String key, String otherKey, String destKey) {
        return redisTemplate.opsForZSet().intersectAndStore((Object)key, (Object)otherKey, (Object)destKey);
    }

    public static String toJson(Object obj) {
        if (obj == null) {
            return null;
        }
        return JSONObject.toJSONString((Object)obj);
    }

    public Long intersectAndStore(String key, Collection<String> otherKeys, String destKey) {
        return redisTemplate.opsForZSet().intersectAndStore((Object)key, otherKeys, (Object)destKey);
    }

    public static <T> T parseJson(String json, Class<T> clazz) {
        if (StringUtils.isEmpty((Object)json)) {
            return null;
        }
        JSONObject jsonObj = JSONObject.parseObject((String)json);
        return (T)jsonObj.toJavaObject(clazz);
    }
}

