/*
 * Decompiled with CFR 0.152.
 */
package com.manon.member.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.manon.member.page.Page;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;

public class BeanConvertUtil {
    public static <T> List<T> convertBeanList(List<?> srcList, Class<?> destType) {
        if (srcList == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (Object obj : srcList) {
            T destObj;
            if (obj instanceof Map) {
                String json = JSONObject.toJSONString(obj);
                obj = JSON.parseObject((String)json, destType);
            }
            if ((destObj = BeanConvertUtil.convertBean(obj, destType)) == null) continue;
            list.add(destObj);
        }
        return list;
    }

    public static <T, E> Page<T> convertPageInfo(PageInfo<E> source, Class<T> destinationClass) {
        if (source == null) {
            return null;
        }
        List list = source.getList();
        ArrayList resultList = Lists.newArrayList();
        for (Object sourceObject : list) {
            T destinationObject = BeanConvertUtil.convertBean(sourceObject, destinationClass);
            resultList.add(destinationObject);
        }
        Page page = new Page();
        page.setPagination(source.getPageNum(), source.getPageSize(), source.getTotal());
        page.setList(resultList);
        return page;
    }

    public static <T, E> Page<T> convertPage(Page<E> source, Class<T> destinationClass) {
        if (source == null) {
            return null;
        }
        List<E> list = source.getList();
        ArrayList resultList = Lists.newArrayList();
        for (E sourceObject : list) {
            T destinationObject = BeanConvertUtil.convertBean(sourceObject, destinationClass);
            resultList.add(destinationObject);
        }
        Page page = (Page)BeanConvertUtil.convertBean(source, Page.class);
        page.setList(resultList);
        return page;
    }

    public static <T> T convertBean(Object src, Class<?> type) {
        if (src == null) {
            return null;
        }
        T desObj = null;
        try {
            desObj = (T)type.newInstance();
            BeanConvertUtil.copyBean(src, desObj);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return desObj;
    }

    public static void copyBean(Object src, Object dest) {
        try {
            BeanUtils.copyProperties((Object)src, (Object)dest);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Object getPropertyValue(Object src, String property) {
        Object result = null;
        try {
            Class<?> cls = src.getClass();
            property = property.substring(0, 1).toUpperCase() + property.substring(1, property.length());
            Method method = cls.getMethod("get" + property, null);
            if (method != null) {
                result = method.invoke(src, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

