/*
 * Decompiled with CFR 0.152.
 */
package com.manon.member.service;

import com.google.common.collect.Maps;
import com.manon.member.dto.DTO;
import com.manon.member.page.Page;
import com.manon.member.page.PageRequest;
import com.manon.member.repository.BaseRepository;
import com.manon.member.service.CrudService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractCrudServiceImpl<D extends DTO>
implements CrudService<D> {
    @Autowired
    BaseRepository<D> baseRepository;

    protected void preSave(D dto, Map<String, Object> map) {
    }

    protected void postSave(D dto, Map<String, Object> map) {
    }

    protected void preInsert(D dto, Map<String, Object> map) {
    }

    protected void postInsert(D dto, Map<String, Object> map) {
    }

    protected void preUpdate(D dto, Map<String, Object> map) {
    }

    protected void postUpdate(D dto, Map<String, Object> map) {
    }

    protected void preDelete(String id, Map<String, Object> map) {
    }

    protected void postDelete(String id, Map<String, Object> map, boolean isDelete) {
    }

    @Override
    @Transactional(readOnly=true)
    public D getById(String id) {
        D t = this.baseRepository.getById(id);
        return t;
    }

    @Override
    @Transactional(readOnly=true)
    public List<D> list(D filters) {
        List<D> list = this.baseRepository.list(filters, ((DTO)filters).getMap());
        return list;
    }

    @Override
    @Transactional(readOnly=true)
    public Page<D> pageQuery(PageRequest pageRequest) {
        return this.baseRepository.pageQuery(pageRequest, pageRequest.getFilters().getMap());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public D insert(D dto) {
        HashMap map = Maps.newHashMap();
        this.preInsert(dto, map);
        this.preSave(dto, map);
        D d = this.baseRepository.insert(dto);
        this.postInsert(d, map);
        this.postSave(d, map);
        return d;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public D update(String id, D entity) {
        HashMap map = Maps.newHashMap();
        this.preUpdate(entity, map);
        this.preSave(entity, map);
        D d = this.baseRepository.update(id, entity);
        this.postUpdate(d, map);
        this.postSave(d, map);
        return d;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public D updateSelective(String id, D dto) {
        HashMap map = Maps.newHashMap();
        this.preUpdate(dto, map);
        D d = this.baseRepository.updateSelective(id, dto);
        this.postUpdate(d, map);
        return d;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean delete(String id) {
        HashMap map = Maps.newHashMap();
        this.preDelete(id, map);
        boolean isDelete = this.baseRepository.delete(id);
        this.postDelete(id, map, isDelete);
        return isDelete;
    }
}

