/*
 * Decompiled with CFR 0.152.
 */
package com.manon.member.page;

import com.manon.member.dto.DTO;
import com.manon.member.dto.Qry;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

public class PageRequest
implements Serializable {
    @ApiModelProperty(hidden=true)
    private DTO filters;
    @ApiModelProperty(value="\u9875\u53f7\u7801,\u9875\u7801\u4ece1\u5f00\u59cb")
    private int current;
    @ApiModelProperty(value="\u5206\u9875\u5927\u5c0f")
    private int pageSize;
    @ApiModelProperty(value="\u6392\u5e8f\u7684\u591a\u4e2a\u5217,\u5982: username desc")
    private String sortColumns;
    @ApiModelProperty(hidden=true)
    private int startRow;
    @ApiModelProperty(hidden=true)
    private int endRow;

    public PageRequest() {
        this(0, 0);
    }

    public PageRequest(DTO filters) {
        this(0, 0, filters);
    }

    public PageRequest(int current, int pageSize) {
        this(current, pageSize, (DTO)null);
    }

    public PageRequest(int current, int pageSize, DTO filters) {
        this(current, pageSize, filters, null);
    }

    public PageRequest(int current, int pageSize, String sortColumns) {
        this(current, pageSize, null, sortColumns);
    }

    public PageRequest(int current, int pageSize, DTO filters, String sortColumns) {
        this.current = current;
        this.pageSize = pageSize;
        this.setFilters(filters);
        this.setSortColumns(sortColumns);
    }

    public PageRequest(DTO filters, int current, int pageSize, String sortColumns, int startRow, int endRow) {
        this.filters = filters;
        this.current = current;
        this.pageSize = pageSize;
        this.sortColumns = sortColumns;
        this.startRow = startRow;
        this.endRow = endRow;
    }

    public static PageRequest build(int current, int pageSize) {
        return new PageRequest(current, pageSize);
    }

    public static PageRequest build(int current, int pageSize, DTO filters) {
        return new PageRequest(current, pageSize, filters);
    }

    public static PageRequest build(int current, int pageSize, DTO filters, String sortColumns) {
        return new PageRequest(current, pageSize, filters, sortColumns);
    }

    public static PageRequest build(Qry qry) {
        return new PageRequest(qry.getCurrent(), qry.getPageSize(), qry, qry.getOrderByClause());
    }

    public DTO getFilters() {
        return this.filters;
    }

    public int getCurrent() {
        return this.current;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getSortColumns() {
        return this.sortColumns;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public void setFilters(DTO filters) {
        this.filters = filters;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setSortColumns(String sortColumns) {
        this.sortColumns = sortColumns;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public void setEndRow(int endRow) {
        this.endRow = endRow;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageRequest)) {
            return false;
        }
        PageRequest other = (PageRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DTO this$filters = this.getFilters();
        DTO other$filters = other.getFilters();
        if (this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters)) {
            return false;
        }
        if (this.getCurrent() != other.getCurrent()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        String this$sortColumns = this.getSortColumns();
        String other$sortColumns = other.getSortColumns();
        if (this$sortColumns == null ? other$sortColumns != null : !this$sortColumns.equals(other$sortColumns)) {
            return false;
        }
        if (this.getStartRow() != other.getStartRow()) {
            return false;
        }
        return this.getEndRow() == other.getEndRow();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DTO $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        result = result * 59 + this.getCurrent();
        result = result * 59 + this.getPageSize();
        String $sortColumns = this.getSortColumns();
        result = result * 59 + ($sortColumns == null ? 43 : $sortColumns.hashCode());
        result = result * 59 + this.getStartRow();
        result = result * 59 + this.getEndRow();
        return result;
    }

    public String toString() {
        return "PageRequest(filters=" + this.getFilters() + ", current=" + this.getCurrent() + ", pageSize=" + this.getPageSize() + ", sortColumns=" + this.getSortColumns() + ", startRow=" + this.getStartRow() + ", endRow=" + this.getEndRow() + ")";
    }
}

