/*
 * Decompiled with CFR 0.152.
 */
package com.manon.member.excel;

import cn.hutool.core.util.ReflectUtil;
import com.google.common.collect.Lists;
import com.manon.member.excel.annotation.Excel;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class ExcelUtil {
    public static List<String> getHeadRow(Class c) {
        Field[] fields;
        ArrayList excelNameList = Lists.newArrayList();
        for (Field field : fields = ReflectUtil.getFields((Class)c)) {
            if (!field.isAnnotationPresent(Excel.class)) continue;
            Excel annotation = field.getAnnotation(Excel.class);
            excelNameList.add(annotation.value());
        }
        return excelNameList;
    }

    public static List<Object> getRows(List<Object> dataList, Class c) throws Exception {
        ArrayList rows = Lists.newArrayList();
        for (Object object : dataList) {
            rows.add(ExcelUtil.getRowObj(object, c));
        }
        return rows;
    }

    public static List<Object> getRows(List<Object> dataList, Class c, String fieldName) throws Exception {
        ArrayList rows = Lists.newArrayList();
        for (Object object : dataList) {
            Object fieldValue = ReflectUtil.getFieldValue((Object)object, (String)fieldName);
            if (fieldValue instanceof List) {
                List list = (List)fieldValue;
                for (Object o : list) {
                    rows.add(ExcelUtil.getRowObj(o, c));
                }
                continue;
            }
            rows.add(ExcelUtil.getRowObj(fieldValue, c));
        }
        return rows;
    }

    public static List<Object> getRowObj(Object obj, Class c) {
        Field[] fields = ReflectUtil.getFields((Class)c);
        ArrayList vList = Lists.newArrayList();
        for (Field field : fields) {
            if (!field.isAnnotationPresent(Excel.class)) continue;
            Object fieldValue1 = ReflectUtil.getFieldValue((Object)obj, (String)field.getName());
            vList.add(fieldValue1);
        }
        return vList;
    }
}

