/*
 * Decompiled with CFR 0.152.
 */
package com.manon.member.eventbus;

import cn.hutool.core.collection.CollUtil;
import com.google.common.eventbus.EventBus;
import com.manon.member.event.DomainEventPublisher;
import com.manon.member.eventbus.EventBusListener;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.lang.Nullable;

@Configuration
@ConditionalOnClass(value={EventBus.class})
public class EventBusAutoConfiguration
implements ApplicationListener<ContextRefreshedEvent>,
ApplicationContextAware {
    @Nullable
    private ApplicationContext applicationContext;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        Map beansWithAnnotation = this.applicationContext.getBeansWithAnnotation(EventBusListener.class);
        List listeners = beansWithAnnotation.entrySet().stream().map(entry -> entry.getValue()).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(listeners)) {
            for (Object listener : listeners) {
                DomainEventPublisher.asyncEventBus.register(listener);
                DomainEventPublisher.syncEventBus.register(listener);
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

