/*
 * Decompiled with CFR 0.152.
 */
package com.ifly.qxb.uap.client.web.filter;

import com.ifly.qxb.uap.client.constants.SSOConstants;
import com.ifly.qxb.uap.client.entity.SSOUser;
import com.ifly.qxb.uap.client.web.filter.SSOFilter;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Base64Utils;

public class SSOVueFilter
extends SSOFilter {
    @Override
    protected void redirectSSOServiceUrl(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.getWriter().print(this.getNoLoginResponse(String.format("%s/login?service=%s", this.ssoUrl, this.getSSOServiceUrl(request))));
    }

    @Override
    protected void redirectClientServiceUrl(SSOUser user, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.getWriter().print(this.getNoLoginResponse(this.getSSOReturnUrl(request)));
    }

    @Override
    protected String getSSOServiceUrl(HttpServletRequest request) {
        String url = null == request.getQueryString() ? request.getHeader("hash") : (request.getQueryString().contains("ticket") ? (StringUtils.isNotEmpty((CharSequence)request.getParameter("ssoQuery")) ? String.format("%s?%s=%s", request.getHeader("hash"), "ssoQuery", request.getParameter("ssoQuery")) : request.getHeader("hash")) : String.format("%s?%s=%s", request.getHeader("hash"), "ssoQuery", Base64Utils.encodeToString((byte[])request.getQueryString().getBytes())));
        return StringUtils.isBlank((CharSequence)this.clientUrl) ? StringUtils.trimToEmpty((String)url) : StringUtils.trimToEmpty((String)this.clientUrl);
    }

    @Override
    protected String getSSOReturnUrl(HttpServletRequest request) {
        String url = null == request.getQueryString() || StringUtils.isEmpty((CharSequence)request.getParameter("ssoQuery")) ? request.getHeader("hash") : request.getHeader("hash");
        return StringUtils.isBlank((CharSequence)this.clientUrl) ? StringUtils.trimToEmpty((String)url) : StringUtils.trimToEmpty((String)this.clientUrl);
    }

    @Override
    protected String getTicket(HttpServletRequest request) {
        return request.getHeader("ticket");
    }

    protected String getNoLoginResponse(String content) {
        return this.getResponse(SSOConstants.SC_LOGIN_6666, false, null, content);
    }

    protected String getResponse(int code, boolean result, String message, String content) {
        return "{\"code\":" + code + ",\"timestamp\":" + System.currentTimeMillis() + ",\"result\":" + result + ",\"message\":\"" + StringUtils.trimToEmpty((String)message) + '\"' + ",\"content\":\"" + StringUtils.trimToEmpty((String)content) + '\"' + '}';
    }
}

