/*
 * Decompiled with CFR 0.152.
 */
package com.ifly.qxb.uap.client.web.filter;

import com.ifly.qxb.uap.client.entity.SSOUser;
import com.ifly.qxb.uap.client.properties.PropertiesCacheUtil;
import com.ifly.qxb.uap.client.utils.HttpUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Base64Utils;
import org.springframework.util.PathMatcher;
import org.w3c.dom.Document;

public class SSOFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSOFilter.class);
    protected String ssoUrl;
    protected String clientUrl;
    protected String[] excludeUrls;
    protected long refreshInterval;
    protected PathMatcher pathMatcher;
    protected static final String SSOQUERY = "ssoQuery";

    public void init(FilterConfig filterConfig) throws ServletException {
        this.pathMatcher = new AntPathMatcher();
        String configPath = filterConfig.getInitParameter("configPath");
        this.ssoUrl = this.getConfigValue("sso.ssoUrl", configPath);
        this.clientUrl = this.getConfigValue("sso.clientUrl", configPath);
        this.refreshInterval = Long.parseLong(this.getConfigValue("sso.refreshInterval", configPath));
        String excludeUrl = this.getConfigValue("sso.excludeUrl", configPath);
        if (StringUtils.isNotEmpty((CharSequence)excludeUrl)) {
            this.excludeUrls = excludeUrl.split(",");
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        long exitTimes;
        SSOUser ssoUser;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (ArrayUtils.isNotEmpty((Object[])this.excludeUrls)) {
            for (String item : this.excludeUrls) {
                if (!this.pathMatcher.match(item, request.getServletPath())) continue;
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
        }
        if (null != (ssoUser = this.getSSOUser(request, response)) && StringUtils.isNotEmpty((CharSequence)ssoUser.getAccountName()) && ((exitTimes = (System.currentTimeMillis() - ssoUser.getTimestamp()) / 1000L) < this.refreshInterval || this.isLogin(request, response))) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String ticket = this.getTicket(request);
        if (StringUtils.isNotEmpty((CharSequence)ticket)) {
            try {
                SSOUser user = new SSOUser();
                if (this.validateST(ticket, user, request)) {
                    this.setSSOUser(user, request, response);
                    this.redirectClientServiceUrl(user, request, response);
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error("\u9a8c\u8bc1ticket\u5931\u8d25", (Throwable)e);
            }
        }
        this.setSSOUser(new SSOUser(), request, response);
        if (this.isAjax(request)) {
            response.setHeader("sessionstatus", "timeout");
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            this.redirectSSOServiceUrl(request, response);
        }
    }

    protected String getTicket(HttpServletRequest request) {
        return request.getParameter("ticket");
    }

    protected void redirectSSOServiceUrl(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String redirectSSOServiceUrl = String.format("%s/login?service=%s", this.ssoUrl, this.getSSOServiceUrl(request));
        LOGGER.info("==>redirectSSOServiceUrl:{}", (Object)redirectSSOServiceUrl);
        response.sendRedirect(redirectSSOServiceUrl);
    }

    protected void redirectClientServiceUrl(SSOUser user, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String redirectClientServiceUrl = this.getSSOReturnUrl(request);
        LOGGER.info("==>redirectClientServiceUrl:{}", (Object)redirectClientServiceUrl);
        response.sendRedirect(redirectClientServiceUrl);
    }

    protected void setSSOUser(SSOUser user, HttpServletRequest request, HttpServletResponse response) {
        request.getSession().setAttribute("sso_user_session", (Object)user);
    }

    protected SSOUser getSSOUser(HttpServletRequest request, HttpServletResponse response) {
        return (SSOUser)request.getSession().getAttribute("sso_user_session");
    }

    protected String getSSOServiceUrl(HttpServletRequest request) {
        String url = null == request.getQueryString() ? request.getRequestURL().toString() : (request.getQueryString().contains("ticket") ? (StringUtils.isNotEmpty((CharSequence)request.getParameter(SSOQUERY)) ? String.format("%s?%s=%s", request.getRequestURL().toString(), SSOQUERY, request.getParameter(SSOQUERY)) : request.getRequestURL().toString()) : String.format("%s?%s=%s", request.getRequestURL().toString(), SSOQUERY, Base64Utils.encodeToString((byte[])request.getQueryString().getBytes())));
        return StringUtils.isEmpty((CharSequence)this.clientUrl) ? url : this.clientUrl;
    }

    protected String getSSOReturnUrl(HttpServletRequest request) {
        String url;
        if (null == request.getQueryString() || StringUtils.isEmpty((CharSequence)request.getParameter(SSOQUERY))) {
            url = request.getRequestURL().toString();
        } else {
            String params = new String(Base64Utils.decodeFromString((String)request.getParameter(SSOQUERY)));
            url = String.format("%s?%s", request.getRequestURL().toString(), params);
        }
        return StringUtils.isEmpty((CharSequence)this.clientUrl) ? url : this.clientUrl;
    }

    protected String getConfigValue(String key, String propName) {
        return PropertiesCacheUtil.getValue(key, propName);
    }

    protected String getConfigValue(String key, String propName, String deafultValue) {
        return PropertiesCacheUtil.getValue(key, propName, deafultValue);
    }

    private boolean validateST(String ticket, SSOUser ssoUser, HttpServletRequest request) throws Exception {
        String url = String.format("%s/p3/serviceValidate?ticket=%s&service=%s", this.ssoUrl, ticket, this.getSSOServiceUrl(request));
        LOGGER.debug("ticket\u9a8c\u8bc1\uff1a" + url);
        String content = HttpUtils.doHttpGet(url);
        LOGGER.debug("ticket\u9a8c\u8bc1\u7ed3\u679c\uff1a" + content);
        if (StringUtils.isNotBlank((CharSequence)content)) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            Document document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));
            ssoUser.setAccountName(document.getElementsByTagName("cas:userAccount").item(0).getTextContent());
            ssoUser.setName(document.getElementsByTagName("cas:userName").item(0).getTextContent());
            ssoUser.setUserSource(Integer.valueOf(document.getElementsByTagName("cas:userSource").item(0).getTextContent()));
            ssoUser.setUserId(document.getElementsByTagName("cas:userId").item(0).getTextContent());
            ssoUser.setTimestamp(System.currentTimeMillis());
            return true;
        }
        return false;
    }

    private boolean isLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String browser = request.getHeader("User-Agent");
        String userSignId = Base64Utils.encodeToString((byte[])browser.getBytes(StandardCharsets.UTF_8));
        SSOUser tempUser = this.getSSOUser(request, response);
        String url = String.format("%s/loginState/check2?userSignId=%s&userAccount=%s", this.ssoUrl, userSignId, tempUser.getAccountName());
        LOGGER.debug("\u767b\u9646\u72b6\u6001\u9a8c\u8bc1\uff1a" + url);
        String content = HttpUtils.doHttpGet(url);
        LOGGER.debug("\u767b\u9646\u72b6\u6001\u9a8c\u8bc1\u7ed3\u679c\uff1a" + content);
        if (StringUtils.isNotBlank((CharSequence)content) && Boolean.parseBoolean(content)) {
            tempUser.setTimestamp(System.currentTimeMillis());
            this.setSSOUser(tempUser, request, response);
            return true;
        }
        return false;
    }

    protected boolean isAjax(HttpServletRequest request) {
        return request.getHeader("X-Requested-With") != null && "XMLHttpRequest".equalsIgnoreCase(request.getHeader("X-Requested-With"));
    }

    public void destroy() {
    }
}

