/*
 * Decompiled with CFR 0.152.
 */
package com.ifly.qxb.uap.client.properties;

import java.io.InputStreamReader;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesUtil.class);

    public static Properties readProperties(String propName) {
        Properties properties = null;
        try {
            properties = new Properties();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            InputStreamReader inStream = new InputStreamReader(PropertiesUtil.class.getResourceAsStream(propName), "UTF-8");
            if (inStream != null) {
                properties.load(inStream);
                inStream.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("readProperties", (Object)"\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Object)e);
        }
        return properties;
    }

    public static String getValue(String key, String propName) {
        return PropertiesUtil.getValue(key, propName, null);
    }

    public static String getValue(String key, String propName, String deafultValue) {
        Properties properties = PropertiesUtil.readProperties(propName);
        if (properties != null) {
            return properties.getProperty(key, deafultValue);
        }
        return deafultValue;
    }
}

