/*
 * Decompiled with CFR 0.152.
 */
package com.ifly.qxb.uap.client.properties;

import com.ifly.qxb.uap.client.properties.PropertiesUtil;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesCacheUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesCacheUtil.class);
    private static Map<String, HashMap<String, String>> valueMap = new HashMap<String, HashMap<String, String>>();

    private static void cacheProperties(String propName) {
        Properties properties = PropertiesUtil.readProperties(propName);
        if (properties != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                LOGGER.info(MessageFormat.format("cache key={0} value={1}", key, properties.getProperty(key)));
                map.put(key, properties.getProperty(key));
            }
            valueMap.put(propName, map);
        }
    }

    public static String getValue(String key, String propName) {
        HashMap<String, String> map;
        if (!valueMap.containsKey(propName)) {
            PropertiesCacheUtil.cacheProperties(propName);
        }
        if ((map = valueMap.get(propName)).containsKey(key)) {
            return map.get(key);
        }
        return PropertiesCacheUtil.getValue(key, propName, null);
    }

    public static String getValue(String key, String propName, String deafultValue) {
        HashMap<String, String> map;
        if (!valueMap.containsKey(propName)) {
            PropertiesCacheUtil.cacheProperties(propName);
        }
        if ((map = valueMap.get(propName)).containsKey(key)) {
            return map.get(key);
        }
        return PropertiesUtil.getValue(key, propName, deafultValue);
    }
}

