package com.daas.nros.connector.weimob.api;


import com.daas.nros.connector.model.po.SysCrmWmFieldMappingPO;

/**
 * CRM 与 微盟字段映射关系
 */
public interface SysCrmWmFieldMappingService {

    /**
     * 插入CRM 与 微盟字段映射
     *
     * @param entity
     * @return
     */
    Boolean insertSysCrmWmFieldMapping(SysCrmWmFieldMappingPO entity);

    /**
     * 根据crm的字段和类型，查找对应的微盟字段
     *
     * @param crmField
     * @return
     */
    String findWmFieldByCrmField(String crmField, int type);

    /**
     * 根据crm的字段和类型，查找对应的微盟字段, 返回指定类型
     *
     * @param crmField
     * @return
     */
    Long findWmFieldByCrmField(String crmField, int type, Class<Long> targetClass);

    /**
     * 根据crm的字段和类型，查找对应的微盟字段, 返回指定类型
     *
     * @param crmField
     * @return
     */
    Long findWmFieldByCrmFieldForLong(String crmField, int type);

    /**
     * 初始化
     *
     * @param wmField
     * @param crmField
     * @param mappingType
     * @return
     */
    SysCrmWmFieldMappingPO initSysCrmWmFieldMappingPO(String wmField, String crmField, int mappingType);

    /**
     * 判断指定类型是否已经存在映射关系
     *
     * @param mappingType
     * @return
     */
    Boolean isExistByMappingType(int mappingType);
}
