package com.bizvane.wechat.feign.feign;

import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechat.feign.model.req.WxCreateQRCodeReq;
import com.bizvane.wechat.feign.model.req.WxGetUnlimitedQRCodeReq;
import com.bizvane.wechat.feign.model.rsp.WechatQrCodeRsp;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;


@FeignClient(value = "${feign.client.wechat.name}", path = "${feign.client.wechat.path}/wxQrCode")
public interface WechatQrCodeRpcFeign {

    @PostMapping("/createQRCode")
    @ResponseBody
    @ApiOperation(value = "获取小程序二维码")
    ResponseData<WechatQrCodeRsp> createQRCode(@RequestBody @Validated WxCreateQRCodeReq req);

    @PostMapping("/getQRCode")
    @ResponseBody
    @ApiOperation(value = "获取小程序码")
    ResponseData<WechatQrCodeRsp> getQRCode(@RequestBody @Validated WxCreateQRCodeReq req);

    @PostMapping("/getUnlimitedQRCode")
    @ResponseBody
    @ApiOperation(value = "获取不限制的小程序码")
    @Deprecated
    ResponseData<byte[]> getUnlimitedQRCode(@RequestBody @Validated WxGetUnlimitedQRCodeReq req);

    @PostMapping("/getUnlimitedQRCodeUrl")
    @ResponseBody
    @ApiOperation(value = "获取不限制的小程序码文件URL")
    ResponseData<WechatQrCodeRsp> getUnlimitedQRCodeUrl(@RequestBody @Validated WxGetUnlimitedQRCodeReq req);
}
