package com.bizvane.wechatfacade.models.vo;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel("创建包含自定义图片的带参数的二维码")
public class QRCodeCreateContainImgRequestVO implements Serializable {
  
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "品牌id", name = "sysBrandId", required = true)
  private Long sysBrandId;
  
  @ApiModelProperty(value = "业务类型：guide-导购，store-门店, channel-渠道, trace-追踪", name = "businessType", required = true, example = "guide")
  private String businessType;
  
  @ApiModelProperty(value = "业务编号，例如业务类型是导购时，就传导购的id或者编号或者traceid", name = "businessCode", required = true, example = "1001")
  private String businessCode;
  
  @ApiModelProperty(value = "二维码中心自定义图片url", name = "logoImageUrl", required = true, example = "http://www.image.com/logo")
  private String logoImageUrl;

  @ApiModelProperty(value = "企业编号", name = "companyCode", required = true, example = "")
  private String companyCode;

  @ApiModelProperty(value = "品牌编号", name = "brandCode", required = true, example = "")
  private String brandCode;

  public String getCompanyCode() {
    return companyCode;
  }

  public void setCompanyCode(String companyCode) {
    this.companyCode = companyCode;
  }

  public String getBrandCode() {
    return brandCode;
  }

  public void setBrandCode(String brandCode) {
    this.brandCode = brandCode;
  }

  public Long getSysBrandId() {
    return sysBrandId;
  }

  public void setSysBrandId(Long sysBrandId) {
    this.sysBrandId = sysBrandId;
  }

  public String getBusinessType() {
    return businessType;
  }

  public void setBusinessType(String businessType) {
    this.businessType = businessType;
  }

  public String getBusinessCode() {
    return businessCode;
  }

  public void setBusinessCode(String businessCode) {
    this.businessCode = businessCode;
  }

  public String getLogoImageUrl() {
    return logoImageUrl;
  }

  public void setLogoImageUrl(String logoImageUrl) {
    this.logoImageUrl = logoImageUrl;
  }
  
}
