package com.bizvane.tiktokmembers.facade.vo.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 查询订单信息
 * 文档：https://partner.open-douyin.com/docs/resource/zh-CN/local-life/develop/OpenAPI/general-capabilities/order.query/query
 */

@Data
public class TiktokOrderQueryRequest {
    @ApiModelProperty(value = "商户账户ID",required = true)
    @NotBlank(message = "商户账户ID不能为空")
    private String account_id;

    @ApiModelProperty(value = "页码", example = "1",required = true)
    private Integer page_num = 1;

    @ApiModelProperty(value = "每页数量,最大100", example = "100",required = true)
    private Integer page_size = 100;

    private Long create_order_end_time;

    private Long create_order_start_time;

    private String cursor;

    private String ext_order_id;

    private Boolean get_secret_number;

    private String open_id;

    @ApiModelProperty(value = "订单ID")
    private String order_id;

    private Integer order_status;

    private Long update_order_end_time;

    private Long update_order_start_time;
}