package com.bizvane.tiktokmembers.facade.rpc;

import com.bizvane.tiktokmembers.facade.vo.req.TiktokOrderQueryRequest;
import com.bizvane.tiktokmembers.facade.vo.rsp.TiktokOrderQueryResponse;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

@FeignClient(value = "${feign.client.tiktokmembers.name}", path = "${feign.client.tiktokmembers.path}" + "/tiktokOrder")
public interface TiktokOrderServiceRpc {

    /**
     * 查询抖音订单信息
     */
    @RequestMapping(value = "/api/queryTiktokOrderInfo", method = RequestMethod.POST)
    ResponseData<TiktokOrderQueryResponse> queryTiktokOrderInfo(@RequestBody @Valid TiktokOrderQueryRequest orderQueryRequest);

}
