/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.tiktokmembers.common.utils.tiktok;

import com.bizvane.tiktokmembers.common.service.DouYinTokenService;
import com.bizvane.tiktokmembers.common.utils.tiktok.DouYinApiEnum;
import com.bizvane.tiktokmembers.facade.vo.req.TiktokOrderQueryRequest;
import com.bizvane.tiktokmembers.facade.vo.rsp.TiktokOrderQueryResponse;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class DouYinUtils {
    private static final Logger log = LoggerFactory.getLogger(DouYinUtils.class);
    private static final String BASE_URL = "https://open.douyin.com";
    @Resource
    private RestTemplate restTemplate;
    @Resource
    private DouYinTokenService douYinTokenService;

    public TiktokOrderQueryResponse queryOrderInfo(TiktokOrderQueryRequest request) {
        log.info("queryOrder: request={}", (Object)JacksonUtil.bean2Json((Object)request));
        return this.doRequest(DouYinApiEnum.ORDER_QUERY, request, TiktokOrderQueryResponse.class);
    }

    public <T> T doRequest(DouYinApiEnum api, Object request, Class<T> responseType) {
        log.info("\u5f00\u59cb\u8bf7\u6c42\u6296\u97f3\u63a5\u53e3: api={},request={},responseType={}", new Object[]{JacksonUtil.bean2Json((Object)((Object)api)), JacksonUtil.bean2Json((Object)request), responseType.getName()});
        String token = this.douYinTokenService.getAccessToken();
        if (StringUtils.isEmpty((Object)token)) {
            log.error("\u83b7\u53d6\u6296\u97f3 token \u5931\u8d25");
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("access-token", token);
        headers.set("content-type", "application/json");
        String url = BASE_URL + api.getPath();
        ResponseEntity response = null;
        try {
            if ("GET".equals(api.getMethod())) {
                String queryString = this.convertToQueryString(request);
                url = url + "?" + queryString;
                log.info("GET\u7c7b\u578b\u8bf7\u6c42\u6296\u97f3\u63a5\u53e3: {}", (Object)url);
                response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), responseType, new Object[0]);
            } else if ("POST".equals(api.getMethod())) {
                if (request == null) {
                    request = new Object();
                }
                log.info("GET\u7c7b\u578b\u8bf7\u6c42\u6296\u97f3\u63a5\u53e3: {}, \u8bf7\u6c42\u53c2\u6570: {}", (Object)url, (Object)JacksonUtil.bean2Json((Object)request));
                HttpEntity entity = new HttpEntity(request, (MultiValueMap)headers);
                response = this.restTemplate.exchange(url, HttpMethod.POST, entity, responseType, new Object[0]);
            } else {
                log.info("\u5176\u4ed6\u7c7b\u578b\u8bf7\u6c42\u6296\u97f3\u63a5\u53e3: {},{},{}", new Object[]{api.getMethod(), url, JacksonUtil.bean2Json((Object)request)});
                response = this.restTemplate.exchange(url, HttpMethod.valueOf((String)api.getMethod()), new HttpEntity(request, (MultiValueMap)headers), responseType, new Object[0]);
            }
        }
        catch (Exception e) {
            log.error("\u6296\u97f3\u63a5\u53e3\u8c03\u7528\u5931\u8d25: api={},error={}", (Object)JacksonUtil.bean2Json((Object)((Object)api)), (Object)e.getMessage());
            log.error("\u6296\u97f3\u63a5\u53e3\u8c03\u7528\u5931\u8d25:", (Throwable)e);
            return null;
        }
        log.info("\u5f00\u59cb\u8bf7\u6c42\u6296\u97f3\u63a5\u53e3: api={},request={},responseType={},rsp={}", new Object[]{JacksonUtil.bean2Json((Object)((Object)api)), JacksonUtil.bean2Json((Object)request), responseType.getName(), JacksonUtil.bean2Json((Object)response)});
        return (T)response.getBody();
    }

    private String convertToQueryString(Object obj) {
        if (obj == null) {
            return "";
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.convertValue(obj, (TypeReference)new TypeReference<Object>(){});
            return map.entrySet().stream().filter(e -> e.getValue() != null).map(e -> (String)e.getKey() + "=" + this.encode(String.valueOf(e.getValue()))).collect(Collectors.joining("&"));
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u53c2\u6570\u8f6c\u6362\u5931\u8d25", (Throwable)e2);
            return "";
        }
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }
}

